/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons.congestion;

import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.commons.congestion.CongestionMonitor;

public class MemoryCongestionMonitor
implements CongestionMonitor {
    private static final Logger logger = Logger.getLogger(MemoryCongestionMonitor.class);
    private static final String SOURCE = "MEMORY";
    private final FastList<CongestionListener> listeners = new FastList();
    private double maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0;
    private volatile double percentageOfMemoryUsed;
    private volatile boolean memoryTooHigh = false;
    private int backToNormalMemoryThreshold;
    private int memoryThreshold;

    public void setBackToNormalMemoryThreshold(int backToNormalMemoryThreshold) {
        this.backToNormalMemoryThreshold = backToNormalMemoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back To Normal Memory threshold set to " + backToNormalMemoryThreshold + "%"));
        }
    }

    public int getBackToNormalMemoryThreshold() {
        return this.backToNormalMemoryThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Memory threshold set to " + this.memoryThreshold + "%"));
        }
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void monitor() {
        block5: {
            block4: {
                Runtime runtime = Runtime.getRuntime();
                double allocatedMemory = (double)runtime.totalMemory() / 1024.0;
                double freeMemory = (double)runtime.freeMemory() / 1024.0;
                double totalFreeMemory = freeMemory + (this.maxMemory - allocatedMemory);
                this.percentageOfMemoryUsed = 100.0 - totalFreeMemory / this.maxMemory * 100.0;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Percentage of Memory Used = " + this.percentageOfMemoryUsed));
                }
                if (!this.memoryTooHigh) break block4;
                if (!(this.percentageOfMemoryUsed < (double)this.backToNormalMemoryThreshold)) break block5;
                logger.warn((Object)("Memory used: " + this.percentageOfMemoryUsed + "% < to the back to normal memory threshold : " + this.backToNormalMemoryThreshold));
                this.memoryTooHigh = false;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionFinish(SOURCE);
                }
                break block5;
            }
            if (this.percentageOfMemoryUsed > (double)this.memoryThreshold) {
                logger.warn((Object)("Memory used: " + this.percentageOfMemoryUsed + "% > to the memory threshold : " + this.memoryThreshold));
                this.memoryTooHigh = true;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionStart(SOURCE);
                }
            }
        }
    }

    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getSource() {
        return SOURCE;
    }
}

