/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack.management;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.EmptyConfiguration;
import org.jdiameter.client.impl.helpers.Ordinal;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.server.impl.helpers.XMLConfiguration;
import org.mobicents.diameter.stack.management.DiameterConfiguration;
import org.mobicents.diameter.stack.management.DiameterStatistic;
import org.mobicents.diameter.stack.management.NetworkPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkPeerImpl
implements NetworkPeer {
    private static final long serialVersionUID = 1L;
    private String name;
    private Boolean attemptConnect;
    private Integer rating;
    private String ip;
    private Integer portRangeLow;
    private Integer portRangeHigh;
    private String securityRef;
    private static final String DEFAULT_STRING = "default_string";
    private HashMap<String, DiameterStatistic> statistics;

    public NetworkPeerImpl(String name, Boolean attemptConnect, Integer rating) {
        this.name = name;
        this.attemptConnect = attemptConnect;
        this.rating = rating;
    }

    public NetworkPeerImpl(String name, Boolean attemptConnect, Integer rating, String ip, Integer portRangeLow, Integer portRangeHigh, String securityRef) {
        this(name, attemptConnect, rating);
        this.ip = ip;
        this.portRangeLow = portRangeLow;
        this.portRangeHigh = portRangeHigh;
        this.securityRef = securityRef;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        EmptyConfiguration config;
        if (!this.name.equals(name) && (config = this.getPeerConfiguration(name)) != null) {
            config.add((Ordinal)Parameters.PeerName, (Object)name);
            this.name = name;
        }
    }

    @Override
    public Boolean getAttemptConnect() {
        return this.attemptConnect;
    }

    @Override
    public void setAttemptConnect(Boolean attemptConnect) {
        this.attemptConnect = attemptConnect;
    }

    @Override
    public Integer getRating() {
        return this.rating;
    }

    @Override
    public void setRating(Integer rating) {
        EmptyConfiguration config = this.getPeerConfiguration(this.name);
        if (config != null) {
            config.add((Ordinal)Parameters.PeerRating, (Object)rating);
            this.rating = rating;
        }
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setIp(String ip) {
        EmptyConfiguration config = this.getPeerConfiguration(this.name);
        if (config != null) {
            config.add((Ordinal)Parameters.PeerIp, (Object)ip);
            this.ip = ip;
        }
    }

    @Override
    public Integer getPortRangeLow() {
        return this.portRangeLow;
    }

    @Override
    public Integer getPortRangeHigh() {
        return this.portRangeHigh;
    }

    @Override
    public void setPortRange(Integer portRangeLow, Integer portRangeHigh) {
        EmptyConfiguration config = this.getPeerConfiguration(this.name);
        if (config != null) {
            config.add((Ordinal)Parameters.PeerLocalPortRange, (Object)(portRangeLow + "-" + portRangeHigh));
            this.portRangeLow = portRangeLow;
            this.portRangeHigh = portRangeHigh;
        }
    }

    @Override
    public String getSecurityRef() {
        return this.securityRef;
    }

    @Override
    public void setSecurityRef(String securityRef) {
        this.securityRef = securityRef;
    }

    public String toString() {
        String dotsString = " .............................................................";
        StringBuffer toStringBuffer = new StringBuffer();
        try {
            Class<?> cls = Class.forName(this.getClass().getName());
            Field[] fieldlist = cls.getDeclaredFields();
            for (int i = 0; i < fieldlist.length; ++i) {
                Field fld = fieldlist[i];
                if (Modifier.isStatic(fld.getModifiers())) continue;
                toStringBuffer.append(fld.getName());
                int dots = 60 - fld.getName().length();
                toStringBuffer.append(dotsString, 0, dots);
                toStringBuffer.append(" ").append(fld.get(this)).append("\r\n");
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return toStringBuffer.toString();
    }

    private EmptyConfiguration getPeerConfiguration(String name) {
        Configuration[] peerTable;
        XMLConfiguration configuration = (XMLConfiguration)DiameterConfiguration.stack.getMetaData().getConfiguration();
        for (Configuration curPeer : peerTable = configuration.getChildren(Parameters.PeerTable.ordinal())) {
            if (!curPeer.getStringValue(Parameters.PeerName.ordinal(), DEFAULT_STRING).equals(name)) continue;
            return (EmptyConfiguration)curPeer;
        }
        return null;
    }

    @Override
    public HashMap<String, DiameterStatistic> getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(HashMap<String, DiameterStatistic> statistics) {
        this.statistics = statistics;
    }
}

