/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import org.jboss.system.ServiceMBeanSupport;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationAlreadyUseException;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Message;
import org.jdiameter.api.MutableConfiguration;
import org.jdiameter.api.MutablePeerTable;
import org.jdiameter.api.Network;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Realm;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.client.impl.controller.PeerImpl;
import org.jdiameter.client.impl.helpers.AppConfiguration;
import org.jdiameter.client.impl.helpers.EmptyConfiguration;
import org.jdiameter.client.impl.helpers.Ordinal;
import org.jdiameter.common.impl.validation.DictionaryImpl;
import org.jdiameter.server.impl.NetworkImpl;
import org.jdiameter.server.impl.StackImpl;
import org.jdiameter.server.impl.helpers.Parameters;
import org.jdiameter.server.impl.helpers.XMLConfiguration;
import org.mobicents.diameter.api.DiameterMessageFactory;
import org.mobicents.diameter.api.DiameterProvider;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.diameter.stack.DiameterStackProxy;
import org.mobicents.diameter.stack.management.DiameterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiameterStackMultiplexer
extends ServiceMBeanSupport
implements DiameterStackMultiplexerMBean,
DiameterProvider,
NetworkReqListener,
EventListener<Request, Answer>,
DiameterMessageFactory {
    private static final Logger logger = LoggerFactory.getLogger(DiameterStackMultiplexer.class);
    protected Stack stack = null;
    protected HashMap<DiameterListener, Collection<ApplicationId>> listenerToAppId = new HashMap(3);
    protected HashMap<Long, DiameterListener> appIdToListener = new HashMap(3);
    protected ReentrantLock lock = new ReentrantLock();
    protected DiameterProvider provider;
    private final String DEFAULT_STRING = "default_string";
    final Pattern IP_PATTERN = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");

    private void initStack() throws Exception {
        this.initStack(this.getClass().getClassLoader().getResourceAsStream("config/jdiameter-config.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStack(InputStream is) throws Exception {
        try {
            this.stack = new StackImpl();
            XMLConfiguration config = new XMLConfiguration(is);
            this.stack.init((Configuration)config);
            Network network = (Network)this.stack.unwrap(Network.class);
            Set appIds = this.stack.getMetaData().getLocalPeer().getCommonApplications();
            if (logger.isInfoEnabled()) {
                logger.info("Diameter Stack Mux :: Supporting {} applications.", (Object)appIds.size());
            }
            for (ApplicationId appId : appIds) {
                if (logger.isInfoEnabled()) {
                    logger.info("Diameter Stack Mux :: Adding Listener for [{}].", (Object)appId);
                }
                network.addNetworkReqListener((NetworkReqListener)this, new ApplicationId[]{appId});
                if (appId.getAcctAppId() != 0L) {
                    this.appIdToListener.put(appId.getAcctAppId(), null);
                    continue;
                }
                if (appId.getAuthAppId() == 0L) continue;
                this.appIdToListener.put(appId.getAuthAppId(), null);
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("Parsing AVP Dictionary file...");
                }
                AvpDictionary.INSTANCE.parseDictionary(Thread.currentThread().getContextClassLoader().getResourceAsStream("dictionary.xml"));
                if (logger.isInfoEnabled()) {
                    logger.info("AVP Dictionary file successfuly parsed!");
                }
            }
            catch (Exception e) {
                logger.error("Error while parsing dictionary file.", (Throwable)e);
            }
            this.stack.start();
        }
        finally {
            if (is != null) {
                is.close();
            }
            is = null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Diameter Stack Mux :: Successfully initialized stack.");
        }
    }

    private void doStopStack(int disconnectCause) throws Exception {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Stopping Diameter Mux Stack...");
            }
            this.stack.stop(10L, TimeUnit.SECONDS, disconnectCause);
            if (logger.isInfoEnabled()) {
                logger.info("Diameter Mux Stack Stopped Successfully.");
            }
        }
        catch (Exception e) {
            logger.error("Failure while stopping stack", (Throwable)e);
        }
        this.stack.destroy();
    }

    private DiameterListener findListener(Message message) {
        List appIds = message.getApplicationIdAvps();
        if (appIds.size() > 0) {
            for (ApplicationId appId : appIds) {
                Long appIdValue;
                DiameterListener listener;
                if (logger.isDebugEnabled()) {
                    logger.debug("Diameter Stack Mux :: findListener :: AVP AppId [" + appId + "]");
                }
                if ((listener = this.appIdToListener.get(appIdValue = Long.valueOf(appId.getAcctAppId() != 0L ? appId.getAcctAppId() : appId.getAuthAppId()))) == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Diameter Stack Mux :: findListener :: Found Listener [" + listener + "]");
                }
                return listener;
            }
        } else {
            DiameterListener listener;
            Long appId = message.getApplicationId();
            if (logger.isDebugEnabled()) {
                logger.debug("Diameter Stack Mux :: findListener :: Header AppId [" + appId + "]");
            }
            if ((listener = this.appIdToListener.get(appId)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Diameter Stack Mux :: findListener :: Found Listener [" + listener + "]");
                }
                return listener;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Diameter Stack Mux :: findListener :: No Listener Found.");
        }
        return null;
    }

    public Answer processRequest(Request request) {
        DiameterListener listener;
        if (logger.isInfoEnabled()) {
            logger.info("Diameter Stack Mux :: processRequest :: Command-Code [" + request.getCommandCode() + "]");
        }
        if ((listener = this.findListener((Message)request)) != null) {
            return listener.processRequest(request);
        }
        try {
            Answer answer = request.createAnswer(3007L);
            return answer;
        }
        catch (Exception e) {
            logger.error("Failed to create APPLICATION UNSUPPORTED answer.", (Throwable)e);
            return null;
        }
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        DiameterListener listener = this.findListener((Message)request);
        if (listener != null) {
            listener.receivedSuccessMessage((Message)request, (Message)answer);
        }
    }

    public void timeoutExpired(Request request) {
        DiameterListener listener = this.findListener((Message)request);
        if (listener != null) {
            listener.timeoutExpired((Message)request);
        }
    }

    protected void startService() throws Exception {
        super.startService();
        this.initStack();
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.doStopStack(0);
    }

    @Override
    public String sendMessage(Message message) {
        try {
            Avp sessionId = null;
            Session session = null;
            sessionId = message.getAvps().getAvp(263);
            session = sessionId == null ? this.stack.getSessionFactory().getNewSession() : this.stack.getSessionFactory().getNewSession(sessionId.getUTF8String());
            session.send(message);
            return session.getSessionId();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Message sendMessageSync(Message message) {
        try {
            Avp sessionId = null;
            Session session = null;
            sessionId = message.getAvps().getAvp(263);
            session = sessionId == null ? this.stack.getSessionFactory().getNewSession() : this.stack.getSessionFactory().getNewSession(sessionId.getUTF8String());
            Future answer = session.send(message);
            return (Message)answer.get();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Message createMessage(boolean isRequest, int commandCode, long applicationId) {
        try {
            Message message = this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, ApplicationId.createByAccAppId((long)applicationId), new Avp[0]);
            message.setRequest(isRequest);
            return message;
        }
        catch (Exception e) {
            logger.error("Failure while creating message.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Message createRequest(int commandCode, long applicationId) {
        return this.createMessage(true, commandCode, applicationId);
    }

    @Override
    public Message createAnswer(int commandCode, long applicationId) {
        return this.createMessage(false, commandCode, applicationId);
    }

    @Override
    public DiameterStackMultiplexerMBean getMultiplexerMBean() {
        return this;
    }

    @Override
    public DiameterMessageFactory getMessageFactory() {
        return this;
    }

    @Override
    public DiameterProvider getProvider() {
        return this;
    }

    @Override
    public Stack getStack() {
        return new DiameterStackProxy(this.stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(DiameterListener listener, ApplicationId[] appIds) throws IllegalStateException {
        int curAppIdIndex;
        if (listener == null) {
            logger.warn("Trying to register a null Listener. Give up...");
            return;
        }
        try {
            this.lock.lock();
            Network network = (Network)this.stack.unwrap(Network.class);
            if (logger.isInfoEnabled()) {
                logger.info("Diameter Stack Mux :: Registering  " + appIds.length + " applications.");
            }
            while (curAppIdIndex < appIds.length) {
                ApplicationId appId = appIds[curAppIdIndex];
                if (logger.isInfoEnabled()) {
                    logger.info("Diameter Stack Mux :: Adding Listener for [" + appId + "].");
                }
                network.addNetworkReqListener((NetworkReqListener)this, new ApplicationId[]{appId});
                if (appId.getAcctAppId() != 0L) {
                    this.appIdToListener.put(appId.getAcctAppId(), listener);
                } else if (appId.getAuthAppId() != 0L) {
                    this.appIdToListener.put(appId.getAuthAppId(), listener);
                }
                ++curAppIdIndex;
            }
            Collection<ApplicationId> registeredAppIds = this.listenerToAppId.get(listener);
            if (registeredAppIds != null) {
                registeredAppIds.addAll(Arrays.asList(appIds));
            } else {
                this.listenerToAppId.put(listener, Arrays.asList(appIds));
            }
        }
        catch (ApplicationAlreadyUseException aaue) {
            try {
                Network network = (Network)this.stack.unwrap(Network.class);
                for (curAppIdIndex = 0; curAppIdIndex >= 0; --curAppIdIndex) {
                    ApplicationId appId = appIds[curAppIdIndex];
                    Long appIdValue = appId.getAcctAppId() != 0L ? appId.getAcctAppId() : appId.getAuthAppId();
                    this.appIdToListener.remove(appIdValue);
                    network.removeNetworkReqListener(new ApplicationId[]{appId});
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(DiameterListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("Diameter Stack Mux :: unregisterListener :: Listener [" + listener + "]");
        }
        if (listener == null) {
            logger.warn("Diameter Stack Mux :: unregisterListener :: Trying to unregister a null Listener. Give up...");
            return;
        }
        try {
            this.lock.lock();
            Collection<ApplicationId> appIds = this.listenerToAppId.remove(listener);
            if (appIds == null) {
                logger.warn("Diameter Stack Mux :: unregisterListener :: Listener has no App-Ids registered. Give up...");
                return;
            }
            Network network = (Network)this.stack.unwrap(Network.class);
            for (ApplicationId appId : appIds) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info("Diameter Stack Mux :: unregisterListener :: Unregistering AppId [" + appId + "]");
                    }
                    Long appIdValue = appId.getAcctAppId() != 0L ? appId.getAcctAppId() : appId.getAuthAppId();
                    this.appIdToListener.remove(appIdValue);
                    network.removeNetworkReqListener(new ApplicationId[]{appId});
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        catch (InternalException ie) {
            logger.error("", (Throwable)ie);
        }
        finally {
            this.lock.unlock();
        }
    }

    private MutableConfiguration getMutableConfiguration() throws MBeanException {
        return (MutableConfiguration)this.stack.getMetaData().getConfiguration();
    }

    private AppConfiguration getClientConfiguration() {
        return EmptyConfiguration.getInstance();
    }

    @Override
    public void _LocalPeer_addIPAddress(String ipAddress) throws MBeanException {
        if (this.IP_PATTERN.matcher(ipAddress).matches()) {
            Configuration[] oldIPAddressesConfig = this.getMutableConfiguration().getChildren(Parameters.OwnIPAddresses.ordinal());
            List<Configuration> newIPAddressesConfig = Arrays.asList(oldIPAddressesConfig);
            AppConfiguration newIPAddress = this.getClientConfiguration().add((Ordinal)Parameters.OwnIPAddress, (Object)ipAddress);
            newIPAddressesConfig.add((Configuration)newIPAddress);
            this.getMutableConfiguration().setChildren(Parameters.OwnIPAddresses.ordinal(), (Configuration[])newIPAddressesConfig.toArray());
            if (logger.isInfoEnabled()) {
                logger.info("Local Peer IP Address successfully changed to " + ipAddress + ". Restart to Diameter stack is needed to apply changes.");
            }
        } else {
            throw new MBeanException(new IllegalArgumentException("Invalid IP address entered (" + ipAddress + ")"));
        }
    }

    @Override
    public void _LocalPeer_removeIPAddress(String ipAddress) throws MBeanException {
        Configuration[] oldIPAddressesConfig = this.getMutableConfiguration().getChildren(Parameters.OwnIPAddresses.ordinal());
        Configuration ipAddressToRemove = null;
        List<Configuration> newIPAddressesConfig = Arrays.asList(oldIPAddressesConfig);
        for (Configuration curIPAddress : newIPAddressesConfig) {
            if (!curIPAddress.getStringValue(Parameters.OwnIPAddress.ordinal(), "default_string").equals(ipAddress)) continue;
            ipAddressToRemove = curIPAddress;
            break;
        }
        if (ipAddressToRemove != null) {
            newIPAddressesConfig.remove(ipAddressToRemove);
            this.getMutableConfiguration().setChildren(Parameters.OwnIPAddresses.ordinal(), (Configuration[])newIPAddressesConfig.toArray());
            if (logger.isInfoEnabled()) {
                logger.info("Local Peer IP Address " + ipAddress + " successfully added. Restart to Diameter stack is needed to apply changes.");
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("Local Peer IP Address " + ipAddress + " not found. No changes were made.");
        }
    }

    @Override
    public void _LocalPeer_setRealm(String realm) throws MBeanException {
        this.getMutableConfiguration().setStringValue(Parameters.OwnRealm.ordinal(), realm);
        if (logger.isInfoEnabled()) {
            logger.info("Local Peer Realm successfully changed to '" + realm + "'. Restart to Diameter stack is needed to apply changes.");
        }
    }

    @Override
    public void _LocalPeer_setURI(String uri) throws MBeanException {
        try {
            new URI(uri);
            this.getMutableConfiguration().setStringValue(Parameters.OwnDiameterURI.ordinal(), uri);
            if (logger.isInfoEnabled()) {
                logger.info("Local Peer URI successfully changed to '" + uri + "'. Restart to Diameter stack is needed to apply changes.");
            }
        }
        catch (URISyntaxException use) {
            throw new MBeanException(use);
        }
    }

    @Override
    public void _LocalPeer_setVendorId(long vendorId) throws MBeanException {
        try {
            this.getMutableConfiguration().setLongValue(Parameters.OwnVendorID.ordinal(), vendorId);
            if (logger.isInfoEnabled()) {
                logger.info("Local Peer Vendor-Id successfully changed to '" + vendorId + "'. Restart to Diameter stack is needed to apply changes.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new MBeanException(nfe);
        }
    }

    @Override
    public void _Network_Peers_addPeer(String name, boolean attemptConnect, int rating) throws MBeanException {
        try {
            NetworkImpl n = (NetworkImpl)this.stack.unwrap(Network.class);
            n.addPeer(name, "", attemptConnect);
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to add peer with name '" + name + "'");
        }
    }

    @Override
    public void _Network_Peers_removePeer(String name) throws MBeanException {
        try {
            MutablePeerTable n = (MutablePeerTable)this.stack.unwrap(PeerTable.class);
            n.removePeer(name);
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to remove peer with name '" + name + "'");
        }
    }

    @Override
    public void _Network_Realms_addPeerToRealm(String realmName, String peerName, boolean attemptConnect) throws MBeanException {
        try {
            NetworkImpl n = (NetworkImpl)this.stack.unwrap(Network.class);
            n.addPeer(peerName, realmName, attemptConnect);
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to add peer with name '" + peerName + "' to realm '" + realmName + "'");
        }
    }

    @Override
    public void _Network_Realms_addRealm(String name, String peers, long appVendorId, long appAcctId, long appAuthId, String localAction, String agentConfiguration, boolean isDynamic, int expTime) throws MBeanException {
        try {
            NetworkImpl n = (NetworkImpl)this.stack.unwrap(Network.class);
            ApplicationId appId = appAcctId == 0L ? ApplicationId.createByAuthAppId((long)appVendorId, (long)appAuthId) : ApplicationId.createByAccAppId((long)appVendorId, (long)appAcctId);
            Realm r = n.addRealm(name, appId, LocalAction.valueOf((String)localAction), agentConfiguration, isDynamic, (long)expTime);
            for (String peer : peers.split(",")) {
                ((IRealm)r).addPeerName(peer);
            }
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to add realm with name '" + name + "'.");
        }
    }

    @Override
    public void _Network_Realms_addRealm(String name, String peers, long appVendorId, long appAcctId, long appAuthId) throws MBeanException {
        this._Network_Realms_addRealm(name, peers, appVendorId, appAcctId, appAuthId, "LOCAL", null, false, 1);
    }

    @Override
    public void _Network_Realms_removePeerFromRealm(String realmName, String peerName) throws MBeanException {
        try {
            IRealmTable rt = (IRealmTable)this.stack.unwrap(IRealmTable.class);
            for (Realm r : rt.getRealms()) {
                if (!r.getName().equals(realmName)) continue;
                ((IRealm)r).removePeerName(peerName);
            }
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to add peer '" + peerName + "' from realm with '" + realmName + "'.");
        }
    }

    @Override
    public void _Network_Realms_removeRealm(String name) throws MBeanException {
        try {
            NetworkImpl n = (NetworkImpl)this.stack.unwrap(Network.class);
            n.remRealm(name);
        }
        catch (InternalException e) {
            throw new MBeanException((Exception)((Object)e), "Failed to remove realm '" + name + "'.");
        }
    }

    @Override
    public void _Parameters_setAcceptUndefinedPeer(boolean acceptUndefinedPeer) throws MBeanException {
        this.getMutableConfiguration().setBooleanValue(Parameters.AcceptUndefinedPeer.ordinal(), acceptUndefinedPeer);
    }

    @Override
    public void _Parameters_setUseUriAsFqdn(boolean useUriAsFqdn) throws MBeanException {
        this.getMutableConfiguration().setBooleanValue(Parameters.UseUriAsFqdn.ordinal(), useUriAsFqdn);
    }

    @Override
    public void _Parameters_setDuplicateTimer(long duplicateTimer) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.DuplicateTimer.ordinal(), duplicateTimer);
    }

    @Override
    public void _Parameters_setMessageTimeout(long messageTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.MessageTimeOut.ordinal(), messageTimeout);
    }

    @Override
    public void _Parameters_setStopTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.StopTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setCeaTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.CeaTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setIacTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.IacTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setDwaTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.DwaTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setDpaTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.DpaTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setRecTimeout(long stopTimeout) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.RecTimeOut.ordinal(), stopTimeout);
    }

    @Override
    public void _Parameters_setConcurrentEntity(String name, String desc, Integer size) throws MBeanException {
        for (Configuration c : this.getMutableConfiguration().getChildren(Parameters.Concurrent.ordinal())) {
            if (!name.equals(c.getStringValue(Parameters.ConcurrentEntityName.ordinal(), null))) continue;
            ((AppConfiguration)c).add((Ordinal)Parameters.ConcurrentEntityPoolSize, (Object)size);
            if (desc == null) continue;
            ((AppConfiguration)c).add((Ordinal)Parameters.ConcurrentEntityDescription, (Object)desc);
        }
    }

    @Override
    public void _Parameters_setStatisticLoggerDelay(long delay) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.StatisticsLoggerDelay.ordinal(), delay);
    }

    @Override
    public void _Parameters_setStatisticLoggerPause(long pause) throws MBeanException {
        this.getMutableConfiguration().setLongValue(Parameters.StatisticsLoggerPause.ordinal(), pause);
    }

    @Override
    public void _Validation_setEnabled(boolean enableValidation) throws MBeanException {
        ((DictionaryImpl)DictionarySingleton.getDictionary()).setEnabled(enableValidation);
    }

    @Override
    public String dumpStackConfiguration() throws MBeanException {
        return this.getMutableConfiguration().toString();
    }

    @Override
    public void startStack() throws MBeanException {
        try {
            this.stack.start();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void stopStack(int disconnectCause) throws MBeanException {
        try {
            this.stack.stop(this.getMutableConfiguration().getLongValue(Parameters.StopTimeOut.ordinal(), 10000L), TimeUnit.MILLISECONDS, disconnectCause);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public String _LocalPeer_getProductName() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getProductName();
    }

    @Override
    public Long _LocalPeer_getVendorId() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getVendorId();
    }

    @Override
    public Long _LocalPeer_getFirmware() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getFirmware();
    }

    @Override
    public String _LocalPeer_getURI() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getUri().toString();
    }

    @Override
    public String _LocalPeer_getRealmName() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getRealmName();
    }

    @Override
    public InetAddress[] _LocalPeer_getIPAddresses() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getIPAddresses();
    }

    @Override
    public Set<ApplicationId> _LocalPeer_getCommonApplicationIds() throws MBeanException {
        return this.stack.getMetaData().getLocalPeer().getCommonApplications();
    }

    @Override
    public String[] _Network_Realms_getRealms() throws MBeanException {
        Configuration[] realmEntries = this.getMutableConfiguration().getChildren(Parameters.RealmTable.ordinal())[0].getChildren(Parameters.RealmEntry.ordinal());
        String[] realmNames = new String[realmEntries.length];
        for (int i = 0; i < realmEntries.length; ++i) {
            realmNames[i] = realmEntries[i].getStringValue(Parameters.RealmName.ordinal(), "default_string");
        }
        return realmNames;
    }

    @Override
    public String[] _Network_Realms_getRealmPeers(String realmName) throws MBeanException {
        Configuration[] realmEntries = this.getMutableConfiguration().getChildren(Parameters.RealmTable.ordinal())[0].getChildren(Parameters.RealmEntry.ordinal());
        String[] realmHosts = new String[realmEntries.length];
        for (Configuration realmEntry : realmEntries) {
            String realmHostsString;
            if (!realmEntry.getStringValue(Parameters.RealmName.ordinal(), "default_string").equals(realmName) || (realmHostsString = realmEntry.getStringValue(Parameters.RealmHosts.ordinal(), "default_string")).equals("default_string")) continue;
            realmHosts = realmHostsString.replaceAll(" ", "").split(",");
        }
        return realmHosts;
    }

    @Override
    public DiameterConfiguration getDiameterConfiguration() throws MBeanException {
        return new DiameterConfiguration(this.stack);
    }

    @Override
    public boolean _LocalPeer_isActive() throws MBeanException {
        return this.stack.isActive();
    }

    @Override
    public boolean _Network_Peers_isPeerConnected(String name) throws MBeanException {
        try {
            MutablePeerTable n = (MutablePeerTable)this.stack.unwrap(PeerTable.class);
            PeerImpl p = (PeerImpl)n.getPeer(name);
            return p != null ? p.getContext().isConnected() : false;
        }
        catch (Exception e) {
            throw new MBeanException(e, "Failed to get connection availability for peer with name ''.");
        }
    }
}

