/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.eir.slee.services.checkimei;

import javax.slee.ActivityContextInterface;
import org.mobicents.eir.slee.persistence.dao.BlackListDAO;
import org.mobicents.eir.slee.persistence.dao.DAOException;
import org.mobicents.eir.slee.persistence.dao.DAOFactory;
import org.mobicents.eir.slee.persistence.model.BlackList;
import org.mobicents.eir.slee.services.checkimei.CheckImeiCommonSbb;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.EquipmentStatus;

public abstract class CheckImeiSbb
extends CheckImeiCommonSbb {
    public CheckImeiSbb() {
        super(CheckImeiSbb.class.getSimpleName());
    }

    public void onCheckImeiRequest(CheckImeiRequest event, ActivityContextInterface aci) {
        IMEI imei = event.getIMEI();
        EquipmentStatus equipmentStatus = this.getEquipmentStatusByImeiValidation(imei.getIMEI());
        this.sendCheckImeiResponse(event, equipmentStatus);
    }

    private EquipmentStatus getEquipmentStatusByImeiValidation(String imei) {
        EquipmentStatus res = EquipmentStatus.whiteListed;
        BlackListDAO blDAO = DAOFactory.getDAOFactory().getBlackListDAO();
        BlackList bl = null;
        try {
            bl = blDAO.getByImei(imei);
        }
        catch (DAOException e) {
            this.tracer.severe("Error getting answer from persistence system. Answering whiteListed to imei[" + imei + "]", (Throwable)e);
        }
        if (bl != null) {
            res = EquipmentStatus.blackListed;
        }
        return res;
    }

    private void sendCheckImeiResponse(CheckImeiRequest event, EquipmentStatus equipmentStatus) {
        try {
            MAPDialogMobility dialog = event.getMAPDialog();
            dialog.addCheckImeiResponse(event.getInvokeId(), equipmentStatus, null, null);
            dialog.close(false);
        }
        catch (MAPException e) {
            this.tracer.severe("Error while sending CheckImeiResponse.", (Throwable)e);
        }
    }
}

