/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.eir.slee.persistence.dao.cassandra;

import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.mobicents.eir.slee.persistence.dao.BlackListDAO;
import org.mobicents.eir.slee.persistence.dao.DAOException;
import org.mobicents.eir.slee.persistence.dao.cassandra.CassandraDAOFactory;
import org.mobicents.eir.slee.persistence.model.BlackList;

public class CassandraBlackListDAO
extends CassandraDAOFactory
implements BlackListDAO {
    private ColumnFamilyTemplate<String, String> template;

    public CassandraBlackListDAO(Keyspace keyspace) {
        this.template = new ThriftColumnFamilyTemplate(keyspace, "blacklist", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    }

    @Override
    public BlackList getByImei(String imei) throws DAOException {
        BlackList bl = null;
        ColumnFamilyResult res = null;
        try {
            res = this.template.queryColumns((Object)imei);
        }
        catch (HectorException e) {
            throw new DAOException("Error accessing persistence system. Please check if it is up and running", e);
        }
        if (res.hasResults()) {
            String imsi = res.getString((Object)"imsi");
            bl = new BlackList(imei, imsi);
        }
        return bl;
    }
}

