/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.eir.server.bootstrap;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public final class TestVersion {
    public static final TestVersion instance = new TestVersion();
    private Properties props = this.loadProperties();

    private TestVersion() {
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Mobicents EIR Test Server: ");
        boolean first = true;
        for (Object key : this.props.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(key).append('=').append(this.props.get(key));
        }
        return sb.toString();
    }

    private Properties loadProperties() {
        this.props = new Properties();
        try {
            InputStream in = TestVersion.class.getResourceAsStream("version.properties");
            this.props.load(in);
            in.close();
        }
        catch (Exception e) {
            throw new Error("Missing version.properties");
        }
        return this.props;
    }
}

