/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.eir.server.bootstrap;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.util.StringPropertyReplacer;
import org.mobicents.eir.server.bootstrap.MainDeployer;

public class Main {
    private static final String HOME_DIR = "EIR_HOME";
    private static final String BOOT_URL = "/conf/bootstrap-beans.xml";
    private static final String LOG4J_URL = "/conf/log4j.properties";
    private static final String LOG4J_URL_XML = "/conf/log4j.xml";
    public static final String EIR_HOME = "eir.home.dir";
    public static final String EIR_DATA = "eir.data.dir";
    public static final String EIR_BIND_ADDRESS = "eir.bind.address";
    private static final String LINKSET_PERSIST_DIR_KEY = "linkset.persist.dir";
    private static int index = 0;
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;
    private Controller controller;
    private static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) throws Throwable {
        String homeDir = Main.getHomeDir(args);
        System.setProperty(EIR_HOME, homeDir);
        System.setProperty(EIR_DATA, homeDir + File.separator + "data" + File.separator);
        System.setProperty(LINKSET_PERSIST_DIR_KEY, homeDir + File.separator + "ss7");
        if (!Main.initLOG4JProperties(homeDir) && !Main.initLOG4JXml(homeDir)) {
            logger.error((Object)"Failed to initialize loggin, no configuration. Defaults are used.");
        }
        logger.info((Object)"log4j configured");
        URL bootURL = Main.getBootURL(args);
        Main main = new Main();
        main.processCommandLine(args);
        logger.info((Object)("Booting from " + bootURL));
        main.boot(bootURL);
    }

    private void processCommandLine(String[] args) {
        int c;
        String programName = System.getProperty("program.name", "Mobicents EIR");
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("host", 1, null, 98)};
        Getopt g = new Getopt("EIR", args, "-:b:h", longopts);
        g.setOpterr(false);
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 98: {
                    String arg = g.getOptarg();
                    System.setProperty(EIR_BIND_ADDRESS, arg);
                    continue block6;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -b, --host=<host or ip>       Bind address for all Mobicents EIR services");
                    System.out.println();
                    System.exit(0);
                    continue block6;
                }
                case 58: {
                    System.out.println("You need an argument for option " + (char)g.getOptopt());
                    System.exit(0);
                    continue block6;
                }
                case 63: {
                    System.out.println("The option '" + (char)g.getOptopt() + "' is not valid");
                    System.exit(0);
                    continue block6;
                }
            }
            System.out.println("getopt() returned " + c);
        }
        if (System.getProperty(EIR_BIND_ADDRESS) == null) {
            System.setProperty(EIR_BIND_ADDRESS, "127.0.0.1");
        }
    }

    private static boolean initLOG4JProperties(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            InputStream inStreamLog4j = log4jurl.openStream();
            Properties propertiesLog4j = new Properties();
            try {
                propertiesLog4j.load(inStreamLog4j);
                PropertyConfigurator.configure((Properties)propertiesLog4j);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to initialize LOG4J with properties file.");
            return false;
        }
        return true;
    }

    private static boolean initLOG4JXml(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL_XML;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            DOMConfigurator.configure((URL)log4jurl);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to initialize LOG4J with xml file.");
            return false;
        }
        return true;
    }

    private static String getHomeDir(String[] args) {
        if (System.getenv(HOME_DIR) == null) {
            if (args.length > index) {
                return args[index++];
            }
            return ".";
        }
        return System.getenv(HOME_DIR);
    }

    private static URL getBootURL(String[] args) throws Exception {
        String bootURL = "${eir.home.dir}/conf/bootstrap-beans.xml";
        return Main.getURL(bootURL);
    }

    protected void boot(URL bootURL) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.registerShutdownThread();
        this.kernel = bootstrap.getKernel();
        this.kernelDeployer = new BasicXMLDeployer(this.kernel);
        this.kernelDeployer.deploy(bootURL);
        this.kernelDeployer.validate();
        this.controller = this.kernel.getController();
        this.start(this.kernel, this.kernelDeployer);
    }

    public void start(Kernel kernel, BasicXMLDeployer kernelDeployer) throws Throwable {
        ControllerContext context = this.controller.getInstalledContext((Object)"MainDeployer");
        if (context != null) {
            MainDeployer deployer = (MainDeployer)context.getTarget();
            deployer.start(kernel, kernelDeployer);
        }
    }

    public static URL getURL(String url) throws Exception {
        File file = new File(url = StringPropertyReplacer.replaceProperties((String)url, (Properties)System.getProperties()));
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file: " + url);
        }
        return file.toURI().toURL();
    }

    protected void registerShutdownThread() {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownThread()));
    }

    private class ShutdownThread
    implements Runnable {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("Shutting down");
            Main.this.kernelDeployer.shutdown();
            Main.this.kernelDeployer = null;
            Main.this.kernel.getController().shutdown();
            Main.this.kernel = null;
        }
    }
}

