/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.eir.ihub;

import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.mobicents.protocols.ss7.sccp.RemoteSccpStatus;
import org.mobicents.protocols.ss7.sccp.SccpListener;
import org.mobicents.protocols.ss7.sccp.SignallingPointStatus;
import org.mobicents.protocols.ss7.sccp.message.SccpDataMessage;
import org.mobicents.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class MSCSccpListener
implements SccpListener {
    private static final Logger logger = Logger.getLogger(MSCSccpListener.class);
    private static final String GT_MSC = "553496629938";
    private static final String GT_EIR = "553496629939";
    private static final int SSN_MSC = 8;
    private static final int SSN_EIR = 9;
    private MAPProvider mapProvider;
    private SccpAddress thisAddress;
    private SccpAddress remoteAddress;
    private ParameterFactory sccpParameterFactory;

    public MSCSccpListener(MAPProvider mapProvider, ParameterFactory sccpParameterFactory) {
        this.mapProvider = mapProvider;
        this.sccpParameterFactory = sccpParameterFactory;
    }

    public void onPcState(int arg0, SignallingPointStatus arg1, int arg2, RemoteSccpStatus arg3) {
        logger.info((Object)"Connection created. Send checkIMEI request to EIR");
        try {
            for (int i = 0; i < 3; ++i) {
                String testIMEI = "33333333444444" + i;
                String testIMSI = "11111111222222" + i;
                MAPDialogMobility clientDialogMobility = this.setupCheckImeiRequest(testIMEI, testIMSI);
                clientDialogMobility.send();
            }
        }
        catch (MAPException e) {
            logger.error((Object)"Error sending checkImei request", (Throwable)e);
        }
    }

    private MAPDialogMobility setupCheckImeiRequest(String testIMEI, String testIMSI) throws MAPException {
        MAPDialogMobility clientDialogMobility = this.mapProvider.getMAPServiceMobility().createNewDialog(this.getApplicationContext(), this.getMSCSccpAddress(), null, this.getEIRSccpAddress(), null);
        logger.info((Object)("DialogId: " + clientDialogMobility.getLocalDialogId() + ". Sending IMEI=[" + testIMEI + "]. IMSI=[" + testIMSI + "]"));
        MAPParameterFactory mapParameterFactory = this.mapProvider.getMAPParameterFactory();
        IMEI imei = mapParameterFactory.createIMEI(testIMEI);
        IMSI imsi = mapParameterFactory.createIMSI(testIMSI);
        clientDialogMobility.addCheckImeiRequest_Huawei(imei, null, null, imsi);
        return clientDialogMobility;
    }

    private ParameterFactory getParameterFactory() {
        return this.sccpParameterFactory;
    }

    private SccpAddress getMSCSccpAddress() {
        if (this.thisAddress == null) {
            GlobalTitle0100 gt = this.getParameterFactory().createGlobalTitle(GT_MSC, 0, NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            this.thisAddress = this.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, (GlobalTitle)gt, 0, 8);
        }
        return this.thisAddress;
    }

    private SccpAddress getEIRSccpAddress() {
        if (this.remoteAddress == null) {
            GlobalTitle0100 gt = this.getParameterFactory().createGlobalTitle(GT_EIR, 0, NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            this.remoteAddress = this.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, (GlobalTitle)gt, 0, 9);
        }
        return this.remoteAddress;
    }

    private MAPApplicationContext getApplicationContext() {
        return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.equipmentMngtContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version2);
    }

    public void onCoordRequest(int arg0, int arg1, int arg2) {
    }

    public void onCoordResponse(int arg0, int arg1, int arg2) {
    }

    public void onMessage(SccpDataMessage arg0) {
    }

    public void onNotice(SccpNoticeMessage arg0) {
    }

    public void onState(int arg0, int arg1, boolean arg2, int arg3) {
    }
}

