/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup.signals;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceEvent;
import javax.media.mscontrol.resource.Trigger;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.Options;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventImpl;
import org.mobicents.javax.media.mscontrol.spi.DriverImpl;
import org.mobicents.jsr309.mgcp.PackageAU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalDetectorImpl
implements SignalDetector,
JainMgcpListener {
    private CopyOnWriteArrayList<MediaEventListener<SignalDetectorEvent>> listeners = new CopyOnWriteArrayList();
    private MediaGroupImpl parent = null;
    private MediaConfigImpl config;
    private String[] filters;
    private boolean rtcTriggered = false;
    private ArrayList<Trigger> triggers = new ArrayList();
    private FlushHandler flushHandler;
    private StopHandler stopHandler;
    private MgcpSender mgcpSender;

    public SignalDetectorImpl(MediaGroupImpl parent, MediaConfigImpl config) {
        this.parent = parent;
        this.config = config;
        this.flushHandler = new FlushHandler();
        this.stopHandler = new StopHandler();
        this.mgcpSender = new MgcpSender();
    }

    public void flushBuffer() throws MsControlException {
        this.cleanBuffer();
    }

    public void receiveSignals(int numSignals, Parameter[] labels, RTC[] rtc, Parameters options) throws MsControlException {
        if (rtc != null) {
            this.verifyRTC(rtc);
        }
        this.parent.info("Receive signal called");
        this.rtcTriggered = false;
        this.triggers.clear();
        String[] patterns = this.getPatterns(labels, options);
        if (patterns == null) {
            patterns = this.getPatterns(rtc, options);
        }
        this.filters = this.getFilters(options);
        Options params = new Options();
        params.setDigitsNumber(numSignals);
        params.setDigitPattern(patterns);
        if (options != null && options.containsKey((Object)PROMPT)) {
            if (options.get((Object)PROMPT) instanceof URI) {
                params.setPrompt(((URI)options.get((Object)PROMPT)).toString());
            } else if (options.get((Object)PROMPT) instanceof URI[]) {
                URI[] list = (URI[])options.get((Object)PROMPT);
                String result = new String();
                for (int i = 0; i < list.length; ++i) {
                    result = result + list[i].toString() + ";";
                }
                if (result.length() > 0) {
                    result = result.substring(0, result.length() - 1);
                    params.setPrompt(result);
                }
            }
        }
        if (options != null && options.containsKey((Object)INITIAL_TIMEOUT)) {
            params.setFirstDigitTimer((Integer)options.get((Object)INITIAL_TIMEOUT));
        }
        if (options != null && options.containsKey((Object)INTER_SIG_TIMEOUT)) {
            params.setInterDigitTimer((Integer)options.get((Object)INTER_SIG_TIMEOUT));
        }
        if (options != null && options.containsKey((Object)MAX_DURATION)) {
            params.setMaxDuration((Integer)options.get((Object)MAX_DURATION));
        }
        if (options != null && options.containsKey((Object)Player.REPEAT_COUNT)) {
            params.setNumberOfAttempts((Integer)options.get((Object)Player.REPEAT_COUNT));
        }
        params.setNonInterruptiblePlay(true);
        Boolean hasClearDigits = false;
        if (rtc != null) {
            for (int i = 0; i < rtc.length; ++i) {
                if (rtc[i] == MediaGroup.SIGDET_STOPPLAY) {
                    params.setNonInterruptiblePlay(false);
                }
                if (rtc[i].getTrigger() != Player.PLAY_START || rtc[i].getAction() != SignalDetector.FLUSH_BUFFER) continue;
                hasClearDigits = true;
                params.setClearDigits(true);
            }
        }
        this.requestPlayCollect(params.toString(), hasClearDigits);
    }

    private void verifyRTC(RTC[] rtc) throws UnsupportedException {
        for (RTC r : rtc) {
            if (r.getTrigger() != Player.PLAY_START || r.getAction() != Player.STOP) continue;
            throw new UnsupportedException("Invalid RTC");
        }
    }

    private String[] getPatterns(Parameter[] labels, Parameters options) {
        if (labels == null || options == null) {
            return null;
        }
        String[] patterns = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            patterns[i] = (String)options.get((Object)labels[i]);
        }
        return patterns;
    }

    private String[] getPatterns(RTC[] rtc, Parameters options) {
        if (rtc == null || options == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (RTC r : rtc) {
            for (int i = 0; i < SignalDetector.PATTERN_MATCH.length; ++i) {
                if (r.getTrigger() != SignalDetector.PATTERN_MATCH[i] || !options.containsKey((Object)SignalDetector.PATTERN[i])) continue;
                list.add((String)options.get((Object)SignalDetector.PATTERN[i]));
                this.triggers.add(SignalDetector.PATTERN_MATCH[i]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        String[] patterns = new String[list.size()];
        list.toArray(patterns);
        this.rtcTriggered = true;
        return patterns;
    }

    private String[] getFilters(Parameters options) {
        if (options == null) {
            return null;
        }
        if (options.get((Object)SignalDetector.FILTERED_PATTERNS) == null) {
            return null;
        }
        Parameter[] ptt = (Parameter[])options.get((Object)SignalDetector.FILTERED_PATTERNS);
        String[] filters = new String[ptt.length];
        for (int i = 0; i < ptt.length; ++i) {
            filters[i] = (String)options.get((Object)ptt[i]);
        }
        return filters;
    }

    public MediaGroup getContainer() {
        return this.parent;
    }

    public void stop() {
        this.stopCollection();
    }

    public void addListener(MediaEventListener<SignalDetectorEvent> listener) {
        this.listeners.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.parent.getMediaSession();
    }

    public void removeListener(MediaEventListener<SignalDetectorEvent> listener) {
        this.listeners.remove(listener);
    }

    public void update(SignalDetectorEvent anEvent) {
        for (MediaEventListener<SignalDetectorEvent> m : this.listeners) {
            m.onEvent((MediaEvent)anEvent);
        }
    }

    private void requestPlayCollect(String params, Boolean hasClearDigits) {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
        ArrayList<EventName> signalList = new ArrayList<EventName>();
        ArrayList<RequestedEvent> eventList = new ArrayList<RequestedEvent>();
        signalList.add(new EventName(PackageAU.Name, PackageAU.pc.withParm(params)));
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.oc), actions));
        eventList.add(new RequestedEvent(new EventName(PackageAU.Name, MgcpEvent.of), actions));
        EventName[] signals = new EventName[signalList.size()];
        signalList.toArray(signals);
        RequestedEvent[] events = new RequestedEvent[eventList.size()];
        eventList.toArray(events);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setRequestedEvents(events);
        req.setSignalRequests(signals);
        req.setTransactionHandle(txID);
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this);
        driver.attach(reqID, (JainMgcpListener)this);
        if (this.parent.isStopping()) {
            this.mgcpSender.init(driver, req);
        } else {
            driver.send((JainMgcpEvent)req);
        }
    }

    private void cleanBuffer() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        req.setSignalRequests(new EventName[]{new EventName(PackageAU.Name, PackageAU.es.withParm("cb=true"))});
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this.flushHandler);
        driver.send((JainMgcpEvent)req);
    }

    private void stopCollection() {
        RequestIdentifier reqID = this.parent.nextRequestID();
        int txID = this.parent.getMediaSession().getDriver().getNextTxID();
        NotificationRequest req = new NotificationRequest((Object)this, this.parent.getEndpoint().getIdentifier(), reqID);
        req.setSignalRequests(new EventName[]{new EventName(PackageAU.Name, PackageAU.es)});
        req.setTransactionHandle(txID);
        DriverImpl driver = this.parent.getMediaSession().getDriver();
        req.setNotifiedEntity(driver.getCallAgent());
        driver.attach(txID, (JainMgcpListener)this.stopHandler);
        this.parent.waitForStop();
        driver.send((JainMgcpEvent)req);
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        switch (event.getObjectIdentifier()) {
            case 108: {
                this.processNotify((Notify)event);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
        NotificationRequestResponse evt = (NotificationRequestResponse)event;
        switch (event.getReturnCode().getValue()) {
            default: 
        }
    }

    private void processNotify(Notify notify) {
        EventName[] events;
        block3: for (EventName evt : events = notify.getObservedEvents()) {
            switch (evt.getEventIdentifier().intValue()) {
                case 62: {
                    this.fireEvent(evt.getEventIdentifier().getParms());
                    continue block3;
                }
            }
        }
    }

    private void fireEvent(String params) {
        Options options = new Options(params);
        options.processFilters(this.filters);
        SignalDetectorEventImpl report = new SignalDetectorEventImpl((SignalDetector)this, SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED, true, options.getDigitsCollected());
        if (options.getPatternIndex() >= 0) {
            report.setPatterIndex(options.getPatternIndex());
            if (this.rtcTriggered) {
                report.setQualifier(ResourceEvent.RTC_TRIGGERED);
                report.setRtcTrigger(this.triggers.get(options.getPatternIndex()));
            }
        } else if (options.getReturnCode() == 326) {
            if (options.getDigitsCollected() != null && options.getDigitsCollected().length() > 0) {
                report.setQualifier(SignalDetectorEvent.INTER_SIG_TIMEOUT_EXCEEDED);
            } else {
                report.setQualifier(SignalDetectorEvent.INITIAL_TIMEOUT_EXCEEDED);
            }
        } else if (options.getReturnCode() == 330) {
            report.setQualifier(SignalDetectorEvent.DURATION_EXCEEDED);
        } else {
            report.setQualifier(SignalDetectorEvent.NUM_SIGNALS_DETECTED);
        }
        this.fireEvent(report);
    }

    protected void fireEvent(SignalDetectorEvent event) {
        this.delay(2L);
        for (MediaEventListener<SignalDetectorEvent> l : this.listeners) {
            l.onEvent((MediaEvent)event);
        }
    }

    public void patternMatches(int index, String s) {
        SignalDetectorEventImpl evt = new SignalDetectorEventImpl((SignalDetector)this, SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED, true, s);
        evt.setPatterIndex(index);
        this.fireEvent(evt);
    }

    public void countMatches(String s) {
        SignalDetectorEventImpl evt = new SignalDetectorEventImpl((SignalDetector)this, SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED, true, s);
        evt.setQualifier(SignalDetectorEvent.NUM_SIGNALS_DETECTED);
        this.fireEvent(evt);
    }

    private void delay(long amount) {
        try {
            Thread.sleep(amount);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return String.format("Detector(%s)", this.getContainer());
    }

    public void stopCompleted() {
        if (this.mgcpSender.waiting.booleanValue()) {
            this.mgcpSender.run();
        }
    }

    private class MgcpSender {
        private DriverImpl driver;
        private NotificationRequest req;
        private Boolean waiting = false;

        public void init(DriverImpl driver, NotificationRequest req) {
            this.driver = driver;
            this.req = req;
            this.waiting = true;
        }

        public void run() {
            this.driver.send((JainMgcpEvent)this.req);
            this.waiting = false;
        }
    }

    private class StopHandler
    implements JainMgcpListener {
        private StopHandler() {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
            switch (event.getReturnCode().getValue()) {
                case 200: {
                    SignalDetectorImpl.this.parent.releaseStop();
                    SignalDetectorEventImpl oc = new SignalDetectorEventImpl(null, SignalDetectorEvent.RECEIVE_SIGNALS_COMPLETED, true);
                    oc.setQualifier(ResourceEvent.STOPPED);
                    SignalDetectorImpl.this.fireEvent(oc);
                    System.out.println("DONE STOP=======================>");
                    break;
                }
            }
        }
    }

    private class FlushHandler
    implements JainMgcpListener {
        private FlushHandler() {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent event) {
            switch (event.getReturnCode().getValue()) {
                case 200: {
                    SignalDetectorEventImpl oc = new SignalDetectorEventImpl(null, SignalDetectorEvent.FLUSH_BUFFER_COMPLETED, true);
                    SignalDetectorImpl.this.fireEvent(oc);
                    System.out.println("DONE FLUSH BUFFER=======================>");
                    break;
                }
            }
        }
    }
}

