/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mixer;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEvent;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.media.mscontrol.resource.ResourceContainer;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaObjectImpl;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.container.ContainerImpl;
import org.mobicents.javax.media.mscontrol.container.Endpoint;
import org.mobicents.javax.media.mscontrol.mixer.AllocationEventImpl;
import org.mobicents.javax.media.mscontrol.mixer.MixerAdapterImpl;
import org.mobicents.javax.media.mscontrol.mixer.MixerAudioConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaMixerImpl
extends ContainerImpl
implements MediaMixer {
    public static final MediaConfig AUDIO_CONFIG = new MixerAudioConfig().getConfig();
    protected List<MixerAdapter> adaptors = new ArrayList<MixerAdapter>();
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> listeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<AllocationEventListener> allocationListeners = new CopyOnWriteArrayList();
    private int idx = 1;

    public MediaMixerImpl(MediaSessionImpl mediaSession, MediaConfigImpl config) throws MsControlException {
        super(mediaSession, config.getParameters());
        this.config = config;
        String localName = (String)config.getValue(ENDPOINT_NAME);
        String domainName = this.session.getDriver().getRemoteDomainName();
        this.endpoint = new Endpoint(new EndpointIdentifier(localName, domainName));
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> config) throws MsControlException {
        if (config == null) {
            throw new MsControlException("Configuration is NULL");
        }
        Boolean hasDtmfClamp = false;
        if (config == MixerAdapter.DTMF_CLAMP) {
            hasDtmfClamp = true;
        }
        ParametersImpl params = new ParametersImpl();
        params.put(MEDIAOBJECT_ID, (Object)(this.config.getParameters().get((Object)MEDIAOBJECT_ID) + "/adaptor" + this.idx++));
        params.put(MediaObjectImpl.ENDPOINT_NAME, this.config.getParameters().get((Object)MediaObjectImpl.ENDPOINT_NAME));
        MixerAdapterImpl adaptor = new MixerAdapterImpl(this, params, hasDtmfClamp);
        this.adaptors.add(adaptor);
        return adaptor;
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> pattern, Parameters param) throws MsControlException {
        if (this.config == null) {
            throw new MsControlException("Configuration can't be null");
        }
        MediaConfigImpl cfg = (MediaConfigImpl)this.getConfiguration(pattern).createCustomizedClone(param);
        MixerAdapterImpl adaptor = new MixerAdapterImpl(this, param);
        this.adaptors.add(adaptor);
        return adaptor;
    }

    public MixerAdapter createMixerAdapter(MediaConfig config, Parameters params) throws MsControlException {
        if (config == null) {
            throw new MsControlException("MediaConfig cannot be null");
        }
        MediaConfig cfg = ((MediaConfigImpl)config).createCustomizedClone(params);
        Boolean hasDtmfClamp = false;
        if (config == MixerAdapter.DTMF_CLAMP) {
            hasDtmfClamp = true;
        }
        MixerAdapterImpl adaptor = new MixerAdapterImpl(this, params, hasDtmfClamp);
        this.adaptors.add(adaptor);
        return adaptor;
    }

    public boolean hasDtmfClamp() {
        for (int i = 0; i < this.adaptors.size(); ++i) {
            if (!((MixerAdapterImpl)this.adaptors.get(i)).dtmfClamp()) continue;
            return true;
        }
        return false;
    }

    public void confirm() throws MsControlException {
        AllocationEventImpl evt = new AllocationEventImpl((ResourceContainer)this, AllocationEvent.ALLOCATION_CONFIRMED, true, MediaErr.NO_ERROR, null);
        for (AllocationEventListener l : this.allocationListeners) {
            l.onEvent((AllocationEvent)evt);
        }
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> resource) throws MsControlException {
        return null;
    }

    public void triggerRTC(Action rtca) {
    }

    public void release() {
        try {
            this.unjoin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(MediaEventListener<MixerEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MediaEventListener<MixerEvent> listener) {
        this.listeners.remove(listener);
    }

    public Iterator<MediaObject> getMediaObjects() {
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        return null;
    }

    public void addListener(AllocationEventListener listener) {
        this.allocationListeners.add(listener);
    }

    public void removeListener(AllocationEventListener listener) {
        this.allocationListeners.remove(listener);
    }

    public void triggerAction(Action arg0) {
    }

    public MediaConfig getConfiguration(Configuration pattern) {
        if (pattern.equals(MixerAdapter.DTMF_CLAMP)) {
            return MixerAdapterImpl.ADAPTOR_CFG;
        }
        return null;
    }
}

