/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.networkconnection.CodecPolicy;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpException;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.mobicents.fsm.UnknownTransitionException;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpPortManagerEventImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpProcessor;

public class SdpPortManagerImpl
implements SdpPortManager {
    private SdpFactory sdpFactory;
    protected NetworkConnectionImpl connection;
    private SessionDescription localSdp;
    protected SessionDescription remoteSdp;
    private CopyOnWriteArrayList<MediaEventListener> listeners = new CopyOnWriteArrayList();
    private CodecPolicy codecPolicy = new CodecPolicy();
    private SdpProcessor sdpProcessor;
    private static final String[] bogus = new String[]{"fmtp", "AS", "sendrecv", "audio", "IP4"};

    public SdpPortManagerImpl(NetworkConnectionImpl connection) {
        this.connection = connection;
        this.sdpProcessor = new SdpProcessor();
        this.sdpFactory = SdpFactory.getInstance();
    }

    public synchronized void generateSdpOffer() throws SdpPortManagerException {
        if (this.connection.getEndpoint().concreteNameExpectedSoon()) {
            try {
                this.connection.getEndpoint().await();
            }
            catch (InterruptedException e) {
                throw new SdpPortManagerException(e.getMessage());
            }
        }
        this.connection.debug("Generating SDP offer");
        try {
            this.connection.fsm.signal("crcx");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public void processSdpOffer(byte[] sdp) throws SdpPortManagerException {
        if (this.connection.getEndpoint().concreteNameExpectedSoon()) {
            try {
                this.connection.getEndpoint().await();
            }
            catch (InterruptedException e) {
                throw new SdpPortManagerException(e.getMessage());
            }
        }
        if (!this.connection.getEndpoint().hasConcreteName()) {
            this.connection.getEndpoint().expectingConcreteName();
        }
        this.connection.debug("Processing SDP offer");
        try {
            this.remoteSdp = this.sdpFactory.createSessionDescription(new String(sdp));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SdpPortManagerException(e.getMessage());
        }
        for (String f : this.codecPolicy.getExcludedCodecs()) {
            try {
                this.sdpProcessor.exclude(f, this.remoteSdp);
            }
            catch (Exception e) {
                throw new SdpPortManagerException(e.getMessage());
            }
        }
        boolean minOffer = false;
        try {
            minOffer = this.sdpProcessor.checkForMinimalOffer(this.remoteSdp);
        }
        catch (Exception e) {
            throw new SdpException("Minimal offer");
        }
        if (!minOffer) {
            throw new SdpException("Minimal offer");
        }
        try {
            this.connection.fsm.signal("crcx");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException("state= " + this.connection.fsm.getState().getName() + " transition: " + e.getMessage());
        }
    }

    public void processSdpAnswer(byte[] sdp) throws SdpPortManagerException {
        this.connection.debug("Processing SDP answer");
        try {
            this.remoteSdp = this.sdpFactory.createSessionDescription(new String(sdp));
        }
        catch (Exception e) {
            throw new SdpPortManagerException(e.getMessage());
        }
        try {
            this.connection.fsm.signal("modify");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public void rejectSdpOffer() throws SdpPortManagerException {
        try {
            this.connection.fsm.signal("close");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public byte[] getMediaServerSessionDescription() throws SdpPortManagerException {
        return this.localSdp != null ? this.localSdp.toString().getBytes() : null;
    }

    public byte[] getUserAgentSessionDescription() throws SdpPortManagerException {
        return this.remoteSdp != null ? this.remoteSdp.toString().getBytes() : null;
    }

    public void setCodecPolicy(CodecPolicy codecPolicy) throws SdpPortManagerException {
        String[] excluded;
        String[] required;
        for (String codec : required = codecPolicy.getRequiredCodecs()) {
            if (!this.lookup(codec, codecPolicy.getExcludedCodecs())) continue;
            throw new SdpPortManagerException("Codec " + codec + " is excluded");
        }
        for (String codec : excluded = codecPolicy.getExcludedCodecs()) {
            if (this.lookup(codec, codecPolicy.getCodecCapabilities())) {
                throw new SdpPortManagerException("Codec " + codec + " is excluded but in capabilities");
            }
            if (!this.lookup(codec, codecPolicy.getCodecPreferences())) continue;
            throw new SdpPortManagerException("Codec " + codec + " is excluded but in preferences");
        }
        this.codecPolicy = codecPolicy;
    }

    private void print(String label, String[] list) {
        System.out.println(label);
        for (String s : list) {
            System.out.println(s);
        }
    }

    public CodecPolicy getCodecPolicy() {
        return this.codecPolicy;
    }

    public NetworkConnection getContainer() {
        return this.connection;
    }

    public void addListener(MediaEventListener<SdpPortManagerEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MediaEventListener<SdpPortManagerEvent> listener) {
        this.listeners.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.connection.getMediaSession();
    }

    private boolean isSDPGenerated(SdpPortManagerEvent evt) {
        return evt.getEventType() == SdpPortManagerEvent.ANSWER_GENERATED || evt.getEventType() == SdpPortManagerEvent.OFFER_GENERATED;
    }

    private boolean applyCodecPolicy(SessionDescription sdp) throws javax.sdp.SdpException {
        for (String f : this.codecPolicy.getRequiredCodecs()) {
            if (this.sdpProcessor.containsFormat(f, sdp)) continue;
            if (f.equalsIgnoreCase("AMR")) {
                Vector attributes = ((MediaDescription)sdp.getMediaDescriptions(false).get(0)).getAttributes(false);
                attributes.add(this.sdpFactory.createAttribute("rtpmap", "99 AMR/8000"));
                this.connection.error = null;
                this.connection.errorMsg = "";
                return true;
            }
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        for (String f : this.codecPolicy.getCodecCapabilities()) {
            if (this.isBogus(f) || this.sdpProcessor.containsFormat(f, this.localSdp)) continue;
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        for (String m : this.codecPolicy.getMediaTypeCapabilities()) {
            if (this.sdpProcessor.containsMedia(m, this.localSdp)) continue;
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        return true;
    }

    protected void fireEvent(SdpPortManagerEvent evt) {
        boolean res = false;
        try {
            res = !this.applyCodecPolicy(this.localSdp);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.isSDPGenerated(evt) && this.codecPolicy != null && res) {
            this.fireEvent(new SdpPortManagerEventImpl(this, SdpPortManagerEvent.NETWORK_STREAM_FAILURE));
            try {
                this.connection.fsm.signal("close");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        new Thread(new EventProcessor(evt)).start();
    }

    private boolean lookup(String s, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return true;
        }
        return false;
    }

    protected void setLocalDescriptor(String sdp) throws javax.sdp.SdpException {
        this.localSdp = this.sdpFactory.createSessionDescription(sdp);
    }

    protected String getLocalDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    private boolean isBogus(String f) {
        for (int i = 0; i < bogus.length; ++i) {
            if (!f.equalsIgnoreCase(bogus[i])) continue;
            return true;
        }
        return false;
    }

    private String convertSDP(String sdpString) throws javax.sdp.SdpException {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sd = factory.createSessionDescription(sdpString);
        Vector mediaDescriptions = sd.getMediaDescriptions(false);
        for (Object object : mediaDescriptions) {
            MediaDescription md = (MediaDescription)object;
            Vector attributes = md.getAttributes(false);
            for (Object object2 : attributes) {
                Attribute attribute = (Attribute)object2;
                if (attribute.getName().compareToIgnoreCase("rtpmap") != 0) continue;
                attribute.setValue(attribute.getValue().toUpperCase());
            }
        }
        return sd.toString();
    }

    private class EventProcessor
    implements Runnable {
        private SdpPortManagerEvent evt;

        public EventProcessor(SdpPortManagerEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            for (MediaEventListener listener : SdpPortManagerImpl.this.listeners) {
                SdpPortManagerImpl.this.connection.debug(String.format("Event=%s", this.evt.toString()));
                listener.onEvent((MediaEvent)this.evt);
            }
        }
    }

    private class Signal
    implements Runnable {
        private String t;

        public Signal(String t) {
            this.t = t;
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                SdpPortManagerImpl.this.connection.fsm.signal(this.t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

