/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.sdp;

import org.mobicents.mscontrol.sdp.AudioFormatParser;
import org.mobicents.mscontrol.sdp.Connection;
import org.mobicents.mscontrol.sdp.Format;
import org.mobicents.mscontrol.sdp.FormatParser;
import org.mobicents.mscontrol.sdp.MediaType;
import org.mobicents.mscontrol.sdp.VideoFormatParser;

public class MediaDescriptor {
    protected MediaType mediaType;
    private int port;
    private String profile;
    private FormatParser fmtParser;
    private int[] fmt = new int[15];
    private Format[] formats = new Format[15];
    private int count;
    private String[] attributes = new String[15];
    private int aCount;
    private String mode;
    private Connection connection;
    private int length = 0;
    private char[] chars = null;

    public MediaDescriptor(String m) {
        this.length = m.length();
        this.chars = m.toCharArray();
        int pos1 = m.indexOf(61);
        int pos2 = this.getNextSpace(pos1 + 1);
        this.mediaType = MediaType.getInstance(m.substring(pos1 + 1, pos2));
        if (this.mediaType == MediaType.AUDIO) {
            this.fmtParser = new AudioFormatParser();
        } else if (this.mediaType == MediaType.VIDEO) {
            this.fmtParser = new VideoFormatParser();
        } else {
            throw new IllegalArgumentException("Unknown media type " + (Object)((Object)this.mediaType));
        }
        pos1 = this.getNextSpace(pos2 + 1);
        this.port = Integer.parseInt(m.substring(pos2 + 1, pos1));
        pos2 = this.getNextSpace(pos1 + 1);
        this.profile = m.substring(pos1 + 1, pos2).trim();
        pos1 = pos2;
        pos2 = this.getNextSpace(pos1 + 1);
        Format format = null;
        while (pos2 > 0) {
            int f = Integer.parseInt(m.substring(pos1 + 1, pos2).trim());
            format = this.fmtParser.getFormat(f);
            if (format != null) {
                this.fmt[this.count] = f;
                this.formats[this.count++] = format;
            }
            pos1 = pos2;
            pos2 = this.getNextSpace(pos1 + 1);
        }
    }

    private int getNextSpace(int from) {
        int next = 0;
        if (from >= this.length) {
            return 0;
        }
        for (int i = from; i < this.length - 1; ++i) {
            if (this.chars[i] != ' ' || this.chars[i + 1] == ' ') continue;
            next = i;
            break;
        }
        if (next == 0) {
            return this.length;
        }
        return next;
    }

    public MediaDescriptor(MediaType mediaType, int port) {
        this.mediaType = mediaType;
        this.port = port;
        this.fmtParser = new AudioFormatParser();
        if (mediaType == MediaType.AUDIO) {
            this.fmtParser = new AudioFormatParser();
        } else if (mediaType == MediaType.VIDEO) {
            this.fmtParser = new VideoFormatParser();
        } else {
            throw new IllegalArgumentException("Unknown media type " + (Object)((Object)mediaType));
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public int getPort() {
        return this.port;
    }

    public String getProfle() {
        return this.profile;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int getFormatCount() {
        return this.count;
    }

    public int getPyaloadType(int i) {
        return this.fmt[i];
    }

    public Format getFormat(int i) {
        return this.formats[i];
    }

    public void addFormat(int payload, Format format) {
        this.fmt[this.count] = payload;
        this.formats[this.count++] = format;
    }

    public void addAttribute(String attribute) {
        this.attributes[this.aCount++] = attribute;
    }

    public void exclude(Format format) {
        int k = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.formats[i] == null || !this.formats[i].equals(format)) continue;
            k = i;
            break;
        }
        System.arraycopy(this.formats, k + 1, this.formats, k, this.formats.length - k - 1);
        System.arraycopy(this.fmt, k + 1, this.fmt, k, this.fmt.length - k - 1);
        --this.count;
    }

    public void exclude(String formatName) {
        int k = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.formats[i] == null || !this.formats[i].matches(formatName)) continue;
            k = i;
            break;
        }
        if (k == -1) {
            return;
        }
        System.arraycopy(this.formats, k + 1, this.formats, k, this.formats.length - k - 1);
        System.arraycopy(this.fmt, k + 1, this.fmt, k, this.fmt.length - k - 1);
        --this.count;
    }

    protected boolean contains(String encoding) {
        for (int i = 0; i < this.count; ++i) {
            if (this.formats[i] == null || !this.formats[i].matches(encoding)) continue;
            return true;
        }
        return false;
    }

    protected void parseAtribute(String a) {
        if (a.startsWith("a=rtpmap:")) {
            if (this.fmtParser.parse(a, this.fmt, this.formats, this.count)) {
                ++this.count;
            }
        } else if (a.equals("a=sendrecv")) {
            this.mode = "sendrecv";
        } else if (a.equals("a=sendonly")) {
            this.mode = "sendonly";
        } else if (a.equals("a=recvonly")) {
            this.mode = "recvonly";
        } else if (a.startsWith("c=")) {
            this.connection = new Connection(a);
        }
    }

    public void write(StringBuffer buffer) {
        int j;
        buffer.append("m=" + this.mediaType.getName() + " " + this.port + " RTP/AVP");
        for (j = 0; j < this.count; ++j) {
            buffer.append(" " + this.fmt[j]);
        }
        buffer.append("\n");
        if (this.connection != null) {
            buffer.append(this.connection.toString() + "\n");
        }
        for (j = 0; j < this.aCount; ++j) {
            buffer.append("a=" + this.attributes[j] + "\n");
        }
        for (j = 0; j < this.count; ++j) {
            this.fmtParser.write(buffer, this.fmt[j], this.formats[j]);
            buffer.append("\n");
        }
        if (this.mediaType == MediaType.AUDIO) {
            buffer.append("a=control:audio\n");
        } else if (this.mediaType == MediaType.VIDEO) {
            buffer.append("a=control:video\n");
        }
        buffer.append("a=silenceSupp:off\n");
    }

    public Connection getConnection() {
        return this.connection;
    }
}

