/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sdp;

import java.util.ArrayList;
import java.util.Collection;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import org.mobicents.sdp.RTPFormat;
import org.mobicents.sdp.VideoFormat;

public class RTPVideoFormat
extends VideoFormat
implements RTPFormat {
    private static final SdpFactory sdpFactory = SdpFactory.getInstance();
    private int payloadType;

    public RTPVideoFormat(int payloadType, String encdingName) {
        super(encdingName);
        this.payloadType = payloadType;
    }

    public RTPVideoFormat(int payloadType, String encdingName, float fr) {
        super(encdingName, -1, fr);
        this.payloadType = payloadType;
    }

    public RTPVideoFormat(int payloadType, String encoding, int maxDataLength, float frameRate) {
        super(encoding, maxDataLength, frameRate);
        this.payloadType = payloadType;
    }

    @Override
    public int getPayloadType() {
        return this.payloadType;
    }

    private String rtpmap() {
        String s = this.payloadType + " " + this.getEncoding();
        if (this.getFrameRate() > 0.0f) {
            int fr = (int)this.getFrameRate();
            s = s + "/" + fr;
        }
        return s;
    }

    public static RTPVideoFormat parseFormat(String rtpmap) {
        RTPVideoFormat fmt = null;
        String[] tokens = rtpmap.toLowerCase().split(" ");
        int p = Integer.parseInt(tokens[0]);
        tokens = tokens[1].split("/");
        String encodingName = tokens[0];
        if (tokens.length > 1) {
            float fr = Float.parseFloat(tokens[1]);
            fmt = new RTPVideoFormat(p, encodingName, fr);
        } else {
            fmt = new RTPVideoFormat(p, encodingName);
        }
        return fmt;
    }

    @Override
    public Collection<Attribute> encode() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        if (this.getEncoding().equals("h261")) {
            list.add(sdpFactory.createAttribute("rtpmap", this.rtpmap()));
        }
        return list;
    }
}

