/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.container;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.LocalOptionExtension;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.join.Joinable;
import org.mobicents.fsm.FSM;
import org.mobicents.fsm.State;
import org.mobicents.fsm.StateEventHandler;
import org.mobicents.fsm.TransitionHandler;
import org.mobicents.fsm.UnknownTransitionException;
import org.mobicents.javax.media.mscontrol.container.ContainerImpl;
import org.mobicents.javax.media.mscontrol.container.LinkListener;
import org.mobicents.javax.media.mscontrol.mixer.MediaMixerImpl;

public class Link
extends FSM {
    private ContainerImpl[] containers = new ContainerImpl[2];
    protected ConnectionIdentifier[] connections = new ConnectionIdentifier[2];
    protected Joinable.Direction direction;
    protected Serializable context;
    private LinkListener listener;

    public Link(ScheduledExecutorService scheduler, ContainerImpl a, ContainerImpl b) {
        super(scheduler);
        this.containers[0] = a;
        this.containers[1] = b;
        this.createState("NULL").setOnEnter(new OnDeactivate(this));
        this.createState("CONNECTING");
        this.createState("CONNECTED");
        this.createState("ACTIVE").setOnEnter(new OnActivate(this));
        this.createState("DISCONNECTING").setOnEnter(new UnjoinRequest());
        this.createState("DISCONNECTED_1");
        this.createState("CANCELED");
        this.createState("STARTING");
        this.createState("STARTED_1");
        this.createTransition("join", "NULL", "CONNECTING").setHandler(new JoinRequest());
        this.createTransition("success", "NULL", "CONNECTED");
        this.createTransition("success", "CONNECTING", "CONNECTED").setHandler(new InitiateTransmission());
        this.createTransition("failure", "CONNECTING", "NULL");
        this.createTransition("release", "CONNECTING", "CANCELED");
        this.createTimeoutTransition("CONNECTING", "NULL", 5000L);
        this.createTransition("join", "CONNECTED", "STARTING").setHandler(new StartRequest());
        this.createTransition("release", "CONNECTED", "DISCONNECTING");
        this.createTransition("success", "CONNECTED", "CONNECTED");
        this.createTransition("success", "DISCONNECTING", "DISCONNECTED_1");
        this.createTransition("failure", "DISCONNECTING", "DISCONNECTING");
        this.createTransition("success", "DISCONNECTED_1", "NULL");
        this.createTransition("success", "CANCELED", "DISCONNECTING");
        this.createTransition("failure", "CANCELED", "NULL");
        this.createTimeoutTransition("CANCELED", "NULL", 5000L);
        this.createTransition("success", "STARTING", "STARTED_1");
        this.createTransition("failure", "STARTING", "DISCONNECTING");
        this.createTimeoutTransition("STARTING", "DISCONNECTING", 5000L);
        this.createTransition("success", "STARTED_1", "ACTIVE");
        this.createTransition("failure", "STARTED_1", "DISCONNECTING");
        this.createTimeoutTransition("STARTED_1", "DISCONNECTING", 5000L);
        this.createTransition("join", "ACTIVE", "STARTING").setHandler(new StartRequest());
        this.createTransition("release", "ACTIVE", "DISCONNECTING");
        this.setStart("NULL");
        this.setEnd("NULL");
    }

    public ContainerImpl getContainer(int i) {
        return this.containers[i];
    }

    public void setListener(LinkListener listener) {
        this.listener = listener;
    }

    public Joinable.Direction getDirection() {
        return this.direction;
    }

    private ConnectionMode getMode0(ContainerImpl container) {
        if (container instanceof MediaMixerImpl) {
            return ConnectionMode.Confrnce;
        }
        switch (this.direction) {
            case DUPLEX: {
                return ConnectionMode.SendRecv;
            }
            case RECV: {
                return ConnectionMode.RecvOnly;
            }
        }
        return ConnectionMode.SendOnly;
    }

    private ConnectionMode getMode1(ContainerImpl container) {
        if (container instanceof MediaMixerImpl) {
            return ConnectionMode.Confrnce;
        }
        switch (this.direction) {
            case DUPLEX: {
                return ConnectionMode.SendRecv;
            }
            case RECV: {
                return ConnectionMode.SendOnly;
            }
        }
        return ConnectionMode.RecvOnly;
    }

    private Joinable.Direction inversion(Joinable.Direction direction) {
        switch (direction) {
            case SEND: {
                return Joinable.Direction.RECV;
            }
            case RECV: {
                return Joinable.Direction.SEND;
            }
        }
        return Joinable.Direction.DUPLEX;
    }

    public class OnDeactivate
    implements StateEventHandler {
        private Link link;

        public OnDeactivate(Link link2) {
            this.link = link2;
        }

        @Override
        public void onEvent(State state) {
            if (Link.this.listener != null) {
                Link.this.listener.unjoined(this.link);
            }
        }
    }

    public class OnActivate
    implements StateEventHandler {
        private Link link;

        public OnActivate(Link link2) {
            this.link = link2;
        }

        @Override
        public void onEvent(State state) {
            if (Link.this.listener != null) {
                Link.this.listener.joined(this.link);
            }
        }
    }

    private class UnjoinResponse
    implements JainMgcpListener {
        private UnjoinResponse() {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent evt) {
            try {
                Link.this.signal("success");
            }
            catch (UnknownTransitionException unknownTransitionException) {
                // empty catch block
            }
        }
    }

    private class UnjoinRequest
    implements StateEventHandler {
        private UnjoinRequest() {
        }

        @Override
        public void onEvent(State state) {
            DeleteConnection req;
            int txID;
            if (Link.this.connections[0] != null) {
                txID = Link.this.containers[0].getMediaSession().getDriver().getNextTxID();
                req = new DeleteConnection((Object)this, ((Link)Link.this).containers[0].session.getCallID(), ((Link)Link.this).containers[0].endpoint.getIdentifier(), Link.this.connections[0]);
                req.setTransactionHandle(txID);
                ((Link)Link.this).containers[0].session.getDriver().attach(txID, (JainMgcpListener)new UnjoinResponse());
                ((Link)Link.this).containers[0].session.getDriver().send((JainMgcpEvent)req);
            } else {
                Link.this.signalAsync("success");
            }
            if (Link.this.connections[1] != null) {
                txID = Link.this.containers[1].getMediaSession().getDriver().getNextTxID();
                req = new DeleteConnection((Object)this, ((Link)Link.this).containers[1].session.getCallID(), ((Link)Link.this).containers[1].endpoint.getIdentifier(), Link.this.connections[1]);
                req.setTransactionHandle(txID);
                ((Link)Link.this).containers[1].session.getDriver().attach(txID, (JainMgcpListener)new UnjoinResponse());
                ((Link)Link.this).containers[1].session.getDriver().send((JainMgcpEvent)req);
            } else {
                Link.this.signalAsync("success");
            }
        }
    }

    public class StartResponse
    implements JainMgcpListener {
        private MediaErr error;
        private String errorMsg;

        public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent evt) {
            ModifyConnectionResponse resp = (ModifyConnectionResponse)evt;
            switch (resp.getReturnCode().getValue()) {
                case 100: {
                    return;
                }
                case 200: {
                    try {
                        Link.this.signal("success");
                    }
                    catch (UnknownTransitionException e) {}
                    break;
                }
                default: {
                    try {
                        Link.this.signal("failure");
                        break;
                    }
                    catch (UnknownTransitionException unknownTransitionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class StartRequest
    implements TransitionHandler {
        private StartRequest() {
        }

        @Override
        public void process(State state) {
            int txID = ((Link)Link.this).containers[0].session.getDriver().getNextTxID();
            ConnectionMode mode0 = Link.this.getMode0(Link.this.containers[0]);
            ModifyConnection mdcx = new ModifyConnection((Object)this, ((Link)Link.this).containers[0].session.getCallID(), ((Link)Link.this).containers[0].endpoint.getIdentifier(), Link.this.connections[0]);
            mdcx.setMode(mode0);
            mdcx.setTransactionHandle(txID);
            if (Link.this.containers[0] instanceof MediaMixerImpl && ((MediaMixerImpl)Link.this.containers[0]).hasDtmfClamp()) {
                LocalOptionExtension currExtention = new LocalOptionExtension("x-dc", "true");
                mdcx.setLocalConnectionOptions(new LocalOptionValue[]{currExtention});
            }
            ((Link)Link.this).containers[0].session.getDriver().attach(txID, (JainMgcpListener)new StartResponse());
            ((Link)Link.this).containers[0].session.getDriver().send((JainMgcpEvent)mdcx);
            txID = ((Link)Link.this).containers[1].session.getDriver().getNextTxID();
            ConnectionMode mode1 = Link.this.getMode1(Link.this.containers[1]);
            mdcx = new ModifyConnection((Object)this, ((Link)Link.this).containers[1].session.getCallID(), ((Link)Link.this).containers[1].endpoint.getIdentifier(), Link.this.connections[1]);
            mdcx.setMode(mode1);
            mdcx.setTransactionHandle(txID);
            if (Link.this.containers[1] instanceof MediaMixerImpl && ((MediaMixerImpl)Link.this.containers[1]).hasDtmfClamp()) {
                LocalOptionExtension currExtention = new LocalOptionExtension("x-dc", "true");
                mdcx.setLocalConnectionOptions(new LocalOptionValue[]{currExtention});
            }
            ((Link)Link.this).containers[0].session.getDriver().attach(txID, (JainMgcpListener)new StartResponse());
            ((Link)Link.this).containers[0].session.getDriver().send((JainMgcpEvent)mdcx);
        }
    }

    public class JoinResponse
    implements JainMgcpListener {
        public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent evt) {
            CreateConnectionResponse resp = (CreateConnectionResponse)evt;
            switch (resp.getReturnCode().getValue()) {
                case 100: {
                    return;
                }
                case 200: {
                    Link.this.containers[0].setConcreteName(resp.getSpecificEndpointIdentifier());
                    Link.this.containers[1].setConcreteName(resp.getSecondEndpointIdentifier());
                    Link.this.connections[0] = resp.getConnectionIdentifier();
                    Link.this.connections[1] = resp.getSecondConnectionIdentifier();
                    try {
                        Link.this.signal("success");
                    }
                    catch (Exception e) {}
                    break;
                }
                default: {
                    try {
                        Link.this.signal("failure");
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class JoinRequest
    implements TransitionHandler {
        private JoinRequest() {
        }

        @Override
        public void process(State state) {
            if (((Link)Link.this).containers[0].endpoint.concreteNameExpectedSoon()) {
                try {
                    ((Link)Link.this).containers[0].endpoint.await();
                }
                catch (InterruptedException e) {
                    Link.this.signalAsync("failure");
                    return;
                }
            }
            if (!((Link)Link.this).containers[0].endpoint.hasConcreteName()) {
                ((Link)Link.this).containers[0].endpoint.expectingConcreteName();
            }
            if (((Link)Link.this).containers[1].endpoint.concreteNameExpectedSoon()) {
                try {
                    ((Link)Link.this).containers[1].endpoint.await();
                }
                catch (InterruptedException e) {
                    Link.this.signalAsync("failure");
                    return;
                }
            }
            if (!((Link)Link.this).containers[1].endpoint.hasConcreteName()) {
                ((Link)Link.this).containers[1].endpoint.expectingConcreteName();
            }
            int txID = ((Link)Link.this).containers[0].session.getDriver().getNextTxID();
            CreateConnection crcx = new CreateConnection((Object)this, ((Link)Link.this).containers[0].session.getCallID(), ((Link)Link.this).containers[0].endpoint.getIdentifier(), ConnectionMode.Inactive);
            crcx.setTransactionHandle(txID);
            crcx.setNotifiedEntity(((Link)Link.this).containers[0].session.getDriver().getCallAgent());
            try {
                crcx.setSecondEndpointIdentifier(((Link)Link.this).containers[1].endpoint.getIdentifier());
            }
            catch (ConflictingParameterException e) {
                // empty catch block
            }
            ((Link)Link.this).containers[0].session.getDriver().attach(txID, (JainMgcpListener)new JoinResponse());
            ((Link)Link.this).containers[0].session.getDriver().send((JainMgcpEvent)crcx);
        }
    }

    private class InitiateTransmission
    implements TransitionHandler {
        private InitiateTransmission() {
        }

        @Override
        public void process(State state) {
            Link.this.signalAsync("join");
        }
    }
}

