/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.sdp;

import org.mobicents.mscontrol.sdp.Format;
import org.mobicents.mscontrol.sdp.FormatUtils;

public class VideoFormat
extends Format {
    protected int maxDataLength = -1;
    public static final String CINEPAK = "cvid";
    public static final String JPEG = "jpeg";
    public static final String JPEG_RTP = "jpeg/rtp";
    public static final String MPEG = "mpeg";
    public static final String MPEG_RTP = "mpeg/rtp";
    public static final String H261 = "h261";
    public static final String H261_RTP = "h261/rtp";
    public static final String H263 = "h263";
    public static final String H263_RTP = "h263/rtp";
    public static final String H263_1998_RTP = "h263-1998/rtp";
    public static final String RGB = "rgb";
    public static final String YUV = "yuv";
    public static final String IRGB = "irgb";
    public static final String SMC = "smc";
    public static final String RLE = "rle";
    public static final String RPZA = "rpza";
    public static final String MJPG = "mjpg";
    public static final String MJPEGA = "mjpa";
    public static final String MJPEGB = "mjpb";
    public static final String INDEO32 = "iv32";
    public static final String INDEO41 = "iv41";
    public static final String INDEO50 = "iv50";
    private int clockRate;

    public VideoFormat(String encoding) {
        super(encoding);
    }

    public VideoFormat(String encoding, float frameRate, int clockRate) {
        super(encoding);
        this.frameRate = (int)frameRate;
        this.clockRate = clockRate;
    }

    public int getClockRate() {
        return this.clockRate;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    @Override
    public Object clone() {
        return new VideoFormat(this.encoding, this.frameRate, this.clockRate);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.encoding == null) {
            b.append("N/A");
        } else {
            b.append(this.encoding.toUpperCase());
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(", ");
            b.append("FrameRate=");
            b.append(FormatUtils.frameRateToString(this.frameRate));
        }
        if (FormatUtils.specified(this.maxDataLength)) {
            b.append(", ");
            b.append("Length=");
            b.append(this.maxDataLength);
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof VideoFormat)) {
            return false;
        }
        VideoFormat oCast = (VideoFormat)format;
        return oCast.maxDataLength == this.maxDataLength && oCast.frameRate == this.frameRate;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof VideoFormat)) {
            boolean result = true;
            return true;
        }
        VideoFormat oCast = (VideoFormat)format;
        boolean result = FormatUtils.matches(oCast.getFrameRate(), this.getFrameRate());
        return result;
    }

    @Override
    public Format relax() {
        VideoFormat result = (VideoFormat)super.relax();
        result.maxDataLength = -1;
        result.frameRate = -1;
        return result;
    }
}

