/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sdp;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.sdp.Attribute;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import org.mobicents.sdp.AVProfile;
import org.mobicents.sdp.Format;
import org.mobicents.sdp.RTPAudioFormat;
import org.mobicents.sdp.RTPVideoFormat;

public abstract class RTPFormatParser
extends Format {
    private int payloadType;

    public RTPFormatParser(String encodingName) {
        super(encodingName);
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public static synchronized HashMap<Integer, Format> getFormats(SessionDescription sdp, String mediaType) throws SdpParseException, SdpException {
        HashMap<Integer, Format> formats = new HashMap<Integer, Format>();
        Enumeration mediaDescriptions = sdp.getMediaDescriptions(false).elements();
        while (mediaDescriptions.hasMoreElements()) {
            HashMap<Integer, Format> fmts;
            MediaDescription md = (MediaDescription)mediaDescriptions.nextElement();
            if (!md.getMedia().getMediaType().equals(mediaType) || (fmts = RTPFormatParser.getFormats(md)) == null) continue;
            formats.putAll(fmts);
        }
        return formats;
    }

    public static HashMap<Integer, Format> getFormats(MediaDescription md) throws SdpParseException, SdpException {
        Media media = md.getMedia();
        if (media.getMediaType().equals("audio")) {
            return RTPFormatParser.getAudioFormats(md);
        }
        if (media.getMediaType().equals("video")) {
            return RTPFormatParser.getVideoFormats(md);
        }
        return null;
    }

    private static HashMap<Integer, Format> getAudioFormats(MediaDescription md) throws SdpParseException, SdpException {
        HashMap<Integer, Format> formats = new HashMap<Integer, Format>();
        Media media = md.getMedia();
        Enumeration payloads = media.getMediaFormats(false).elements();
        while (payloads.hasMoreElements()) {
            int payload = Integer.parseInt((String)payloads.nextElement());
            RTPAudioFormat fmt = AVProfile.getAudioFormat(payload);
            if (fmt == null) continue;
            formats.put(new Integer(payload), fmt);
        }
        Enumeration attributes = md.getAttributes(false).elements();
        while (attributes.hasMoreElements()) {
            RTPAudioFormat fmt;
            Attribute attribute = (Attribute)attributes.nextElement();
            if (!attribute.getName().equals("rtpmap") || (fmt = RTPAudioFormat.parseRtpmapFormat(attribute.getValue())) == null) continue;
            formats.put(new Integer(fmt.getPayloadType()), fmt);
        }
        return formats;
    }

    private static HashMap<Integer, Format> getVideoFormats(MediaDescription md) throws SdpParseException, SdpException {
        HashMap<Integer, Format> formats = new HashMap<Integer, Format>();
        Media media = md.getMedia();
        Enumeration payloads = media.getMediaFormats(false).elements();
        while (payloads.hasMoreElements()) {
            int payload = Integer.parseInt((String)payloads.nextElement());
            RTPVideoFormat fmt = AVProfile.getVideoFormat(payload);
            if (fmt == null) continue;
            formats.put(new Integer(payload), fmt);
        }
        Enumeration attributes = md.getAttributes(false).elements();
        while (attributes.hasMoreElements()) {
            Attribute attribute = (Attribute)attributes.nextElement();
            if (!attribute.getName().equals("rtpmap")) continue;
            RTPVideoFormat fmt = RTPVideoFormat.parseFormat(attribute.getValue());
            formats.put(new Integer(fmt.getPayloadType()), fmt);
        }
        return formats;
    }

    public String toSdp() {
        return null;
    }

    public abstract Collection<Attribute> encode();
}

