/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;

public class SdpProcessor {
    private HashMap<String, RTPFormat> profile = new HashMap();

    public SdpProcessor() {
        this.profile.put("0", new RTPFormat("0", "pcmu/8000"));
        this.profile.put("8", new RTPFormat("8", "pcma/8000"));
    }

    public boolean containsFormat(String format, SessionDescription sdp) throws SdpException {
        Vector mds = sdp.getMediaDescriptions(false);
        for (MediaDescription m : mds) {
            Vector attributes = m.getAttributes(false);
            for (Attribute a : attributes) {
                if (!a.getName().equalsIgnoreCase("rtpmap") || !a.getValue().toLowerCase().contains(format.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsMedia(String media, SessionDescription sdp) throws SdpException {
        Vector mds = sdp.getMediaDescriptions(false);
        for (MediaDescription m : mds) {
            if (!m.getMedia().getMediaType().equalsIgnoreCase(media)) continue;
            return true;
        }
        return false;
    }

    public void exclude(String f, SessionDescription sdp) throws SdpException {
        Vector mds = sdp.getMediaDescriptions(false);
        for (MediaDescription m : mds) {
            Collection<RTPFormat> fmts = this.getRTPFormats(m);
            for (RTPFormat rtpFormat : fmts) {
                if (!rtpFormat.description.toLowerCase().contains(f.toLowerCase())) continue;
                this.excludeFormat(rtpFormat.id, m);
                this.excludeAttribute(rtpFormat.id, m);
            }
        }
    }

    private void excludeFormat(String id, MediaDescription m) throws SdpParseException {
        String s;
        Vector fmts = m.getMedia().getMediaFormats(false);
        int count = 0;
        Iterator i$ = fmts.iterator();
        while (i$.hasNext() && !(s = (String)i$.next()).equals(id)) {
            ++count;
        }
        if (count < fmts.size()) {
            fmts.remove(count);
        }
    }

    public void excludeAttribute(String id, MediaDescription m) throws SdpParseException {
        String[] tokens;
        Attribute a;
        Vector attributes = m.getAttributes(false);
        int count = 0;
        Iterator i$ = attributes.iterator();
        while (!(!i$.hasNext() || (a = (Attribute)i$.next()).getName().equalsIgnoreCase("rtpmap") && (tokens = a.getValue().split(" "))[0].trim().equalsIgnoreCase(id))) {
            ++count;
        }
        if (count < attributes.size()) {
            attributes.remove(count);
        }
    }

    public boolean checkForMinimalOffer(SessionDescription sdp) throws SdpException {
        Vector mds = sdp.getMediaDescriptions(false);
        for (MediaDescription m : mds) {
            if (m.getMedia().getMediaFormats(false) != null) continue;
            return false;
        }
        return true;
    }

    private Collection<RTPFormat> getRTPFormats(MediaDescription md) throws SdpParseException {
        ArrayList<RTPFormat> formats = new ArrayList<RTPFormat>();
        Vector fmts = md.getMedia().getMediaFormats(false);
        Vector attributes = md.getAttributes(false);
        for (String f : fmts) {
            RTPFormat format = null;
            for (Attribute a : attributes) {
                String[] tokens;
                if (!a.getName().equalsIgnoreCase("rtpmap") || !(tokens = a.getValue().split(" "))[0].equalsIgnoreCase(f)) continue;
                format = new RTPFormat(tokens[0].trim(), tokens[1].trim());
                break;
            }
            if (format == null) {
                format = this.profile.get(f);
            }
            if (format == null) continue;
            formats.add(format);
        }
        return formats;
    }

    private class RTPFormat {
        private String id;
        private String description;

        public RTPFormat(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String toString() {
            return this.id + ":" + this.description;
        }
    }
}

