/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import java.net.URI;
import java.util.Iterator;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalGenerator;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.container.ContainerImpl;
import org.mobicents.javax.media.mscontrol.container.Endpoint;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerConfigImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerRecorderSignalDetectorConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerSignalDetectorConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderConfigImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.SignalDetectorConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorImpl;

public class MediaGroupImpl
extends ContainerImpl
implements MediaGroup {
    public static final MediaConfig PLAYER_CONFIG = new PlayerConfigImpl().getConfig();
    public static final MediaConfig SIGNAL_DETECTOR_CONFIG = new SignalDetectorConfig().getConfig();
    public static final MediaConfig PLAYER_SIGNAL_DETECTOR_CONFIG = new PlayerSignalDetectorConfig().getConfig();
    public static final MediaConfig RECORDER_CONFIG = new RecorderConfigImpl().getConfig();
    public static final MediaConfig PLAYER_RECORDER_SIGNAL_DETECTOR_CONFIG = new PlayerRecorderSignalDetectorConfig().getConfig();
    private URI uri = null;
    protected PlayerImpl player = null;
    protected RecorderImpl recorder = null;
    protected SignalDetectorImpl detector = null;
    protected SignalGenerator generator = null;
    public RequestIdentifier reqID = null;
    private Boolean stopping = false;

    public MediaGroupImpl(MediaSessionImpl session, MediaConfigImpl config) throws MsControlException {
        super(session, config.getParameters());
        String localName = (String)config.getValue(ENDPOINT_NAME);
        String domainName = session.getDriver().getRemoteDomainName();
        this.endpoint = new Endpoint(new EndpointIdentifier(localName, domainName));
        this.player = new PlayerImpl(this);
        this.recorder = new RecorderImpl(this);
        this.detector = new SignalDetectorImpl(this, config);
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void waitForStop() {
        this.stopping = true;
    }

    public void releaseStop() {
        this.stopping = false;
        this.player.stopCompleted();
        this.recorder.stopCompleted();
        this.detector.stopCompleted();
    }

    public Player getPlayer() throws MsControlException {
        if (this.player != null) {
            return this.player;
        }
        throw new MsControlException(this.uri + " This MediaGroup contains no Player");
    }

    public Recorder getRecorder() throws MsControlException {
        if (this.recorder != null) {
            return this.recorder;
        }
        throw new MsControlException(this.uri + " This MediaGroup contains no Recorder");
    }

    public SignalDetector getSignalDetector() throws MsControlException {
        if (this.detector != null) {
            return this.detector;
        }
        throw new MsControlException(this.uri + " This MediaGroup contains no Signal Detector");
    }

    public SignalGenerator getSignalGenerator() throws MsControlException {
        if (this.generator != null) {
            return this.generator;
        }
        throw new MsControlException(this.uri + " This MediaGroup contains no Signal Generator");
    }

    public void stop() {
        this.player.stop(true);
        this.recorder.stop();
        this.detector.stop();
    }

    public void confirm() throws MsControlException {
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> arg0) throws MsControlException {
        return null;
    }

    public void triggerRTC(Action rtca) {
    }

    public void release() {
        this.info("Releasing...");
        try {
            this.unjoin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Iterator<MediaObject> getMediaObjects() {
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        return null;
    }

    public void addListener(AllocationEventListener paramAllocationEventListener) {
    }

    public void removeListener(AllocationEventListener paramAllocationEventListener) {
    }

    public void triggerAction(Action action) {
        if (action == null) {
            return;
        }
        if (action.equals(SignalDetector.FLUSH_BUFFER)) {
            throw new IllegalStateException(this.uri + " This MediaGroup contains no Signal Detector");
        }
        if (action.equals(SignalDetector.STOP) ? this.detector == null : action.equals(SignalDetector.CANCEL) && this.detector == null) {
            throw new IllegalStateException(this.uri + " This MediaGroup contains no Signal Detector");
        }
    }

    public RequestIdentifier nextRequestID() {
        return new RequestIdentifier(Integer.toString(this.session.getUniqueReqID()));
    }
}

