/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.sdp;

import org.mobicents.mscontrol.sdp.AVProfile;
import org.mobicents.mscontrol.sdp.AudioFormat;
import org.mobicents.mscontrol.sdp.Format;
import org.mobicents.mscontrol.sdp.FormatParser;

public class AudioFormatParser
implements FormatParser {
    @Override
    public Format getFormat(int payload) {
        return AVPROFILE.getAudioFormat(payload);
    }

    @Override
    public boolean parse(String rtpmap, int[] payloads, Format[] formats, int count) {
        int channels;
        int index;
        int pos = rtpmap.indexOf(58);
        int pos1 = rtpmap.indexOf(32, pos);
        int payload = Integer.parseInt(rtpmap.substring(pos + 1, pos1));
        for (index = 0; index < count && payloads[index] != payload; ++index) {
        }
        pos = rtpmap.indexOf(47, pos1);
        String encoding = rtpmap.substring(pos1 + 1, pos);
        pos1 = rtpmap.indexOf(47, pos + 1);
        double clockRate = pos1 > 0 ? Double.parseDouble(rtpmap.substring(pos + 1, pos1)) : Double.parseDouble(rtpmap.substring(pos + 1, rtpmap.length()));
        int n = channels = pos1 > 0 ? Integer.parseInt(rtpmap.substring(pos1 + 1, rtpmap.length())) : 1;
        if (encoding.equalsIgnoreCase("pcmu")) {
            formats[index] = new AudioFormat("ULAW", clockRate, 8, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("pcma")) {
            formats[index] = new AudioFormat("ALAW", clockRate, 8, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("telephone-event")) {
            formats[index] = new AudioFormat("telephone-event", clockRate, -1, -1);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("g729")) {
            formats[index] = new AudioFormat("G729", clockRate, -1, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("gsm")) {
            formats[index] = new AudioFormat("GSM", clockRate, -1, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("l16")) {
            formats[index] = new AudioFormat("LINEAR", clockRate, 16, channels, 0, 1);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("AMR")) {
            formats[index] = new AudioFormat("AMR", clockRate, -1, channels);
            payloads[index] = payload;
        } else {
            formats[index] = new AudioFormat(encoding, clockRate, -1, channels);
            payloads[index] = payload;
        }
        return index == count;
    }

    @Override
    public void write(StringBuffer buff, int p, Format f) {
        AudioFormat fmt = (AudioFormat)f;
        String encName = f.getEncoding();
        buff.append("a=rtpmap:");
        buff.append(p);
        buff.append(" ");
        if (encName.equalsIgnoreCase("alaw")) {
            buff.append("PCMA");
        } else if (encName.equalsIgnoreCase("ulaw")) {
            buff.append("PCMU");
        } else if (encName.equalsIgnoreCase("linear")) {
            buff.append("L" + fmt.getSampleSizeInBits());
        } else {
            buff.append(encName);
        }
        double sr = fmt.getSampleRate();
        if (sr > 0.0) {
            buff.append("/");
            if (sr - (double)((int)sr) < 1.0E-6) {
                buff.append((int)sr);
            } else {
                buff.append(sr);
            }
        }
        if (fmt.getChannels() > 1) {
            buff.append("/" + fmt.getChannels());
        }
        if (f.equals(AVProfile.DTMF)) {
            buff.append("\na=fmtp:" + p + " 0-15");
        }
    }
}

