/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser;

import jain.protocol.ip.mgcp.message.parms.Bandwidth;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CapabilityValue;
import jain.protocol.ip.mgcp.message.parms.CompressionAlgorithm;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EchoCancellation;
import jain.protocol.ip.mgcp.message.parms.EmbeddedRequest;
import jain.protocol.ip.mgcp.message.parms.EncryptionMethod;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ExtendedConnectionParm;
import jain.protocol.ip.mgcp.message.parms.GainControl;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.LocalOptVal;
import jain.protocol.ip.mgcp.message.parms.LocalOptionExtension;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.PacketizationPeriod;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ResourceReservation;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.message.parms.SilenceSuppression;
import jain.protocol.ip.mgcp.message.parms.SupportedModes;
import jain.protocol.ip.mgcp.message.parms.SupportedPackages;
import jain.protocol.ip.mgcp.message.parms.TypeOfNetwork;
import jain.protocol.ip.mgcp.message.parms.TypeOfService;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.mobicents.protocols.mgcp.jain.pkg.AUPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);
    private static final char AMPERSAND = '@';
    private static final String REGEX_EMBEDDED_COMMAND = "\\(E\\(.*\\)\\)";
    private static final Pattern pattern = Pattern.compile("\\(E\\(.*\\)\\)");
    private static final Pattern commaPattern = Pattern.compile(",");
    private static final Pattern equalsPattern = Pattern.compile("=");
    private static final Pattern colonPattern = Pattern.compile(":");
    private static final Pattern semiColonPattern = Pattern.compile(";");
    private static final Pattern dashPattern = Pattern.compile("-");
    PackageName au = AUPackage.AU;
    MgcpEvent rfc2897pa = AUMgcpEvent.aupa;
    StringBuilder decdReqEveStrBuilder = new StringBuilder();
    List<String> list = new ArrayList<String>();
    List<String> decdEventName = new ArrayList<String>();
    List<String> decdReqtEventList = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] splitStringBySpace(String value) {
        try {
            String[] token = null;
            this.split(' ', value, this.decdEventName);
            token = new String[this.decdEventName.size()];
            this.decdEventName.toArray(token);
            String[] stringArray = token;
            return stringArray;
        }
        finally {
            this.decdEventName.clear();
        }
    }

    public ConnectionMode decodeConnectionMode(String mode) {
        if (mode.equals("sendrecv")) {
            return ConnectionMode.SendRecv;
        }
        if (mode.equalsIgnoreCase("sendonly")) {
            return ConnectionMode.SendOnly;
        }
        if (mode.equalsIgnoreCase("recvonly")) {
            return ConnectionMode.RecvOnly;
        }
        if (mode.equalsIgnoreCase("confrnce")) {
            return ConnectionMode.Confrnce;
        }
        if (mode.equalsIgnoreCase("conttest")) {
            return ConnectionMode.Conttest;
        }
        if (mode.equalsIgnoreCase("data")) {
            return ConnectionMode.Data;
        }
        if (mode.equalsIgnoreCase("loopback")) {
            return ConnectionMode.Loopback;
        }
        if (mode.equalsIgnoreCase("netwloop")) {
            return ConnectionMode.Netwloop;
        }
        if (mode.equalsIgnoreCase("netwtest")) {
            return ConnectionMode.Netwtest;
        }
        return ConnectionMode.Inactive;
    }

    public String encodeBearerInformation(BearerInformation bearerInformation) {
        StringBuffer s = new StringBuffer("e:");
        if (1 == bearerInformation.getEncodingMethod()) {
            s.append("A");
        } else if (2 == bearerInformation.getEncodingMethod()) {
            s.append("mu");
        }
        return s.toString();
    }

    public BearerInformation decodeBearerInformation(String text) throws ParseException {
        if (!(text = text.toLowerCase()).startsWith("e:")) {
            throw new ParseException("Bearer extensions not supported", 0);
        }
        if ((text = text.substring(text.indexOf(":") + 1).trim()).equals("a")) {
            return BearerInformation.EncMethod_A_Law;
        }
        if (text.equals("mu")) {
            return BearerInformation.EncMethod_mu_Law;
        }
        throw new ParseException("Unknown value for BearerInformation: " + text, 0);
    }

    public LocalOptionValue[] decodeLocalOptionValueList(String text) throws ParseException {
        String[] tokens = commaPattern.split(text, 0);
        LocalOptionValue[] options = new LocalOptionValue[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            options[i] = this.decodeLocalOptionValue(tokens[i]);
        }
        return options;
    }

    public LocalOptionValue decodeLocalOptionValue(String text) throws ParseException {
        int pos = text.indexOf(58);
        if (pos < 0) {
            throw new ParseException("Could not parse local connection option: " + text, 0);
        }
        String name = text.substring(0, pos).trim();
        String value = text.substring(pos + 1).trim();
        if (name.equalsIgnoreCase("a")) {
            return this.decodeCompressionAlgorithm(value);
        }
        if (name.equalsIgnoreCase("p")) {
            return this.decodePacketizationPeriod(value);
        }
        if (name.equalsIgnoreCase("b")) {
            return this.decodeBandwidth(value);
        }
        if (name.equalsIgnoreCase("e")) {
            return this.decodeEchoCancellation(value);
        }
        if (name.equalsIgnoreCase("gc")) {
            return this.decodeGainControl(value);
        }
        if (name.equalsIgnoreCase("s")) {
            return this.decodeSilenceSuppression(value);
        }
        if (name.equalsIgnoreCase("t")) {
            return this.decodeTypeOfService(value);
        }
        if (name.equalsIgnoreCase("r")) {
            return this.decodeResourceReservation(value);
        }
        if (name.equalsIgnoreCase("k")) {
            return this.decodeEncryptionMethod(value);
        }
        if (name.equalsIgnoreCase("nt")) {
            return this.decodeTypeOfNetwork(value);
        }
        return new LocalOptionExtension(name, value);
    }

    public String encodeLocalOptionVale(LocalOptionValue localOptionValue) {
        StringBuffer s = new StringBuffer("");
        switch (localOptionValue.getLocalOptionValueType()) {
            case 3: {
                Bandwidth b = (Bandwidth)localOptionValue;
                s.append("b:").append(this.encodeBandwidth(b));
                break;
            }
            case 2: {
                CompressionAlgorithm compressionAlgorithm = (CompressionAlgorithm)localOptionValue;
                s.append("a:").append(this.encodeCompressionAlgorithm(compressionAlgorithm));
                break;
            }
            case 4: {
                EchoCancellation echoCancellation = (EchoCancellation)localOptionValue;
                s.append("e:").append(this.encodeEchoCancellation(echoCancellation));
                break;
            }
            case 10: {
                EncryptionMethod encryptionMethod = (EncryptionMethod)localOptionValue;
                s.append("k:").append(this.encodeEncryptionMethod(encryptionMethod));
                break;
            }
            case 6: {
                GainControl gainControl = (GainControl)localOptionValue;
                s.append("gc:").append(this.encodeGainControl(gainControl));
                break;
            }
            case 11: {
                LocalOptionExtension localOptionExtension = (LocalOptionExtension)localOptionValue;
                s.append(localOptionExtension.getLocalOptionExtensionName()).append(":").append(localOptionExtension.getLocalOptionExtensionValue());
                break;
            }
            case 1: {
                PacketizationPeriod packetizationPeriod = (PacketizationPeriod)localOptionValue;
                s.append("p:").append(this.encodePacketizationPeriod(packetizationPeriod));
                break;
            }
            case 8: {
                s.append("r:");
                ResourceReservation resourceReservation = (ResourceReservation)localOptionValue;
                s.append(this.encodeResourceReservation(resourceReservation));
                break;
            }
            case 5: {
                s.append("s:");
                SilenceSuppression silenceSuppression = (SilenceSuppression)localOptionValue;
                s.append(this.encodeSilenceSuppression(silenceSuppression));
                break;
            }
            case 9: {
                s.append("nt:");
                TypeOfNetwork typeOfNetwork = (TypeOfNetwork)localOptionValue;
                s.append(this.encodeTypeOfNetwork(typeOfNetwork));
                break;
            }
            case 7: {
                TypeOfService typeOfService = (TypeOfService)localOptionValue;
                s.append("t:").append(this.encodeTypeOfService(typeOfService));
                break;
            }
            default: {
                logger.error((Object)("LocalOptionValue " + localOptionValue + " not identified"));
            }
        }
        return s.toString();
    }

    public CompressionAlgorithm decodeCompressionAlgorithm(String value) throws ParseException {
        return new CompressionAlgorithm(semiColonPattern.split(value, 0));
    }

    public String encodeCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        StringBuffer s = new StringBuffer("");
        String[] names = compressionAlgorithm.getCompressionAlgorithmNames();
        boolean first = true;
        for (int i = 0; i < names.length; ++i) {
            if (first) {
                first = false;
            } else {
                s.append(";");
            }
            s.append(names[i]);
        }
        return s.toString();
    }

    public PacketizationPeriod decodePacketizationPeriod(String value) throws ParseException {
        int pos = value.indexOf(45);
        if (pos < 0) {
            try {
                return new PacketizationPeriod(Integer.parseInt(value));
            }
            catch (Exception e) {
                throw new ParseException("Invalid packetization period:" + value, 0);
            }
        }
        String low = value.substring(0, pos).trim();
        String hight = value.substring(pos + 1).trim();
        try {
            return new PacketizationPeriod(Integer.parseInt(low), Integer.parseInt(hight));
        }
        catch (Exception e) {
            throw new ParseException("Invalid packetization period:" + value, 0);
        }
    }

    public String encodePacketizationPeriod(PacketizationPeriod packetizationPeriod) {
        StringBuffer s = new StringBuffer("");
        if (packetizationPeriod.getPacketizationPeriodLowerBound() != packetizationPeriod.getPacketizationPeriodUpperBound()) {
            s.append(packetizationPeriod.getPacketizationPeriodLowerBound()).append("-").append(packetizationPeriod.getPacketizationPeriodUpperBound());
        } else {
            s.append(packetizationPeriod.getPacketizationPeriodLowerBound());
        }
        return s.toString();
    }

    public Bandwidth decodeBandwidth(String value) throws ParseException {
        int pos = value.indexOf(45);
        if (pos < 0) {
            try {
                return new Bandwidth(Integer.parseInt(value));
            }
            catch (Exception e) {
                throw new ParseException("Invalid packetization period:" + value, 0);
            }
        }
        String low = value.substring(0, pos).trim();
        String hight = value.substring(pos + 1).trim();
        try {
            return new Bandwidth(Integer.parseInt(low), Integer.parseInt(hight));
        }
        catch (Exception e) {
            throw new ParseException("Invalid packetization period:" + value, 0);
        }
    }

    public String encodeBandwidth(Bandwidth bandwidth) {
        StringBuffer s = new StringBuffer("");
        if (bandwidth.getBandwidthLowerBound() != bandwidth.getBandwidthUpperBound()) {
            s.append(bandwidth.getBandwidthLowerBound()).append("-").append(bandwidth.getBandwidthUpperBound());
        } else {
            s.append(bandwidth.getBandwidthLowerBound());
        }
        return s.toString();
    }

    public EchoCancellation decodeEchoCancellation(String value) throws ParseException {
        if (value.equalsIgnoreCase("on")) {
            return EchoCancellation.EchoCancellationOn;
        }
        if (value.equalsIgnoreCase("of")) {
            return EchoCancellation.EchoCancellationOff;
        }
        throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
    }

    public String encodeEchoCancellation(EchoCancellation echoCancellation) {
        StringBuffer s = new StringBuffer("");
        if (echoCancellation.getEchoCancellation()) {
            s.append("on");
        } else {
            s.append("off");
        }
        return s.toString();
    }

    public GainControl decodeGainControl(String value) throws ParseException {
        if (value.equalsIgnoreCase("auto")) {
            return new GainControl();
        }
        try {
            return new GainControl(Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
        }
    }

    public String encodeGainControl(GainControl gainControl) {
        StringBuffer s = new StringBuffer("");
        if (gainControl.getGainControl() == 0) {
            s.append("auto");
        } else {
            s.append(gainControl.getGainControl());
        }
        return s.toString();
    }

    public SilenceSuppression decodeSilenceSuppression(String value) throws ParseException {
        if (value.equalsIgnoreCase("on")) {
            return SilenceSuppression.SilenceSuppressionOn;
        }
        if (value.equalsIgnoreCase("off")) {
            return SilenceSuppression.SilenceSuppressionOff;
        }
        throw new ParseException("Invalid value for SilenceSuppression :" + value, 0);
    }

    public String encodeSilenceSuppression(SilenceSuppression silenceSuppression) {
        StringBuffer s = new StringBuffer("");
        if (silenceSuppression.getSilenceSuppression()) {
            s.append("on");
        } else {
            s.append("off");
        }
        return s.toString();
    }

    public TypeOfService decodeTypeOfService(String value) throws ParseException {
        try {
            return new TypeOfService((byte)Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new ParseException("Invalid value for TypeOfService :" + value, 0);
        }
    }

    public String encodeTypeOfService(TypeOfService typeOfService) {
        String s = Integer.toString(typeOfService.getTypeOfService(), 16).toUpperCase();
        return s;
    }

    public ResourceReservation decodeResourceReservation(String value) throws ParseException {
        if (value.equalsIgnoreCase("g")) {
            return ResourceReservation.Guaranteed;
        }
        if (value.equalsIgnoreCase("cl")) {
            return ResourceReservation.ControlledLoad;
        }
        if (value.equalsIgnoreCase("be")) {
            return ResourceReservation.BestEffort;
        }
        throw new ParseException("Invalid value for EchoCancellation :" + value, 0);
    }

    public String encodeResourceReservation(ResourceReservation resourceReservation) {
        StringBuffer s = new StringBuffer("");
        switch (resourceReservation.getResourceReservation()) {
            case 3: {
                s.append("be");
                break;
            }
            case 2: {
                s.append("cl");
                break;
            }
            case 1: {
                s.append("g");
            }
        }
        return s.toString();
    }

    public EncryptionMethod decodeEncryptionMethod(String value) throws ParseException {
        int pos = value.indexOf(58);
        if (pos < 0) {
            throw new ParseException("Invalid value for EncryptionData: " + value, 0);
        }
        String method = value.substring(0, pos).trim();
        String key = value.substring(pos + 1).trim();
        if (method.equalsIgnoreCase("clear")) {
            return new EncryptionMethod(1, key);
        }
        if (method.equalsIgnoreCase("base64")) {
            return new EncryptionMethod(2, key);
        }
        if (method.equalsIgnoreCase("uri")) {
            return new EncryptionMethod(3, key);
        }
        throw new ParseException("Invalid value for EncryptionData: " + method, 0);
    }

    public String encodeEncryptionMethod(EncryptionMethod encryptionMethod) {
        StringBuffer s = new StringBuffer("");
        switch (encryptionMethod.getEncryptionMethod()) {
            case 2: {
                s.append("base64:").append(encryptionMethod.getEncryptionKey());
                break;
            }
            case 1: {
                s.append("clear:").append(encryptionMethod.getEncryptionKey());
                break;
            }
            case 3: {
                s.append("uri:").append(encryptionMethod.getEncryptionKey());
            }
        }
        return s.toString();
    }

    public TypeOfNetwork decodeTypeOfNetwork(String value) throws ParseException {
        if (value.equalsIgnoreCase("in")) {
            return TypeOfNetwork.In;
        }
        if (value.equalsIgnoreCase("atm")) {
            return TypeOfNetwork.Atm;
        }
        if (value.equalsIgnoreCase("local")) {
            return TypeOfNetwork.Local;
        }
        throw new ParseException("Invalid value for TypeOfNetwork :" + value, 0);
    }

    public String encodeTypeOfNetwork(TypeOfNetwork typeOfNetwork) {
        StringBuffer s = new StringBuffer("");
        switch (typeOfNetwork.getTypeOfNetwork()) {
            case 1: {
                s.append("in");
                break;
            }
            case 2: {
                s.append("atm");
                break;
            }
            case 3: {
                s.append("local");
            }
        }
        return s.toString();
    }

    public RestartMethod decodeRestartMethod(String value) throws ParseException {
        if (value.equalsIgnoreCase("graceful")) {
            return RestartMethod.Graceful;
        }
        if (value.equalsIgnoreCase("forced")) {
            return RestartMethod.Forced;
        }
        if (value.equalsIgnoreCase("restart")) {
            return RestartMethod.Restart;
        }
        if (value.equalsIgnoreCase("disconnected")) {
            return RestartMethod.Disconnected;
        }
        if (value.equalsIgnoreCase("cancel-grateful")) {
            return RestartMethod.CancelGraceful;
        }
        throw new ParseException("Extension restarts not (yet) supported:" + value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestedEvent[] decodeRequestedEventList(String value) throws ParseException {
        this.split(',', value, this.decdReqtEventList);
        try {
            int size = this.decdReqtEventList.size();
            RequestedEvent[] events = new RequestedEvent[size];
            for (int i = 0; i < size; ++i) {
                events[i] = this.decodeRequestedEvent(this.decdReqtEventList.get(i));
            }
            RequestedEvent[] requestedEventArray = events;
            return requestedEventArray;
        }
        finally {
            this.decdReqtEventList.clear();
        }
    }

    public RequestedEvent decodeRequestedEvent(String value) throws ParseException {
        char[] valueChar;
        for (char c : valueChar = value.toCharArray()) {
            if (c == ' ') continue;
            this.decdReqEveStrBuilder.append(c);
        }
        value = this.decdReqEveStrBuilder.toString();
        this.decdReqEveStrBuilder.delete(0, valueChar.length);
        int pos1 = value.indexOf(40);
        if (pos1 == -1) {
            return new RequestedEvent(this.decodeEventName(value, null), null);
        }
        String evtName = value.substring(0, pos1);
        Matcher matcher = pattern.matcher(value = value.substring(pos1, value.length()));
        if (matcher.find()) {
            String embeddedNotificatonRequest = value.substring(3, value.length() - 2);
            EmbeddedRequest embeddedRequest = this.decodeEmbeddedRequest(embeddedNotificatonRequest);
            RequestedAction[] actions = new RequestedAction[]{new RequestedAction(embeddedRequest)};
            return new RequestedEvent(this.decodeEventName(evtName, null), actions);
        }
        int pos2 = value.indexOf(41);
        int pos3 = value.indexOf(40, pos2);
        if (pos3 == -1) {
            value = value.substring(1, pos2);
            return new RequestedEvent(this.decodeEventName(evtName, null), this.decodeRequestedActions(value));
        }
        int pos4 = value.indexOf(41, pos3);
        String parms = value.substring(pos3 + 1, pos4);
        value = value.substring(1, pos2);
        return new RequestedEvent(this.decodeEventName(evtName, parms), this.decodeRequestedActions(value));
    }

    private void split(char splitChar, String value, List<String> arryList) {
        char[] charValue = value.toCharArray();
        int count = 0;
        for (char c : charValue) {
            ++count;
            if (c == splitChar) {
                arryList.add(this.decdReqEveStrBuilder.toString());
                this.decdReqEveStrBuilder.delete(0, count);
                count = 0;
                continue;
            }
            this.decdReqEveStrBuilder.append(c);
        }
        arryList.add(this.decdReqEveStrBuilder.toString());
        this.decdReqEveStrBuilder.delete(0, count);
    }

    public EventName decodeEventName(String value, String param) throws ParseException {
        this.split('/', value, this.decdEventName);
        try {
            int size = this.decdEventName.size();
            if (size == 1) {
                EventName eventName = new EventName(PackageName.AllPackages, MgcpEvent.factory((String)this.decdEventName.get(0)).withParm(param));
                return eventName;
            }
            if (size == 2) {
                int pos = this.decdEventName.get(1).indexOf(64);
                if (pos > 0) {
                    String cid = this.decdEventName.get(1).substring(pos + 1).trim();
                    ConnectionIdentifier connectionIdentifier = null;
                    connectionIdentifier = ConnectionIdentifier.AnyConnection.toString().equals(cid) ? ConnectionIdentifier.AnyConnection : (ConnectionIdentifier.AllConnections.toString().equals(cid) ? ConnectionIdentifier.AllConnections : new ConnectionIdentifier(cid));
                    EventName eventName = new EventName(PackageName.factory((String)this.decdEventName.get(0)), MgcpEvent.factory((String)this.decdEventName.get(1).substring(0, pos)).withParm(param), connectionIdentifier);
                    return eventName;
                }
                EventName cid = new EventName(PackageName.factory((String)this.decdEventName.get(0)), MgcpEvent.factory((String)this.decdEventName.get(1)).withParm(param));
                return cid;
            }
            if (size == 3) {
                int pos = this.decdEventName.get(2).indexOf(64);
                if (pos < 0) {
                    throw new ParseException("Invalid token " + this.decdEventName.get(2), 0);
                }
                String cid = this.decdEventName.get(1).substring(pos + 1);
                EventName eventName = new EventName(PackageName.factory((String)this.decdEventName.get(0)), MgcpEvent.factory((String)this.decdEventName.get(1).substring(0, pos)).withParm(param), new ConnectionIdentifier(cid));
                return eventName;
            }
            throw new ParseException("Unexpected event name " + value, 0);
        }
        finally {
            this.decdEventName.clear();
        }
    }

    public String encodeInfoCodeList(InfoCode[] infoCodes) {
        StringBuffer msg = new StringBuffer("");
        boolean first = true;
        block24: for (int i = 0; i < infoCodes.length; ++i) {
            if (first) {
                first = false;
            } else {
                msg.append(',');
            }
            InfoCode infoCode = infoCodes[i];
            switch (infoCode.getInfoCode()) {
                case 1: {
                    msg.append("B");
                    continue block24;
                }
                case 2: {
                    msg.append("C");
                    continue block24;
                }
                case 3: {
                    msg.append("I");
                    continue block24;
                }
                case 4: {
                    msg.append("N");
                    continue block24;
                }
                case 5: {
                    msg.append("X");
                    continue block24;
                }
                case 6: {
                    msg.append("L");
                    continue block24;
                }
                case 7: {
                    msg.append("M");
                    continue block24;
                }
                case 8: {
                    msg.append("R");
                    continue block24;
                }
                case 9: {
                    msg.append("S");
                    continue block24;
                }
                case 10: {
                    msg.append("D");
                    continue block24;
                }
                case 11: {
                    msg.append("O");
                    continue block24;
                }
                case 12: {
                    msg.append("P");
                    continue block24;
                }
                case 13: {
                    msg.append("E");
                    continue block24;
                }
                case 14: {
                    msg.append("Z");
                    continue block24;
                }
                case 15: {
                    msg.append("Q");
                    continue block24;
                }
                case 16: {
                    msg.append("T");
                    continue block24;
                }
                case 17: {
                    msg.append("RC");
                    continue block24;
                }
                case 18: {
                    msg.append("LC");
                    continue block24;
                }
                case 19: {
                    msg.append("A");
                    continue block24;
                }
                case 20: {
                    msg.append("ES");
                    continue block24;
                }
                case 21: {
                    msg.append("RM");
                    continue block24;
                }
                case 22: {
                    msg.append("RD");
                    continue block24;
                }
                default: {
                    logger.error((Object)("The InfoCode " + infoCode + " is not supported"));
                }
            }
        }
        return msg.toString();
    }

    public InfoCode[] decodeInfoCodeList(String value) throws ParseException {
        String[] tokens = commaPattern.split(value.trim(), 0);
        InfoCode[] infoCodes = new InfoCode[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            infoCodes[i] = this.decodeInfoCode(tokens[i]);
        }
        return infoCodes;
    }

    private InfoCode decodeInfoCode(String value) throws ParseException {
        if ((value = value.trim()).equalsIgnoreCase("B")) {
            return InfoCode.BearerInformation;
        }
        if (value.equalsIgnoreCase("C")) {
            return InfoCode.CallIdentifier;
        }
        if (value.equalsIgnoreCase("I")) {
            return InfoCode.ConnectionIdentifier;
        }
        if (value.equalsIgnoreCase("N")) {
            return InfoCode.NotifiedEntity;
        }
        if (value.equalsIgnoreCase("X")) {
            return InfoCode.RequestIdentifier;
        }
        if (value.equalsIgnoreCase("L")) {
            return InfoCode.LocalConnectionOptions;
        }
        if (value.equalsIgnoreCase("M")) {
            return InfoCode.ConnectionMode;
        }
        if (value.equalsIgnoreCase("R")) {
            return InfoCode.RequestedEvents;
        }
        if (value.equalsIgnoreCase("S")) {
            return InfoCode.SignalRequests;
        }
        if (value.equalsIgnoreCase("D")) {
            return InfoCode.DigitMap;
        }
        if (value.equalsIgnoreCase("O")) {
            return InfoCode.ObservedEvents;
        }
        if (value.equalsIgnoreCase("P")) {
            return InfoCode.ConnectionParameters;
        }
        if (value.equalsIgnoreCase("E")) {
            return InfoCode.ReasonCode;
        }
        if (value.equalsIgnoreCase("Z")) {
            return InfoCode.SpecificEndpointID;
        }
        if (value.equalsIgnoreCase("Q")) {
            return InfoCode.QuarantineHandling;
        }
        if (value.equalsIgnoreCase("T")) {
            return InfoCode.DetectEvents;
        }
        if (value.equalsIgnoreCase("RC")) {
            return InfoCode.RemoteConnectionDescriptor;
        }
        if (value.equalsIgnoreCase("LC")) {
            return InfoCode.LocalConnectionDescriptor;
        }
        if (value.equalsIgnoreCase("A")) {
            return InfoCode.Capabilities;
        }
        if (value.equalsIgnoreCase("ES")) {
            return InfoCode.EventStates;
        }
        if (value.equalsIgnoreCase("RM")) {
            return InfoCode.RestartMethod;
        }
        if (value.equalsIgnoreCase("RD")) {
            return InfoCode.RestartDelay;
        }
        throw new ParseException("Extension action not suported", 0);
    }

    public CapabilityValue[] decodeCapabilityList(String value) throws ParseException {
        String[] tokens = commaPattern.split(value.trim(), 0);
        CapabilityValue[] capabilityValues = new CapabilityValue[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            capabilityValues[i] = this.decodeCapability(tokens[i]);
        }
        return capabilityValues;
    }

    public String encodeCapabilityList(CapabilityValue[] c) {
        StringBuffer s = new StringBuffer("");
        boolean first = true;
        for (int i = 0; i < c.length; ++i) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(this.encodeCapability(c[i]));
        }
        return s.toString();
    }

    public String encodeCapability(CapabilityValue c) {
        StringBuffer s = new StringBuffer("");
        switch (c.getCapabilityValueType()) {
            case 1: {
                LocalOptVal localOptVal = (LocalOptVal)c;
                LocalOptionValue localOptionValue = localOptVal.getLocalOptionValue();
                s.append(this.encodeLocalOptionVale(localOptionValue));
                break;
            }
            case 2: {
                s.append("v:");
                SupportedPackages supportedPackages = (SupportedPackages)c;
                PackageName[] packageNameList = supportedPackages.getSupportedPackageNames();
                s.append(this.encodePackageNameList(packageNameList));
                break;
            }
            case 3: {
                s.append("m:");
                SupportedModes supportedModes = (SupportedModes)c;
                ConnectionMode[] connectionModeList = supportedModes.getSupportedModes();
                s.append(this.encodeConnectionModeList(connectionModeList));
            }
        }
        return s.toString();
    }

    public String encodeConnectionModeList(ConnectionMode[] connectionModeList) {
        StringBuffer s = new StringBuffer("");
        boolean first = true;
        for (int i = 0; i < connectionModeList.length; ++i) {
            if (first) {
                first = false;
            } else {
                s.append(";");
            }
            s.append(connectionModeList[i].toString());
        }
        return s.toString();
    }

    public String encodePackageNameList(PackageName[] packageNameList) {
        StringBuffer s = new StringBuffer("");
        boolean first = true;
        for (int i = 0; i < packageNameList.length; ++i) {
            if (first) {
                first = false;
            } else {
                s.append(";");
            }
            s.append(packageNameList[i].toString());
        }
        return s.toString();
    }

    public PackageName[] decodePackageNameList(String value) {
        String[] packages = semiColonPattern.split(value, 0);
        PackageName[] supportedPackageNames = new PackageName[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            PackageName p;
            supportedPackageNames[i] = p = PackageName.factory((String)packages[i]);
        }
        return supportedPackageNames;
    }

    public CapabilityValue decodeCapability(String value) throws ParseException {
        LocalOptVal capabilityValue = null;
        int pos = value.indexOf(58);
        if (pos < 0) {
            throw new ParseException("Invalid value for EncryptionData: " + value, 0);
        }
        String key = value.substring(0, pos).trim();
        String capability = value.substring(pos + 1).trim();
        if ("a".equals(key)) {
            String[] codecs = semiColonPattern.split(capability, 0);
            CompressionAlgorithm compressionAlgorithm = new CompressionAlgorithm(codecs);
            capabilityValue = new LocalOptVal((LocalOptionValue)compressionAlgorithm);
        } else if ("b".equals(key)) {
            int lower;
            String[] bandwidthRange = dashPattern.split(capability, 0);
            int upper = lower = Integer.parseInt(bandwidthRange[0]);
            if (bandwidthRange.length == 2) {
                upper = Integer.parseInt(bandwidthRange[1]);
            }
            Bandwidth bandwidth = new Bandwidth(lower, upper);
            capabilityValue = new LocalOptVal((LocalOptionValue)bandwidth);
        } else if ("p".equals(key)) {
            int lower;
            String[] packetizationRange = dashPattern.split(capability, 0);
            int upper = lower = Integer.parseInt(packetizationRange[0]);
            if (packetizationRange.length == 2) {
                upper = Integer.parseInt(packetizationRange[1]);
            }
            PacketizationPeriod packetizationPeriod = new PacketizationPeriod(lower, upper);
            capabilityValue = new LocalOptVal((LocalOptionValue)packetizationPeriod);
        } else if ("e".equals(key)) {
            capabilityValue = "on".equals(capability) ? new LocalOptVal((LocalOptionValue)EchoCancellation.EchoCancellationOn) : new LocalOptVal((LocalOptionValue)EchoCancellation.EchoCancellationOff);
        } else if ("s".equals(key)) {
            capabilityValue = "on".equals(capability) ? new LocalOptVal((LocalOptionValue)SilenceSuppression.SilenceSuppressionOn) : new LocalOptVal((LocalOptionValue)SilenceSuppression.SilenceSuppressionOff);
        } else if ("gc".equals(key)) {
            int gainControl = 0;
            try {
                gainControl = Integer.parseInt(capability);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
            capabilityValue = new LocalOptVal((LocalOptionValue)new GainControl(gainControl));
        } else if ("t".equals(key)) {
            byte typeOfService = 0;
            try {
                typeOfService = Byte.parseByte(capability);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
            capabilityValue = new LocalOptVal((LocalOptionValue)new TypeOfService(typeOfService));
        } else if ("r".equals(key)) {
            if ("g".equals(capability)) {
                capabilityValue = new LocalOptVal((LocalOptionValue)ResourceReservation.Guaranteed);
            } else if ("cl".equals(capability)) {
                capabilityValue = new LocalOptVal((LocalOptionValue)ResourceReservation.ControlledLoad);
            } else if ("be".equals(capability)) {
                capabilityValue = new LocalOptVal((LocalOptionValue)ResourceReservation.BestEffort);
            }
        } else if ("k".equals(key)) {
            EncryptionMethod encryptionMethod = this.decodeEncryptionMethod(capability);
            capabilityValue = new LocalOptVal((LocalOptionValue)encryptionMethod);
        } else if ("nt".equals(key)) {
            TypeOfNetwork typeOfNetwork = this.decodeTypeOfNetwork(capability);
            capabilityValue = new LocalOptVal((LocalOptionValue)typeOfNetwork);
        } else if ("v".equals(key)) {
            PackageName[] supportedPackageNames = this.decodePackageNameList(capability);
            capabilityValue = new SupportedPackages(supportedPackageNames);
        } else if ("m".equals(key)) {
            String[] modes = semiColonPattern.split(capability, 0);
            ConnectionMode[] supportedConnectionModes = new ConnectionMode[modes.length];
            for (int i = 0; i < modes.length; ++i) {
                ConnectionMode c;
                supportedConnectionModes[i] = c = this.decodeConnectionMode(modes[i]);
            }
            capabilityValue = new SupportedModes(supportedConnectionModes);
        }
        return capabilityValue;
    }

    public RequestedAction[] decodeRequestedActions(String value) throws ParseException {
        String[] tokens = commaPattern.split(value, 0);
        RequestedAction[] actions = new RequestedAction[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            actions[i] = this.decodeRequestedAction(tokens[i]);
        }
        return actions;
    }

    public RequestedAction decodeRequestedAction(String value) throws ParseException {
        if ((value = value.trim()).equalsIgnoreCase("N")) {
            return RequestedAction.NotifyImmediately;
        }
        if (value.equalsIgnoreCase("A")) {
            return RequestedAction.Accumulate;
        }
        if (value.equalsIgnoreCase("S")) {
            return RequestedAction.Swap;
        }
        if (value.equalsIgnoreCase("I")) {
            return RequestedAction.Ignore;
        }
        if (value.equalsIgnoreCase("K")) {
            return RequestedAction.KeepSignalsActive;
        }
        if (value.equalsIgnoreCase("D")) {
            return RequestedAction.TreatAccordingToDigitMap;
        }
        if (value.equalsIgnoreCase("E")) {
            return new RequestedAction(this.decodeEmbeddedRequest(value));
        }
        if (value.equalsIgnoreCase("X")) {
            return RequestedAction.Ignore;
        }
        throw new ParseException("Extension action not suported", 0);
    }

    private String getEvent(String s) {
        char[] c = s.toCharArray();
        String command = "";
        int start = 0;
        int end = 0;
        int paraenthisis = 0;
        boolean first = true;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '(') {
                ++paraenthisis;
                if (first) {
                    first = false;
                    start = i;
                    command = String.valueOf(c[i - 1]);
                }
            } else if (c[i] == ')') {
                --paraenthisis;
            }
            if (first || paraenthisis != 0) continue;
            end = i + 1;
            break;
        }
        return s.substring(0, end);
    }

    public String encodeEmbeddedRequest(EmbeddedRequest embeddedRequest) {
        DigitMap digitMap;
        EventName[] eventNameList;
        StringBuffer s = new StringBuffer("");
        boolean first = true;
        RequestedEvent[] requestedEventList = embeddedRequest.getEmbeddedRequestList();
        if (requestedEventList != null) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("R(").append(this.encodeRequestedEvents(requestedEventList)).append(")");
        }
        if ((eventNameList = embeddedRequest.getEmbeddedSignalRequest()) != null) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("S(").append(this.encodeEventNames(eventNameList)).append(")");
        }
        if ((digitMap = embeddedRequest.getEmbeddedDigitMap()) != null) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("D(").append(digitMap.toString()).append(")");
        }
        return s.toString();
    }

    public EmbeddedRequest decodeEmbeddedRequest(String value) throws ParseException {
        RequestedEvent[] requestedEvents = null;
        EventName[] signalEvents = null;
        DigitMap digitMap = null;
        while (value.length() > 0) {
            String temp = this.getEvent(value);
            value = value.substring(temp.length(), value.length());
            if (temp.startsWith(",")) {
                temp = temp.substring(1, temp.length());
            }
            if (temp.startsWith("R")) {
                temp = temp.substring(2, temp.length() - 1);
                requestedEvents = this.decodeRequestedEventList(temp);
                continue;
            }
            if (temp.startsWith("S")) {
                temp = temp.substring(2, temp.length() - 1);
                signalEvents = this.decodeEventNames(temp);
                continue;
            }
            if (!temp.startsWith("D")) continue;
            temp = temp.substring(2, temp.length() - 1);
            digitMap = new DigitMap(temp);
        }
        return new EmbeddedRequest(requestedEvents, signalEvents, digitMap);
    }

    public EventName[] decodeEventNames(String value) throws ParseException {
        String[] tokens = commaPattern.split(value, 0);
        EventName[] events = new EventName[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String name = null;
            String parm = null;
            int pos = tokens[i].indexOf(40);
            if (pos > 0) {
                name = tokens[i].substring(0, pos);
                parm = tokens[i].substring(pos + 1, tokens[i].length() - 1);
            } else {
                name = tokens[i];
            }
            events[i] = this.decodeEventName(name, parm);
        }
        return events;
    }

    public String encodeEventNames(EventName[] events) {
        StringBuffer s = new StringBuffer("");
        boolean first = true;
        for (EventName e : events) {
            if (first) {
                first = false;
            } else {
                s.append(',');
            }
            s.append(this.encodeEventName(e));
        }
        return s.toString();
    }

    public String encodeEventName(EventName e) {
        StringBuffer s = new StringBuffer("");
        s.append(e.getPackageName().toString()).append('/').append(e.getEventIdentifier().getName());
        if (e.getConnectionIdentifier() != null) {
            s.append('@').append(e.getConnectionIdentifier().toString());
        }
        if (e.getEventIdentifier().getParms() != null) {
            s.append('(').append(e.getEventIdentifier().getParms()).append(')');
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointIdentifier decodeEndpointIdentifier(String name) {
        try {
            this.split('@', name, this.list);
            String[] s = new String[this.list.size()];
            this.list.toArray(s);
            EndpointIdentifier endpointIdentifier = new EndpointIdentifier(s[0], s[1]);
            return endpointIdentifier;
        }
        finally {
            this.list.clear();
        }
    }

    public String encodeEndpointIdentifier(EndpointIdentifier e) {
        String s = e.getLocalEndpointName();
        if (e.getDomainName() != null) {
            s = s + "@" + e.getDomainName();
        }
        return s;
    }

    public EndpointIdentifier[] decodeEndpointIdentifiers(String name) {
        String[] s = commaPattern.split(name, 0);
        EndpointIdentifier[] endpointIdentifiers = new EndpointIdentifier[s.length];
        for (int i = 0; i < s.length; ++i) {
            endpointIdentifiers[i] = this.decodeEndpointIdentifier(s[i]);
        }
        return endpointIdentifiers;
    }

    public String encodeEndpointIdentifiers(EndpointIdentifier[] endpointIdentifierList) {
        StringBuffer msg = new StringBuffer("");
        boolean first = true;
        for (int i = 0; i < endpointIdentifierList.length; ++i) {
            if (first) {
                first = false;
            } else {
                msg.append(",");
            }
            msg.append(this.encodeEndpointIdentifier(endpointIdentifierList[i]));
        }
        return msg.toString();
    }

    public ReturnCode decodeReturnCode(int code) throws ParseException {
        switch (code) {
            case 530: {
                return ReturnCode.CAS_Signaling_Protocol_Error;
            }
            case 250: {
                return ReturnCode.Connection_Was_Deleted;
            }
            case 519: {
                return ReturnCode.Endpoint_Has_No_Digit_Map;
            }
            case 502: {
                return ReturnCode.Endpoint_Insufficient_Resources;
            }
            case 520: {
                return ReturnCode.Endpoint_Is_Restarting;
            }
            case 501: {
                return ReturnCode.Endpoint_Not_Ready;
            }
            case 521: {
                return ReturnCode.Endpoint_Redirected;
            }
            case 500: {
                return ReturnCode.Endpoint_Unknown;
            }
            case 512: {
                return ReturnCode.Gateway_Cannot_Detect_Requested_Event;
            }
            case 513: {
                return ReturnCode.Gateway_Cannot_Generate_Requested_Signal;
            }
            case 514: {
                return ReturnCode.Gateway_Cannot_Send_Specified_Announcement;
            }
            case 528: {
                return ReturnCode.Incompatible_Protocol_Version;
            }
            case 515: {
                return ReturnCode.Incorrect_Connection_ID;
            }
            case 526: {
                return ReturnCode.Insufficient_Bandwidth;
            }
            case 404: {
                return ReturnCode.Insufficient_Bandwidth_Now;
            }
            case 403: {
                return ReturnCode.Insufficient_Resources_Now;
            }
            case 529: {
                return ReturnCode.Internal_Hardware_Failure;
            }
            case 524: {
                return ReturnCode.Internal_Inconsistency_In_LocalConnectionOptions;
            }
            case 527: {
                return ReturnCode.Missing_RemoteConnectionDescriptor;
            }
            case 522: {
                return ReturnCode.No_Such_Event_Or_Signal;
            }
            case 401: {
                return ReturnCode.Phone_Off_Hook;
            }
            case 402: {
                return ReturnCode.Phone_On_Hook;
            }
            case 510: {
                return ReturnCode.Protocol_Error;
            }
            case 100: {
                return ReturnCode.Transaction_Being_Executed;
            }
            case 200: {
                return ReturnCode.Transaction_Executed_Normally;
            }
            case 400: {
                return ReturnCode.Transient_Error;
            }
            case 531: {
                return ReturnCode.Trunk_Group_Failure;
            }
            case 516: {
                return ReturnCode.Unknown_Call_ID;
            }
            case 525: {
                return ReturnCode.Unknown_Extension_In_LocalConnectionOptions;
            }
            case 523: {
                return ReturnCode.Unknown_Or_Illegal_Combination_Of_Actions;
            }
            case 511: {
                return ReturnCode.Unrecognized_Extension;
            }
            case 517: {
                return ReturnCode.Unsupported_Or_Invalid_Mode;
            }
            case 518: {
                return ReturnCode.Unsupported_Or_Unknown_Package;
            }
        }
        if (code > 99 && code < 200) {
            return ReturnCode.Transaction_Being_Executed;
        }
        if (code > 199 && code < 300) {
            return ReturnCode.Transaction_Executed_Normally;
        }
        if (code > 299 && code < 400) {
            return ReturnCode.Endpoint_Redirected;
        }
        if (code > 399 && code < 500) {
            return ReturnCode.Transient_Error;
        }
        if (code > 499 && code < 1000) {
            return ReturnCode.Protocol_Error;
        }
        throw new ParseException("unknown response code: " + code, 0);
    }

    public String encodeLocalOptionValueList(LocalOptionValue[] options) {
        StringBuffer msg = new StringBuffer("");
        boolean first = true;
        for (int i = 0; i < options.length; ++i) {
            if (first) {
                first = false;
            } else {
                msg.append(",");
            }
            String s = options[i].toString();
            if (s.indexOf("\n") != -1) {
                s = s.substring(0, s.indexOf("\n"));
            }
            msg.append(s);
        }
        return msg.toString();
    }

    public String encodeNotificationRequestParms(NotificationRequestParms parms) {
        StringBuffer msg = new StringBuffer("X:").append(parms.getRequestIdentifier()).append("\n");
        if (parms.getSignalRequests() != null) {
            msg.append("S:").append(this.encodeEventNames(parms.getSignalRequests())).append("\n");
        }
        if (parms.getRequestedEvents() != null) {
            msg.append("R:").append(this.encodeRequestedEvents(parms.getRequestedEvents())).append("\n");
        }
        if (parms.getDetectEvents() != null) {
            msg.append("T:").append(this.encodeEventNames(parms.getDetectEvents())).append("\n");
        }
        if (parms.getDigitMap() != null) {
            msg.append("D:").append(parms.getDigitMap()).append("\n");
        }
        return msg.toString();
    }

    public String encodeRequestedEvent(RequestedEvent evt) {
        StringBuffer s = new StringBuffer(evt.getEventName().getPackageName().toString()).append("/").append(evt.getEventName().getEventIdentifier().getName());
        if (evt.getEventName().getConnectionIdentifier() != null) {
            s.append('@').append(evt.getEventName().getConnectionIdentifier().toString());
        }
        String parms = evt.getEventName().getEventIdentifier().getParms();
        RequestedAction[] actions = evt.getRequestedActions();
        if (actions != null) {
            String ac = this.encodeRequestedActions(actions);
            s.append(" (").append(ac).append(")");
        }
        if (parms != null) {
            s.append(" (").append(parms).append(")");
        }
        return s.toString();
    }

    public String encodeRequestedEvents(RequestedEvent[] evts) {
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < evts.length; ++i) {
            s.append(this.encodeRequestedEvent(evts[i]));
            if (i == evts.length - 1) continue;
            s.append(',');
        }
        return s.toString();
    }

    public String encodeRequestedActions(RequestedAction[] actions) {
        StringBuffer s = new StringBuffer("");
        String d = "";
        for (int i = 0; i < actions.length; ++i) {
            d = i == 0 ? "" : ",";
            s.append(d).append(this.encodeRequestedAction(actions[i]));
        }
        return s.toString();
    }

    public String encodeRequestedAction(RequestedAction action) {
        StringBuffer s = new StringBuffer("");
        if (7 != action.getRequestedAction()) {
            return action.toString();
        }
        EmbeddedRequest embeddedRequest = action.getEmbeddedRequest();
        s.append("E(").append(this.encodeEmbeddedRequest(embeddedRequest)).append(")");
        return s.toString();
    }

    public String encodeConnectionParm(ConnectionParm parm) {
        int type = parm.getConnectionParmType();
        if (type == RegularConnectionParm.JITTER) {
            return "JI=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.LATENCY) {
            return "LA=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.OCTETS_RECEIVED) {
            return "OR=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.OCTETS_SENT) {
            return "OS=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_LOST) {
            return "PL=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_RECEIVED) {
            return "PR=" + parm.getConnectionParmValue();
        }
        if (type == RegularConnectionParm.PACKETS_SENT) {
            return "PS=" + parm.getConnectionParmValue();
        }
        return ((ExtendedConnectionParm)parm).getConnectionParmExtensionName() + "=" + parm.getConnectionParmValue();
    }

    public ConnectionParm decodeConnectionParm(String parm) {
        String[] tokens = equalsPattern.split(parm, 0);
        String name = tokens[0].trim();
        String value = tokens[1].trim();
        if (name.equalsIgnoreCase("JI")) {
            return new RegularConnectionParm(RegularConnectionParm.JITTER, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("LA")) {
            return new RegularConnectionParm(RegularConnectionParm.LATENCY, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("OR")) {
            return new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("OS")) {
            return new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PL")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_LOST, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PR")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_RECEIVED, Integer.parseInt(value));
        }
        if (name.equalsIgnoreCase("PS")) {
            return new RegularConnectionParm(RegularConnectionParm.PACKETS_SENT, Integer.parseInt(value));
        }
        return new ExtendedConnectionParm(name, Integer.parseInt(value));
    }

    public String encodeConnectionParms(ConnectionParm[] parms) {
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i < parms.length - 1; ++i) {
            s.append(this.encodeConnectionParm(parms[i])).append(",");
        }
        s.append(this.encodeConnectionParm(parms[parms.length - 1]));
        return s.toString();
    }

    public ConnectionParm[] decodeConnectionParms(String value) {
        String[] tokens = commaPattern.split(value, 0);
        ConnectionParm[] parms = new ConnectionParm[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parms[i] = this.decodeConnectionParm(tokens[i].trim());
        }
        return parms;
    }

    public ReasonCode decodeReasonCode(String value) {
        String[] tokens = this.splitStringBySpace(value);
        int code = Integer.parseInt(tokens[0]);
        ReasonCode reasonCode = null;
        switch (code) {
            case 900: {
                reasonCode = ReasonCode.Endpoint_Malfunctioning;
                break;
            }
            case 901: {
                reasonCode = ReasonCode.Endpoint_Out_Of_Service;
                break;
            }
            case 0: {
                reasonCode = ReasonCode.Endpoint_State_Is_Nominal;
                break;
            }
            case 902: {
                reasonCode = ReasonCode.Loss_Of_Lower_Layer_Connectivity;
            }
        }
        return reasonCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifiedEntity decodeNotifiedEntity(String value, boolean toMGW) throws ParseException {
        NotifiedEntity notifiedEntity = null;
        String localName = null;
        String domainName = null;
        int port = 0;
        String[] domainAndPort = null;
        try {
            String[] tokens = null;
            try {
                this.split('@', value, this.list);
                tokens = new String[this.list.size()];
                this.list.toArray(tokens);
            }
            finally {
                this.list.clear();
            }
            if (tokens.length != 2) {
                domainAndPort = colonPattern.split(tokens[0], 0);
                domainName = domainAndPort[0];
                return new NotifiedEntity(domainName);
            }
            localName = tokens[0];
            domainAndPort = colonPattern.split(tokens[1], 0);
            domainName = domainAndPort[0];
            port = domainAndPort.length == 2 ? Integer.parseInt(domainAndPort[1]) : (toMGW ? 2427 : 2727);
            notifiedEntity = new NotifiedEntity(localName, domainName, port);
        }
        catch (Exception ex) {
            throw new ParseException("unable to parse the " + value + " Message = " + ex.getMessage(), 0);
        }
        return notifiedEntity;
    }

    public String encodeNotifiedEntity(NotifiedEntity n) {
        StringBuffer s = new StringBuffer("");
        if (n.getLocalName() != null) {
            s.append(n.getLocalName()).append("@");
        }
        if (n.getDomainName() != null) {
            s.append(n.getDomainName());
        }
        if (n.getPortNumber() > 0) {
            s.append(":").append(n.getPortNumber());
        }
        return s.toString();
    }

    public static void main(String[] args) {
        Utils u = new Utils();
        String text = "blllablaa@whatever.com";
        EndpointIdentifier edId = null;
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            edId = u.decodeEndpointIdentifier(text);
        }
        long opeTime = System.currentTimeMillis() - currentTime;
        System.out.println("took " + opeTime);
    }
}

