/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditEndpoint;
import jain.protocol.ip.mgcp.message.AuditEndpointResponse;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.CapabilityValue;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReasonCode;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.RestartMethod;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.MgcpContentHandler;
import org.mobicents.protocols.mgcp.parser.MgcpMessageParser;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;

public class AuditEndpointHandler
extends TransactionHandler {
    private static final Logger logger = Logger.getLogger(AuditEndpointHandler.class);
    private AuditEndpoint command;
    private AuditEndpointResponse response;

    public AuditEndpointHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public AuditEndpointHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of AUEP Response failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Utils utils = this.utilsFactory.allocate();
        AuditEndpoint evt = (AuditEndpoint)event;
        StringBuffer s = new StringBuffer();
        s.append("AUEP ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" MGCP 1.0").append("\n");
        InfoCode[] requestedInfos = evt.getRequestedInfo();
        if (requestedInfos != null) {
            s.append("F: ").append(utils.encodeInfoCodeList(requestedInfos));
        }
        this.utilsFactory.deallocate(utils);
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        EndpointIdentifier[] z;
        EventName[] es;
        EventName[] t;
        EventName[] o;
        EventName[] sEvet;
        RequestedEvent[] r;
        ConnectionIdentifier[] connectionIdentifiers;
        Utils utils = this.utilsFactory.allocate();
        AuditEndpointResponse response = (AuditEndpointResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        if (response.getCapabilities() != null) {
            s.append("A: ").append(utils.encodeCapabilityList(response.getCapabilities())).append("\n");
        }
        if (response.getBearerInformation() != null) {
            s.append("B: ").append(utils.encodeBearerInformation(response.getBearerInformation())).append("\n");
        }
        if ((connectionIdentifiers = response.getConnectionIdentifiers()) != null) {
            s.append("I: ");
            boolean first = true;
            for (int i = 0; i < connectionIdentifiers.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    s.append(",");
                }
                s.append(connectionIdentifiers[i].toString());
            }
            s.append("\n");
        }
        if (response.getNotifiedEntity() != null) {
            s.append("N: ").append(utils.encodeNotifiedEntity(response.getNotifiedEntity())).append("\n");
        }
        if (response.getRequestIdentifier() != null) {
            s.append("X: ").append(response.getRequestIdentifier()).append("\n");
        }
        if ((r = response.getRequestedEvents()) != null) {
            s.append("R: ").append(utils.encodeRequestedEvents(r)).append("\n");
        }
        if ((sEvet = response.getSignalRequests()) != null) {
            s.append("S: ").append(utils.encodeEventNames(sEvet)).append("\n");
        }
        if (response.getDigitMap() != null) {
            s.append("D: ").append(response.getDigitMap()).append("\n");
        }
        if ((o = response.getObservedEvents()) != null) {
            s.append("O: ").append(utils.encodeEventNames(o)).append("\n");
        }
        if (response.getReasonCode() != null) {
            s.append("E: ").append(response.getReasonCode()).append("\n");
        }
        if ((t = response.getDetectEvents()) != null) {
            s.append("T: ").append(utils.encodeEventNames(t)).append("\n");
        }
        if ((es = response.getEventStates()) != null) {
            s.append("ES: ").append(utils.encodeEventNames(es)).append("\n");
        }
        if (response.getRestartMethod() != null) {
            s.append("RM: ").append(response.getRestartMethod()).append("\n");
        }
        if (response.getRestartDelay() > 0) {
            s.append("RD: ").append(response.getRestartDelay()).append("\n");
        }
        if ((z = response.getEndpointIdentifierList()) != null) {
            s.append("Z: ").append(utils.encodeEndpointIdentifiers(z)).append("\n");
        }
        this.utilsFactory.deallocate(utils);
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        AuditEndpointResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new AuditEndpointResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        Utils utils = null;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            AuditEndpointHandler.this.response = new AuditEndpointResponse(AuditEndpointHandler.this.source != null ? AuditEndpointHandler.this.source : AuditEndpointHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            AuditEndpointHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            RequestedEvent[] r;
            if (name.equals("Z")) {
                EndpointIdentifier[] endpointIdentifierList = this.utils.decodeEndpointIdentifiers(value);
                AuditEndpointHandler.this.response.setEndpointIdentifierList(endpointIdentifierList);
            }
            if (name.equalsIgnoreCase("B")) {
                BearerInformation b = this.utils.decodeBearerInformation(value);
                AuditEndpointHandler.this.response.setBearerInformation(b);
            } else if (name.equalsIgnoreCase("I")) {
                ConnectionIdentifier[] is = AuditEndpointHandler.this.response.getConnectionIdentifiers();
                if (is == null) {
                    ConnectionIdentifier i = new ConnectionIdentifier(value);
                    AuditEndpointHandler.this.response.setConnectionIdentifiers(new ConnectionIdentifier[]{i});
                } else {
                    ArrayList<ConnectionIdentifier> arrayList = new ArrayList<ConnectionIdentifier>();
                    Collections.addAll(arrayList, is);
                    arrayList.add(new ConnectionIdentifier(value));
                    ConnectionIdentifier[] temp = new ConnectionIdentifier[arrayList.size()];
                    AuditEndpointHandler.this.response.setConnectionIdentifiers(arrayList.toArray(temp));
                }
            } else if (name.equalsIgnoreCase("N")) {
                NotifiedEntity n = this.utils.decodeNotifiedEntity(value, true);
                AuditEndpointHandler.this.response.setNotifiedEntity(n);
            } else if (name.equalsIgnoreCase("X")) {
                r = new RequestIdentifier(value);
                AuditEndpointHandler.this.response.setRequestIdentifier((RequestIdentifier)r);
            } else if (name.equalsIgnoreCase("R")) {
                r = this.utils.decodeRequestedEventList(value);
                AuditEndpointHandler.this.response.setRequestedEvents(r);
            } else if (name.equalsIgnoreCase("S")) {
                EventName[] s = this.utils.decodeEventNames(value);
                AuditEndpointHandler.this.response.setSignalRequests(s);
            } else if (name.equalsIgnoreCase("D")) {
                DigitMap d = new DigitMap(value);
                AuditEndpointHandler.this.response.setDigitMap(d);
            } else if (name.equalsIgnoreCase("O")) {
                EventName[] o = this.utils.decodeEventNames(value);
                AuditEndpointHandler.this.response.setObservedEvents(o);
            } else if (name.equalsIgnoreCase("E")) {
                ReasonCode e = this.utils.decodeReasonCode(value);
                AuditEndpointHandler.this.response.setReasonCode(e);
            } else if (!name.equalsIgnoreCase("Q")) {
                if (name.equalsIgnoreCase("T")) {
                    EventName[] t = this.utils.decodeEventNames(value);
                    AuditEndpointHandler.this.response.setDetectEvents(t);
                } else if (name.equalsIgnoreCase("A")) {
                    CapabilityValue[] capabilities = AuditEndpointHandler.this.response.getCapabilities();
                    if (capabilities == null) {
                        AuditEndpointHandler.this.response.setCapabilities(this.utils.decodeCapabilityList(value));
                    } else {
                        CapabilityValue[] newCapability = this.utils.decodeCapabilityList(value);
                        int size = capabilities.length + newCapability.length;
                        CapabilityValue[] temp = new CapabilityValue[size];
                        int count = 0;
                        for (int i = 0; i < capabilities.length; ++i) {
                            temp[count] = capabilities[i];
                            ++count;
                        }
                        for (int j = 0; j < newCapability.length; ++j) {
                            temp[count] = newCapability[j];
                            ++count;
                        }
                        AuditEndpointHandler.this.response.setCapabilities(temp);
                    }
                } else if (name.equalsIgnoreCase("ES")) {
                    EventName[] es = this.utils.decodeEventNames(value);
                    AuditEndpointHandler.this.response.setEventStates(es);
                } else if (name.equalsIgnoreCase("RM")) {
                    RestartMethod rm = this.utils.decodeRestartMethod(value);
                    AuditEndpointHandler.this.response.setRestartMethod(rm);
                } else if (name.equalsIgnoreCase("RD")) {
                    int restartDelay = 0;
                    try {
                        restartDelay = Integer.parseInt(value);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error((Object)("RD throws error " + value), (Throwable)nfe);
                    }
                    AuditEndpointHandler.this.response.setRestartDelay(restartDelay);
                }
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            AuditEndpointHandler.this.command = new AuditEndpoint(AuditEndpointHandler.this.source != null ? AuditEndpointHandler.this.source : AuditEndpointHandler.this.stack, AuditEndpointHandler.this.endpoint);
            AuditEndpointHandler.this.command.setTransactionHandle(AuditEndpointHandler.this.remoteTID);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("F")) {
                AuditEndpointHandler.this.command.setRequestedInfo(this.utils.decodeInfoCodeList(value));
            } else {
                logger.error((Object)("Unknown code " + name));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new ParseException("SessionDescription shouldn't have been included in AUEP command", 0);
        }
    }
}

