/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.Utils;
import org.mobicents.protocols.mgcp.stack.AuditConnectionHandler;
import org.mobicents.protocols.mgcp.stack.AuditEndpointHandler;
import org.mobicents.protocols.mgcp.stack.CreateConnectionHandler;
import org.mobicents.protocols.mgcp.stack.DeleteConnectionHandler;
import org.mobicents.protocols.mgcp.stack.EndpointConfigurationHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.ModifyConnectionHandler;
import org.mobicents.protocols.mgcp.stack.NotificationRequestHandler;
import org.mobicents.protocols.mgcp.stack.NotifyHandler;
import org.mobicents.protocols.mgcp.stack.RestartInProgressHandler;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;

public class MessageHandler {
    private JainMgcpStackImpl stack;
    private static Logger logger = Logger.getLogger(MessageHandler.class);
    private Utils utils = null;
    private static ArrayList<String> mList = new ArrayList();

    public MessageHandler(JainMgcpStackImpl jainMgcpStackImpl) {
        this.stack = jainMgcpStackImpl;
        this.utils = jainMgcpStackImpl.getUtilsFactory().allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] piggyDismount(byte[] msgBuffer, int length) {
        try {
            int msgStart = 0;
            int msgLength = 0;
            String currentLine = null;
            for (int i = 0; i < length - 1; ++i) {
                if (msgBuffer[i] != 10 && msgBuffer[i] != 13 || msgBuffer[i + 1] != 46) continue;
                msgLength = i - msgStart;
                try {
                    currentLine = new String(msgBuffer, msgStart, msgLength + 1, "UTF-8");
                    mList.add(currentLine);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)e);
                }
                msgStart = i += 3;
            }
            try {
                msgLength = length - msgStart;
                currentLine = new String(msgBuffer, msgStart, msgLength, "UTF-8");
                mList.add(currentLine);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
            }
            String[] result = new String[mList.size()];
            String[] stringArray = mList.toArray(result);
            return stringArray;
        }
        finally {
            mList.clear();
        }
    }

    public boolean isRequest(String header) {
        char ch = (header = header.trim()).charAt(0);
        return !Character.isDigit(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleMessages(PacketRepresentation pr) {
        try {
            InetAddress address = pr.getRemoteAddress();
            int port = pr.getRemotePort();
            for (String msg : MessageHandler.piggyDismount(pr.getRawData(), pr.getLength())) {
                int pos = msg.indexOf("\n");
                String header = msg.substring(0, pos).trim();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Message header: " + header));
                }
                String[] tokens = this.utils.splitStringBySpace(header);
                if (this.isRequest(header)) {
                    TransactionHandler handler;
                    String verb = tokens[0];
                    String remoteTxIdString = tokens[1];
                    EndpointIdentifier endpoint = this.utils.decodeEndpointIdentifier(tokens[2].trim());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Processing command message = " + verb + " remote Tx = " + remoteTxIdString));
                    }
                    Integer remoteTxIdIntegere = new Integer(remoteTxIdString);
                    TransactionHandler completedTxHandler = this.stack.getCompletedTransactions().get(remoteTxIdIntegere);
                    if (completedTxHandler != null) {
                        completedTxHandler.markRetransmision();
                        completedTxHandler.run();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Received Command for which stack has already sent response Tx = " + verb + " " + remoteTxIdIntegere));
                        }
                        return;
                    }
                    Integer tmpLoaclTID = this.stack.getRemoteTxToLocalTxMap().get(remoteTxIdIntegere);
                    if (tmpLoaclTID != null) {
                        TransactionHandler ongoingTxHandler = this.stack.getLocalTransactions().get(tmpLoaclTID);
                        ongoingTxHandler.sendProvisionalResponse();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Received Command for ongoing Tx = " + remoteTxIdIntegere));
                        }
                        return;
                    }
                    if (verb.equalsIgnoreCase("crcx")) {
                        handler = new CreateConnectionHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("mdcx")) {
                        handler = new ModifyConnectionHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("dlcx")) {
                        handler = new DeleteConnectionHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("epcf")) {
                        handler = new EndpointConfigurationHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("rqnt")) {
                        handler = new NotificationRequestHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("ntfy")) {
                        handler = new NotifyHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("rsip")) {
                        handler = new RestartInProgressHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("auep")) {
                        handler = new AuditEndpointHandler(this.stack, address, port);
                    } else if (verb.equalsIgnoreCase("aucx")) {
                        handler = new AuditConnectionHandler(this.stack, address, port);
                    } else {
                        logger.warn((Object)("Unsupported message verbose " + verb));
                        return;
                    }
                    handler.receiveRequest(endpoint, msg, remoteTxIdIntegere);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Processing response message");
                }
                String tid = tokens[1];
                TransactionHandler handler = this.stack.getLocalTransactions().get(Integer.valueOf(tid));
                if (handler == null) {
                    logger.warn((Object)("---  Address:" + address + "\nPort:" + port + "\nID:" + this.hashCode() + "\n Unknown transaction: " + tid));
                    return;
                }
                handler.receiveResponse(msg);
            }
        }
        finally {
            pr.release();
        }
    }
}

