/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.BearerInformationHandler;
import org.mobicents.protocols.mgcp.parser.params.ConnectionModeHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.EventNameHandler;
import org.mobicents.protocols.mgcp.parser.params.LocalOptionValueHandler;
import org.mobicents.protocols.mgcp.parser.params.NotificationRequestParamHandler;
import org.mobicents.protocols.mgcp.parser.params.NotifiedEntityHandler;
import org.mobicents.protocols.mgcp.parser.params.RequestedEventHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class ModifyConnectionHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{77, 68, 67, 88};
    private ModifyConnection command = null;
    private ModifyConnectionResponse response = null;
    private static final Logger logger = Logger.getLogger(ModifyConnectionHandler.class);

    public ModifyConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public ModifyConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new ModifyConnection(this.source != null ? this.source : this.stack, new CallIdentifier("00"), this.endpoint, new ConnectionIdentifier("00"));
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of MDCX command failed", (Throwable)e);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new ModifyConnectionResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Decoding of MDCX Response failed", (Throwable)e);
        }
        return this.response;
    }

    public int encode(JainMgcpCommandEvent event, byte[] array) {
        ModifyConnection evt = (ModifyConnection)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        array[totalLength++] = 67;
        array[totalLength++] = 58;
        byte[] callBytes = evt.getCallIdentifier().toString().getBytes();
        System.arraycopy(callBytes, 0, array, totalLength, callBytes.length);
        totalLength += callBytes.length;
        array[totalLength++] = 10;
        array[totalLength++] = 73;
        array[totalLength++] = 58;
        byte[] connectionIdentifierBytes = evt.getConnectionIdentifier().toString().getBytes();
        System.arraycopy(connectionIdentifierBytes, 0, array, totalLength, connectionIdentifierBytes.length);
        totalLength += connectionIdentifierBytes.length;
        array[totalLength++] = 10;
        if (evt.getBearerInformation() != null) {
            array[totalLength++] = 66;
            array[totalLength++] = 58;
            totalLength += BearerInformationHandler.encode(array, totalLength, evt.getBearerInformation());
            array[totalLength++] = 10;
        }
        if (evt.getLocalConnectionOptions() != null) {
            array[totalLength++] = 76;
            array[totalLength++] = 58;
            totalLength += LocalOptionValueHandler.encodeList(array, totalLength, evt.getLocalConnectionOptions());
            array[totalLength++] = 10;
        }
        if (evt.getMode() != null) {
            array[totalLength++] = 77;
            array[totalLength++] = 58;
            totalLength += ConnectionModeHandler.encode(array, totalLength, evt.getMode());
            array[totalLength++] = 10;
        }
        if (evt.getNotificationRequestParms() != null) {
            array[totalLength++] = 76;
            array[totalLength++] = 58;
            totalLength += NotificationRequestParamHandler.encode(array, totalLength, evt.getNotificationRequestParms());
            array[totalLength++] = 10;
        }
        if (evt.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, evt.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            byte[] rcdBytes = evt.getRemoteConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    public int encode(JainMgcpResponseEvent event, byte[] array) {
        ModifyConnectionResponse response = (ModifyConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getLocalConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            byte[] rcdBytes = response.getLocalConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        ModifyConnectionResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new ModifyConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 66: 
                    case 98: {
                        ModifyConnectionHandler.this.command.setBearerInformation(BearerInformationHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 67: 
                    case 99: {
                        ModifyConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 73: 
                    case 105: {
                        ModifyConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 77: 
                    case 109: {
                        ModifyConnectionHandler.this.command.setMode(ConnectionModeHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 76: 
                    case 108: {
                        ModifyConnectionHandler.this.command.setLocalConnectionOptions(LocalOptionValueHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 78: 
                    case 110: {
                        ModifyConnectionHandler.this.command.setNotifiedEntity(NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true));
                        break;
                    }
                    case 88: 
                    case 120: {
                        ModifyConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(new String(data, value.getOffset(), value.getLength()))));
                        break;
                    }
                    case 82: 
                    case 114: {
                        ModifyConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(RequestedEventHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 83: 
                    case 115: {
                        ModifyConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 84: 
                    case 116: {
                        ModifyConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified MDCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified MDCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            ModifyConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }
}

