/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.EventNameHandler;
import org.mobicents.protocols.mgcp.parser.params.NotifiedEntityHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class NotifyHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{78, 84, 70, 89};
    private Notify command;
    private NotifyResponse response;
    private static final Logger logger = Logger.getLogger(NotifyHandler.class);

    public NotifyHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotifyHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new Notify(this.source != null ? this.source : this.stack, this.endpoint, new RequestIdentifier("0"), new EventName[0]);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new NotifyResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Something wrong while parsing the NOTIFY Response received", (Throwable)e);
        }
        return this.response;
    }

    public int encode(JainMgcpCommandEvent event, byte[] array) {
        Notify evt = (Notify)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        if (evt.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, evt.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        array[totalLength++] = 88;
        array[totalLength++] = 58;
        byte[] requestBytes = evt.getRequestIdentifier().toString().getBytes();
        System.arraycopy(requestBytes, 0, array, totalLength, requestBytes.length);
        totalLength += requestBytes.length;
        array[totalLength++] = 10;
        array[totalLength++] = 79;
        array[totalLength++] = 58;
        totalLength += EventNameHandler.encodeList(array, totalLength, evt.getObservedEvents());
        array[totalLength++] = 10;
        return totalLength;
    }

    public int encode(JainMgcpResponseEvent event, byte[] array) {
        NotifyResponse response = (NotifyResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        return totalLength;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        NotifyResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new NotifyResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        public void header(String header) throws ParseException {
        }

        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 78: 
                    case 110: {
                        NotifyHandler.this.command.setNotifiedEntity(NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), false));
                        break;
                    }
                    case 88: 
                    case 120: {
                        NotifyHandler.this.command.setRequestIdentifier(new RequestIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 79: 
                    case 111: {
                        NotifyHandler.this.command.setObservedEvents(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified NTFY Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified NTFY Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

