/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.ExtendedConnectionParm;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import java.text.ParseException;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;

public class ConnectionParmHandler {
    public static final int PACKETS_SENT = 1;
    public static final int OCTETS_SENT = 2;
    public static final int PACKETS_RECEIVED = 3;
    public static final int OCTETS_RECEIVED = 4;
    public static final int PACKETS_LOST = 5;
    public static final int JITTER = 6;
    public static final int LATENCY = 7;
    public static final int EXTENSION = 8;

    public static ConnectionParm decode(byte[] value, int offset, int length) throws ParseException {
        int startIndex = offset;
        int newLength = length;
        for (int i = 0; i < length; ++i) {
            if (value[offset + i] != 32) continue;
            ++startIndex;
            --newLength;
        }
        int finalLength = newLength;
        for (int i = 0; i < newLength; ++i) {
            if (value[offset + length - i - 1] != 32) continue;
            --finalLength;
        }
        int spaceStart = startIndex;
        int numberStart = startIndex;
        for (int i = 0; i < finalLength; ++i) {
            if (value[startIndex + i] == 61) {
                numberStart = startIndex + i + 1;
                finalLength = finalLength - i - 1;
                break;
            }
            if (value[startIndex + i] == 32) continue;
            spaceStart = startIndex + i + 1;
        }
        if (numberStart == startIndex) {
            throw new ParseException("Could not parse connection param: " + new String(value, offset, length), 0);
        }
        if (spaceStart - startIndex != 2) {
            throw new ParseException("Could not parse connection param: " + new String(value, offset, length), 0);
        }
        int numericValue = 0;
        int i = 0;
        while (i < finalLength) {
            if (value[numberStart] >= 48 && value[numberStart] <= 57) {
                numericValue = numericValue * 10 + (value[numberStart] - 48);
            } else if (numericValue > 0 || value[numberStart] != 32) {
                throw new ParseException("Could not parse connection param: " + new String(value, offset, length), 0);
            }
            ++i;
            ++numberStart;
        }
        switch (value[startIndex]) {
            case 76: 
            case 108: {
                if (value[startIndex + 1] == 97 || value[startIndex + 1] == 65) {
                    return new RegularConnectionParm(RegularConnectionParm.LATENCY, numericValue);
                }
            }
            case 74: 
            case 106: {
                if (value[startIndex + 1] == 105 || value[startIndex + 1] == 73) {
                    return new RegularConnectionParm(RegularConnectionParm.JITTER, numericValue);
                }
            }
            case 79: 
            case 111: {
                switch (value[startIndex + 1]) {
                    case 82: 
                    case 114: {
                        return new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, numericValue);
                    }
                    case 83: 
                    case 115: {
                        return new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, numericValue);
                    }
                }
            }
            case 80: 
            case 112: {
                switch (value[startIndex + 1]) {
                    case 76: 
                    case 108: {
                        return new RegularConnectionParm(RegularConnectionParm.PACKETS_LOST, numericValue);
                    }
                    case 82: 
                    case 114: {
                        return new RegularConnectionParm(RegularConnectionParm.PACKETS_RECEIVED, numericValue);
                    }
                    case 83: 
                    case 115: {
                        return new RegularConnectionParm(RegularConnectionParm.PACKETS_SENT, numericValue);
                    }
                }
            }
        }
        return new ExtendedConnectionParm(new String(value, startIndex, 2), numericValue);
    }

    public static int encode(byte[] destination, int offset, ConnectionParm connectionParm) {
        switch (connectionParm.getConnectionParmType()) {
            case 6: {
                destination[offset] = 74;
                destination[offset + 1] = 73;
                break;
            }
            case 7: {
                destination[offset] = 76;
                destination[offset + 1] = 65;
                break;
            }
            case 4: {
                destination[offset] = 79;
                destination[offset + 1] = 82;
                break;
            }
            case 2: {
                destination[offset] = 79;
                destination[offset + 1] = 83;
                break;
            }
            case 5: {
                destination[offset] = 80;
                destination[offset + 1] = 76;
                break;
            }
            case 3: {
                destination[offset] = 80;
                destination[offset + 1] = 82;
                break;
            }
            case 1: {
                destination[offset] = 80;
                destination[offset + 1] = 83;
                break;
            }
            case 8: {
                byte[] nameBytes = ((ExtendedConnectionParm)connectionParm).getConnectionParmExtensionName().getBytes();
                System.arraycopy(nameBytes, 0, destination, offset, 2);
                break;
            }
            default: {
                return 0;
            }
        }
        destination[offset + 2] = 61;
        return StringFunctions.encodeInt(destination, offset + 3, connectionParm.getConnectionParmValue()) + 3;
    }

    public static int encodeList(byte[] destination, int offset, ConnectionParm[] connectionParms) {
        int i;
        if (connectionParms.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < connectionParms.length - 1; ++i) {
            totalLength += ConnectionParmHandler.encode(destination, offset + totalLength, connectionParms[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += ConnectionParmHandler.encode(destination, offset + totalLength, connectionParms[i]);
        return totalLength;
    }

    public static ConnectionParm[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        ConnectionParm[] connectionParms = new ConnectionParm[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            connectionParms[i] = ConnectionParmHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return connectionParms;
    }
}

