/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.handlers;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.ReceivedTransactionID;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;

public abstract class TransactionHandler {
    private static final Logger logger = Logger.getLogger(TransactionHandler.class);
    private static long MAX_TRANSACTION_HANDLE_ID = 999999999L;
    private static AtomicInteger GENERATOR = new AtomicInteger(1);
    public static final String NEW_LINE = "\n";
    public static final String SDP_NEW_LINE = "\r\n";
    public static final String SINGLE_CHAR_SPACE = " ";
    public static final byte[] MGCP_VERSION = new byte[]{77, 71, 67, 80, 32, 49, 46, 48};
    public static final int LONGTRAN_TIMER_TIMEOUT = 5000;
    public static final int THIST_TIMER_TIMEOUT = 30000;
    protected boolean sent;
    protected int remoteTID;
    private int localTID;
    protected JainMgcpStackImpl stack;
    private InetAddress remoteAddress;
    private int remotePort;
    protected JainMgcpCommandEvent commandEvent;
    protected JainMgcpResponseEvent responseEvent;
    protected static Timer transactionHandlerTimer = new Timer("TransactionHandlerTimer");
    private LongtranTimerTask longtranTimerTask;
    private boolean isCommand = false;
    private ReTransmissionTimerTask reTransmissionTimer;
    private THISTTimerTask tHISTTimerTask;
    private int A = 0;
    private int D = 2;
    private int N = 2;
    private int countOfCommandRetransmitted = 0;
    protected boolean retransmision;
    protected Object source = null;
    private String msgTemp = null;
    protected EndpointIdentifier endpoint = null;
    private PacketRepresentation originalPacket = null;

    public TransactionHandler(JainMgcpStackImpl stack) {
        this.stack = stack;
        this.localTID = (int)(((long)GENERATOR.incrementAndGet() - Integer.MIN_VALUE) % MAX_TRANSACTION_HANDLE_ID + 1L);
        stack.getLocalTransactions().put((Object)this.localTID, (Object)this);
    }

    public TransactionHandler(JainMgcpStackImpl stack, InetAddress remoteAddress, int port) {
        this(stack);
        this.remoteAddress = remoteAddress;
        this.remotePort = port;
        if (this.stack.provider.getNotifiedEntity() == null) {
            NotifiedEntity notifiedEntity = new NotifiedEntity(this.remoteAddress.getHostName(), this.remoteAddress.getHostAddress(), this.remotePort);
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
    }

    private void processTxTimeout() {
        try {
            this.release();
            this.commandEvent.setTransactionHandle(this.remoteTID);
            if (this.sent) {
                this.stack.provider.processTxTimeout(this.commandEvent);
            } else {
                this.stack.provider.processRxTimeout(this.commandEvent);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to release mgcp transaction localID=" + this.localTID), (Throwable)e);
        }
    }

    private boolean isProvisional(ReturnCode rc) {
        int rval = rc.getValue();
        return 99 < rval && rval < 200;
    }

    protected void release() {
        this.stack.getLocalTransactions().remove((Object)this.localTID);
        this.stack.getRemoteTxToLocalTxMap().remove((Object)this.remoteTID);
        this.cancelTHISTTimerTask();
        this.cancelLongtranTimer();
        this.cancelReTransmissionTimer();
        if (this.originalPacket != null) {
            this.stack.releasePacket(this.originalPacket);
        }
        this.originalPacket = null;
    }

    public int getRemoteTID() {
        return this.remoteTID;
    }

    public int getLocalTID() {
        return this.localTID;
    }

    public abstract int encode(JainMgcpCommandEvent var1, byte[] var2);

    public abstract int encode(JainMgcpResponseEvent var1, byte[] var2);

    public abstract JainMgcpCommandEvent decodeCommand(byte[] var1, SplitDetails[] var2) throws ParseException;

    public abstract JainMgcpResponseEvent decodeResponse(byte[] var1, SplitDetails[] var2, Integer var3, ReturnCode var4) throws ParseException;

    public abstract JainMgcpResponseEvent getProvisionalResponse();

    public void send() {
        if (this.isCommand) {
            this.send(this.getCommandEvent());
        } else {
            this.send(this.getResponseEvent());
        }
    }

    protected void sendProvisionalResponse() {
        this.send(this.getProvisionalResponse());
    }

    private void send(JainMgcpCommandEvent event) {
        this.sent = true;
        String host = "";
        int port = 0;
        switch (event.getObjectIdentifier()) {
            case 108: {
                Notify notifyCommand = (Notify)event;
                NotifiedEntity notifiedEntity = notifyCommand.getNotifiedEntity();
                if (notifiedEntity == null) {
                    notifiedEntity = this.stack.provider.getNotifiedEntity();
                }
                port = notifiedEntity.getPortNumber();
                host = host + notifiedEntity.getDomainName();
                break;
            }
            default: {
                String domainName = event.getEndpointIdentifier().getDomainName();
                int pos = domainName.indexOf(58);
                if (pos > 0) {
                    port = Integer.parseInt(domainName.substring(pos + 1));
                    host = domainName.substring(0, pos);
                    break;
                }
                port = 2427;
                host = domainName;
            }
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown endpoint " + host);
        }
        this.remoteTID = event.getTransactionHandle();
        this.source = event.getSource();
        event.setTransactionHandle(this.localTID);
        if (this.originalPacket == null) {
            this.originalPacket = this.stack.allocatePacket();
        }
        this.originalPacket.setLength(this.encode(event, this.originalPacket.getRawData()));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address, port);
        this.originalPacket.setRemoteAddress(inetSocketAddress);
        this.resetReTransmissionTimer();
        this.resetTHISTTimerTask(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send command event to " + address + "remote TX ID:" + this.remoteTID + ", message\n" + new String(this.originalPacket.getRawData(), 0, this.originalPacket.getLength())));
        }
        ++this.countOfCommandRetransmitted;
        this.stack.send(this.originalPacket);
    }

    private void send(JainMgcpResponseEvent event) {
        this.cancelLongtranTimer();
        if (this.remoteAddress == null) {
            throw new IllegalArgumentException("Unknown orinator address");
        }
        event.setTransactionHandle(this.remoteTID);
        if (this.originalPacket == null) {
            this.originalPacket = this.stack.allocatePacket();
        }
        this.originalPacket.setLength(this.encode(event, this.originalPacket.getRawData()));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.remoteAddress, this.remotePort);
        this.originalPacket.setRemoteAddress(inetSocketAddress);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--- TransactionHandler:" + this + " :LocalID=" + this.localTID + ", Send response event to " + this.remoteAddress + ":" + this.remotePort + ", message\n" + new String(this.originalPacket.getRawData(), 0, this.originalPacket.getLength())));
        }
        this.stack.send(this.originalPacket);
        if (this.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
        } else {
            this.release();
            this.stack.getCompletedTransactions().put((Object)event.getTransactionHandle(), (Object)this);
            this.resetTHISTTimerTask(true);
        }
    }

    private void cancelLongtranTimer() {
        if (this.longtranTimerTask != null) {
            this.longtranTimerTask.cancel();
            this.longtranTimerTask = null;
        }
    }

    private void resetLongtranTimer() {
        this.longtranTimerTask = new LongtranTimerTask();
        transactionHandlerTimer.schedule((TimerTask)this.longtranTimerTask, 5000L);
    }

    private void cancelReTransmissionTimer() {
        if (this.reTransmissionTimer != null) {
            this.reTransmissionTimer.cancel();
            this.reTransmissionTimer = null;
        }
    }

    private void resetReTransmissionTimer() {
        this.cancelReTransmissionTimer();
        this.reTransmissionTimer = new ReTransmissionTimerTask();
        transactionHandlerTimer.schedule((TimerTask)this.reTransmissionTimer, this.calculateReTransmissionTimeout());
    }

    private int calculateReTransmissionTimeout() {
        int reTransmissionTimeoutSec = this.A + this.N * this.D;
        this.N *= 2;
        return reTransmissionTimeoutSec * 1000;
    }

    private void cancelTHISTTimerTask() {
        if (this.tHISTTimerTask != null) {
            this.tHISTTimerTask.cancel();
            this.tHISTTimerTask = null;
        }
    }

    private void resetTHISTTimerTask(boolean responseSent) {
        this.cancelTHISTTimerTask();
        this.tHISTTimerTask = new THISTTimerTask(responseSent);
        transactionHandlerTimer.schedule((TimerTask)this.tHISTTimerTask, 30000L);
    }

    protected Object getObjectSource(int tid) {
        if (this.sent) {
            return this.stack;
        }
        return new ReceivedTransactionID(tid, this.remoteAddress, this.remotePort);
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public void setCommand(boolean isCommand) {
        this.isCommand = isCommand;
    }

    private JainMgcpCommandEvent getCommandEvent() {
        return this.commandEvent;
    }

    public void setCommandEvent(JainMgcpCommandEvent commandEvent) {
        this.commandEvent = commandEvent;
    }

    private JainMgcpResponseEvent getResponseEvent() {
        return this.responseEvent;
    }

    public void setResponseEvent(JainMgcpResponseEvent responseEvent) {
        this.responseEvent = responseEvent;
    }

    public void markRetransmision() {
        this.retransmision = true;
    }

    public void receiveRequest(EndpointIdentifier endpoint, byte[] data, SplitDetails[] msg, Integer remoteTID) {
        this.remoteTID = remoteTID;
        this.endpoint = endpoint;
        try {
            this.commandEvent = this.decodeCommand(data, msg);
        }
        catch (ParseException e) {
            logger.error((Object)"Coud not parse message: ", (Throwable)e);
            return;
        }
        this.sent = false;
        this.stack.getRemoteTxToLocalTxMap().put((Object)remoteTID, (Object)new Integer(this.localTID));
        this.commandEvent.setTransactionHandle(this.localTID);
        this.resetLongtranTimer();
        this.stack.provider.processMgcpCommandEvent(this.commandEvent);
    }

    public void receiveResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) {
        this.cancelReTransmissionTimer();
        this.cancelLongtranTimer();
        JainMgcpResponseEvent event = null;
        try {
            event = this.decodeResponse(data, msg, txID, returnCode);
        }
        catch (Exception e) {
            logger.error((Object)"Could not decode message: ", (Throwable)e);
        }
        event.setTransactionHandle(this.remoteTID);
        if (this.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
        }
        this.stack.provider.processMgcpResponseEvent(event, (JainMgcpEvent)this.commandEvent);
        if (!this.isProvisional(event.getReturnCode())) {
            this.release();
        }
    }

    public String getEndpointId() {
        return this.commandEvent.getEndpointIdentifier().toString();
    }

    private class THISTTimerTask
    extends TimerTask {
        boolean responseSent = false;

        THISTTimerTask(boolean responseSent) {
            this.responseSent = responseSent;
        }

        public void run() {
            if (!this.responseSent) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"T-HIST timeout processTxTimeout ");
                }
                try {
                    TransactionHandler.this.processTxTimeout();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to delete the jainMgcpResponseEvent for txId", (Throwable)e);
                }
            } else {
                TransactionHandler.this.stack.getCompletedTransactions().remove((Object)TransactionHandler.this.remoteTID);
            }
        }
    }

    private class ReTransmissionTimerTask
    extends TimerTask {
        private ReTransmissionTimerTask() {
        }

        public void run() {
            try {
                TransactionHandler.this.countOfCommandRetransmitted++;
                logger.warn((Object)("message = \n" + new String(TransactionHandler.this.originalPacket.getRawData(), 0, TransactionHandler.this.originalPacket.getLength()) + "\n local Tx ID = " + TransactionHandler.this.localTID + " Remote Tx ID = " + TransactionHandler.this.remoteTID + " Sending the Command " + TransactionHandler.this.countOfCommandRetransmitted));
                TransactionHandler.this.stack.send(TransactionHandler.this.originalPacket);
                TransactionHandler.this.resetReTransmissionTimer();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to release mgcp transaction localID=" + TransactionHandler.this.localTID), (Throwable)e);
            }
        }
    }

    private class LongtranTimerTask
    extends TimerTask {
        private LongtranTimerTask() {
        }

        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction localID=" + TransactionHandler.this.localTID + " timeout"));
            }
            TransactionHandler.this.processTxTimeout();
        }
    }
}

