/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.BearerInformationHandler;
import org.mobicents.protocols.mgcp.parser.params.ConnectionModeHandler;
import org.mobicents.protocols.mgcp.parser.params.DigitMapHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.EventNameHandler;
import org.mobicents.protocols.mgcp.parser.params.LocalOptionValueHandler;
import org.mobicents.protocols.mgcp.parser.params.NotificationRequestParamHandler;
import org.mobicents.protocols.mgcp.parser.params.NotifiedEntityHandler;
import org.mobicents.protocols.mgcp.parser.params.RequestedEventHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class CreateConnectionHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{67, 82, 67, 88};
    private static final Logger logger = Logger.getLogger(CreateConnectionHandler.class);
    private CreateConnection command;
    private CreateConnectionResponse response;

    public CreateConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public CreateConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new CreateConnection(this.source != null ? this.source : this.stack, new CallIdentifier("0"), this.endpoint, ConnectionMode.Inactive);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new CreateConnectionResponse(this.source != null ? this.source : this.stack, returnCode, new ConnectionIdentifier("00"));
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Decode of CRCX Response failed ", (Throwable)e);
        }
        return this.response;
    }

    public int encode(JainMgcpCommandEvent event, byte[] array) {
        CreateConnection evt = (CreateConnection)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        array[totalLength++] = 67;
        array[totalLength++] = 58;
        byte[] callBytes = evt.getCallIdentifier().toString().getBytes();
        System.arraycopy(callBytes, 0, array, totalLength, callBytes.length);
        totalLength += callBytes.length;
        array[totalLength++] = 10;
        array[totalLength++] = 77;
        array[totalLength++] = 58;
        totalLength += ConnectionModeHandler.encode(array, totalLength, evt.getMode());
        array[totalLength++] = 10;
        if (evt.getBearerInformation() != null) {
            array[totalLength++] = 66;
            array[totalLength++] = 58;
            totalLength += BearerInformationHandler.encode(array, totalLength, evt.getBearerInformation());
            array[totalLength++] = 10;
        }
        if (evt.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, evt.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        if (evt.getLocalConnectionOptions() != null) {
            array[totalLength++] = 76;
            array[totalLength++] = 58;
            totalLength += LocalOptionValueHandler.encodeList(array, totalLength, evt.getLocalConnectionOptions());
            array[totalLength++] = 10;
        }
        if (evt.getSecondEndpointIdentifier() != null) {
            array[totalLength++] = 90;
            array[totalLength++] = 50;
            array[totalLength++] = 58;
            totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getSecondEndpointIdentifier());
        }
        if (evt.getNotificationRequestParms() != null) {
            array[totalLength++] = 76;
            array[totalLength++] = 58;
            totalLength += NotificationRequestParamHandler.encode(array, totalLength, evt.getNotificationRequestParms());
            array[totalLength++] = 10;
        }
        if (evt.getRemoteConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            byte[] rcdBytes = evt.getRemoteConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    public int encode(JainMgcpResponseEvent event, byte[] array) {
        byte[] connectionIdentifierBytes;
        CreateConnectionResponse response = (CreateConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getConnectionIdentifier() != null) {
            array[totalLength++] = 73;
            array[totalLength++] = 58;
            connectionIdentifierBytes = response.getConnectionIdentifier().toString().getBytes();
            System.arraycopy(connectionIdentifierBytes, 0, array, totalLength, connectionIdentifierBytes.length);
            totalLength += connectionIdentifierBytes.length;
            array[totalLength++] = 10;
        }
        if (response.getSpecificEndpointIdentifier() != null) {
            array[totalLength++] = 90;
            array[totalLength++] = 58;
            totalLength += EndpointIdentifierHandler.encode(array, totalLength, response.getSpecificEndpointIdentifier());
        }
        if (response.getSecondConnectionIdentifier() != null) {
            array[totalLength++] = 73;
            array[totalLength++] = 50;
            array[totalLength++] = 58;
            connectionIdentifierBytes = response.getSecondConnectionIdentifier().toString().getBytes();
            System.arraycopy(connectionIdentifierBytes, 0, array, totalLength, connectionIdentifierBytes.length);
            totalLength += connectionIdentifierBytes.length;
            array[totalLength++] = 10;
        }
        if (response.getSecondEndpointIdentifier() != null) {
            array[totalLength++] = 90;
            array[totalLength++] = 50;
            array[totalLength++] = 58;
            totalLength += EndpointIdentifierHandler.encode(array, totalLength, response.getSecondEndpointIdentifier());
        }
        if (response.getLocalConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            byte[] rcdBytes = response.getLocalConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        CreateConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            ConnectionIdentifier connectionIdentifier = new ConnectionIdentifier("1");
            provisionalResponse = new CreateConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed, connectionIdentifier);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            block11: {
                block12: {
                    block10: {
                        if (name.getLength() != 1) break block10;
                        switch (data[name.getOffset()]) {
                            case 73: 
                            case 105: {
                                CreateConnectionHandler.this.response.setConnectionIdentifier(new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength())));
                                break;
                            }
                            case 90: 
                            case 122: {
                                CreateConnectionHandler.this.response.setSpecificEndpointIdentifier(EndpointIdentifierHandler.decode(data, value.getOffset(), value.getLength()));
                                break;
                            }
                            default: {
                                logger.warn((Object)("Unidentified CRCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                                break;
                            }
                        }
                        break block11;
                    }
                    if (name.getLength() != 2) break block12;
                    switch (data[name.getOffset()]) {
                        case 73: 
                        case 105: {
                            if (data[name.getOffset() + 1] == 50) {
                                CreateConnectionHandler.this.response.setSecondConnectionIdentifier(new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength())));
                                break;
                            }
                            break block11;
                        }
                        case 90: 
                        case 122: {
                            if (data[name.getOffset() + 1] == 50) {
                                CreateConnectionHandler.this.response.setSecondEndpointIdentifier(EndpointIdentifierHandler.decode(data, value.getOffset(), value.getLength()));
                                break;
                            }
                            break block11;
                        }
                        default: {
                            logger.warn((Object)("Unidentified CRCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                            break;
                        }
                    }
                    break block11;
                }
                logger.warn((Object)("Unidentified CRCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            CreateConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sd));
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 66: 
                    case 98: {
                        CreateConnectionHandler.this.command.setBearerInformation(BearerInformationHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 67: 
                    case 99: {
                        CreateConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 76: 
                    case 108: {
                        CreateConnectionHandler.this.command.setLocalConnectionOptions(LocalOptionValueHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 77: 
                    case 109: {
                        CreateConnectionHandler.this.command.setMode(ConnectionModeHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 78: 
                    case 110: {
                        CreateConnectionHandler.this.command.setNotifiedEntity(NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true));
                        break;
                    }
                    case 88: 
                    case 120: {
                        CreateConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(new String(data, value.getOffset(), value.getLength()))));
                        break;
                    }
                    case 68: 
                    case 100: {
                        CreateConnectionHandler.this.command.getNotificationRequestParms().setDigitMap(DigitMapHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 82: 
                    case 114: {
                        CreateConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(RequestedEventHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 83: 
                    case 115: {
                        CreateConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 84: 
                    case 116: {
                        CreateConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified CRCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else if (name.getLength() == 2) {
                switch (data[name.getOffset()]) {
                    case 90: 
                    case 122: {
                        if (data[name.getOffset() + 1] == 50) {
                            try {
                                CreateConnectionHandler.this.command.setSecondEndpointIdentifier(EndpointIdentifierHandler.decode(data, value.getOffset(), value.getLength()));
                            }
                            catch (ConflictingParameterException e) {}
                            break;
                        }
                        logger.warn((Object)("Unidentified CRCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified CRCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified CRCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            try {
                CreateConnectionHandler.this.command.setRemoteConnectionDescriptor(new ConnectionDescriptor(sd));
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error in session descriptor", (Throwable)e);
            }
        }
    }
}

