/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.OAM_IF;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.protocols.mgcp.handlers.MessageHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;
import org.mobicents.protocols.mgcp.utils.PacketRepresentationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainMgcpStackImpl
extends Thread
implements JainMgcpStack,
OAM_IF {
    public static final String _EXECUTOR_TABLE_SIZE = "executorTableSize";
    public static final String _EXECUTOR_QUEUE_SIZE = "executorQueueSize";
    private static final Logger logger = Logger.getLogger(JainMgcpStackImpl.class);
    private static final String propertiesFileName = "mgcp-stack.properties";
    private String protocolVersion = "1.0";
    protected int port = 2727;
    private InetAddress localAddress = null;
    private boolean stopped = true;
    private PacketRepresentationFactory prFactory = null;
    private static final int BUFFER_SIZE = 5000;
    private DatagramChannel channel;
    ByteBuffer receiveBuffer = ByteBuffer.allocateDirect(5000);
    ByteBuffer sendBuffer = ByteBuffer.allocateDirect(5000);
    byte[] b = new byte[5000];
    public JainMgcpStackProviderImpl provider = null;
    private InetSocketAddress address = null;
    private ConcurrentMap<TransactionHandler> localTransactions = new ConcurrentMap();
    private ConcurrentMap<Integer> remoteTxToLocalTxMap = new ConcurrentMap();
    private ConcurrentMap<TransactionHandler> completedTransactions = new ConcurrentMap();
    private ConcurrentCyclicFIFO<PacketRepresentation> inputQueue = new ConcurrentCyclicFIFO();
    private DatagramSocket socket;
    private long delay = 4L;
    private long threshold = 2L;
    protected int parserThreadPoolSize = 2;
    private DecodingThread[] decodingThreads;

    public void printStats() {
    }

    public JainMgcpStackImpl() {
    }

    public JainMgcpStackImpl(InetAddress localAddress, int port) {
        this.localAddress = localAddress;
        this.port = port;
    }

    private void init() throws IOException {
        this.readProperties();
        if (this.channel == null) {
            try {
                InetSocketAddress bindAddress = new InetSocketAddress(this.localAddress, this.port);
                this.channel = DatagramChannel.open();
                this.socket = this.channel.socket();
                this.socket.bind(bindAddress);
                this.channel.configureBlocking(false);
                this.localAddress = this.socket.getLocalAddress();
                logger.info((Object)("Jain Mgcp stack bound to IP " + this.localAddress + " and UDP port " + this.port));
                System.out.println("Jain Mgcp stack bound to IP " + this.localAddress + " and UDP port " + this.port);
            }
            catch (SocketException e) {
                logger.error((Object)e);
                throw new RuntimeException("Failed to find a local port " + this.port + " to bound stack");
            }
        }
        this.stopped = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting main thread " + this));
        }
        this.provider = new JainMgcpStackProviderImpl(this);
        this.prFactory = new PacketRepresentationFactory(50, 5000);
        this.decodingThreads = new DecodingThread[this.parserThreadPoolSize];
        for (int i = 0; i < this.decodingThreads.length; ++i) {
            this.decodingThreads[i] = new DecodingThread(this);
        }
        this.setDaemon(false);
        this.start();
    }

    private void readProperties() {
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
            if (is == null) {
                logger.warn((Object)"Failed to locate properties file, using default values");
                return;
            }
            props.load(is);
            String val = null;
            val = props.getProperty(_EXECUTOR_QUEUE_SIZE, "" + this.parserThreadPoolSize);
            this.parserThreadPoolSize = Integer.parseInt(val);
            val = null;
            logger.info((Object)(propertiesFileName + " read successfully! \nexecutorQueueSize = " + this.parserThreadPoolSize));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to read properties file due to some error \"" + e.getMessage() + "\", using defualt values!!!!"));
        }
    }

    public void close() {
        block4: {
            this.stopped = true;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Closing socket");
                }
                this.socket.close();
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block4;
                logger.error((Object)"Could not gracefully close socket", (Throwable)e);
            }
        }
    }

    public JainMgcpProvider createProvider() throws CreateProviderException {
        if (this.provider != null) {
            throw new CreateProviderException("Provider already created. Only 1 provider can be created. Delete the first and then re-create");
        }
        try {
            this.init();
        }
        catch (IOException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)"Failed to open Socket ", (Throwable)e);
            }
            throw new CreateProviderException(e.getMessage());
        }
        return this.provider;
    }

    public void deleteProvider(JainMgcpProvider provider) throws DeleteProviderException {
        if (this.provider == null) {
            throw new DeleteProviderException("No Provider exist.");
        }
        if (this.provider != provider) {
            throw new DeleteProviderException("Passed provider is not current one.");
        }
        this.close();
        this.provider = null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        return null;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public PacketRepresentation allocatePacket() {
        return this.prFactory.allocate();
    }

    public void releasePacket(PacketRepresentation pr) {
        this.prFactory.deallocate(pr);
    }

    public void send(PacketRepresentation pr) {
        block2: {
            try {
                this.channel.send(pr.getBuffer(), pr.getInetAddress());
            }
            catch (IOException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block2;
                logger.error((Object)"I/O Exception occured, caused by", (Throwable)e);
            }
        }
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    @Override
    public void run() {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MGCP stack started successfully on " + this.localAddress + ":" + this.port));
        }
        int length = 0;
        long start = 0L;
        long finish = 0L;
        long drift = 0L;
        long latency = 0L;
        for (i = 0; i < this.decodingThreads.length; ++i) {
            this.decodingThreads[i].activate();
        }
        if (this.provider != null) {
            this.provider.start();
        }
        start = System.currentTimeMillis();
        while (!this.stopped) {
            try {
                do {
                    this.receiveBuffer.clear();
                    this.address = (InetSocketAddress)this.channel.receive(this.receiveBuffer);
                    this.receiveBuffer.flip();
                    length = this.receiveBuffer.limit();
                    if (length == 0) continue;
                    PacketRepresentation pr = this.prFactory.allocate();
                    this.receiveBuffer.get(pr.getRawData(), 0, length);
                    pr.setLength(length);
                    pr.setRemoteAddress(this.address);
                    this.inputQueue.offer((Object)pr);
                } while (this.address != null);
                this.provider.flush();
                finish = System.currentTimeMillis();
                drift = finish - start;
                latency = this.delay - drift;
                start = finish;
                if (drift > this.threshold) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(latency);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (IOException e) {
                if (this.stopped) break;
                if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                logger.error((Object)"I/O exception occured:", (Throwable)e);
            }
            catch (Exception e) {
                if (this.stopped) break;
                if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                logger.error((Object)"Unexpected exception occured:", (Throwable)e);
            }
        }
        for (i = 0; i < this.decodingThreads.length; ++i) {
            this.decodingThreads[i].shutdown();
        }
        if (this.provider != null) {
            this.provider.stop();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MGCP stack stopped gracefully on" + this.localAddress + ":" + this.port));
        }
    }

    public ConcurrentMap<TransactionHandler> getLocalTransactions() {
        return this.localTransactions;
    }

    public ConcurrentMap<Integer> getRemoteTxToLocalTxMap() {
        return this.remoteTxToLocalTxMap;
    }

    public ConcurrentMap<TransactionHandler> getCompletedTransactions() {
        return this.completedTransactions;
    }

    private class DecodingThread
    extends Thread {
        private volatile boolean active;
        private JainMgcpStackImpl stack;
        protected MessageHandler messageHandler = null;

        public DecodingThread(JainMgcpStackImpl stack) {
            this.stack = stack;
            this.messageHandler = new MessageHandler(stack);
        }

        public void run() {
            while (this.active) {
                PacketRepresentation current = null;
                while (current == null) {
                    try {
                        current = (PacketRepresentation)JainMgcpStackImpl.this.inputQueue.take();
                    }
                    catch (Exception e) {}
                }
                try {
                    this.messageHandler.scheduleMessages(current);
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    logger.error((Object)"Unexpected exception occured:", (Throwable)e);
                }
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }
}

