/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.AuditEndpointResponse;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.RestartInProgressResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.commands.AuditConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.AuditEndpointHandler;
import org.mobicents.protocols.mgcp.parser.commands.CreateConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.DeleteConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.EndpointConfigurationHandler;
import org.mobicents.protocols.mgcp.parser.commands.ModifyConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.NotificationRequestHandler;
import org.mobicents.protocols.mgcp.parser.commands.NotifyHandler;
import org.mobicents.protocols.mgcp.parser.commands.RespUnknownHandler;
import org.mobicents.protocols.mgcp.parser.commands.RestartInProgressHandler;
import org.mobicents.protocols.mgcp.stack.ExtendedJainMgcpProvider;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class JainMgcpStackProviderImpl
implements ExtendedJainMgcpProvider {
    private static Logger logger = Logger.getLogger(JainMgcpStackProviderImpl.class);
    private final JainMgcpStackImpl runningStack;
    private static long MAX_TRANSACTION_HANDLE_ID = 999999999L;
    private static AtomicInteger transactionHandleCounter = new AtomicInteger(Integer.MIN_VALUE);
    private static AtomicInteger callIdentifierCounter = new AtomicInteger(Integer.MIN_VALUE);
    private static AtomicInteger requestIdentifierCounter = new AtomicInteger(Integer.MIN_VALUE);
    protected Set<JainMgcpListener> jainListeners = new HashSet<JainMgcpListener>();
    protected Set<JainMgcpExtendedListener> jainMobicentsListeners = new HashSet<JainMgcpExtendedListener>();
    protected NotifiedEntity notifiedEntity = null;
    private ConcurrentCyclicFIFO<EventWrapper> waitingQueue = new ConcurrentCyclicFIFO();
    private DispatcherThread dispatcher;
    private LinkedList<JainMgcpEvent[]> asyncBuffer = new LinkedList();

    public JainMgcpStackProviderImpl(JainMgcpStackImpl runningStack) {
        this.runningStack = runningStack;
        this.dispatcher = new DispatcherThread();
    }

    protected void start() {
        this.dispatcher.activate();
    }

    protected void stop() {
        this.dispatcher.shutdown();
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJainMgcpListener(JainMgcpListener listener) throws TooManyListenersException {
        if (listener instanceof JainMgcpExtendedListener) {
            Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
            synchronized (set) {
                this.jainMobicentsListeners.add((JainMgcpExtendedListener)listener);
            }
        }
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            this.jainListeners.add(listener);
        }
    }

    public JainMgcpStack getJainMgcpStack() {
        return this.runningStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJainMgcpListener(JainMgcpListener listener) {
        if (listener instanceof JainMgcpExtendedListener) {
            Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
            synchronized (set) {
                this.jainMobicentsListeners.remove((JainMgcpExtendedListener)listener);
            }
        }
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            this.jainListeners.remove(listener);
        }
    }

    public void sendMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        for (JainMgcpEvent event : events) {
            TransactionHandler handle;
            if (event instanceof JainMgcpCommandEvent) {
                JainMgcpCommandEvent commandEvent = (JainMgcpCommandEvent)event;
                if (commandEvent.getTransactionHandle() < 1) {
                    commandEvent.setTransactionHandle(this.getUniqueTransactionHandler());
                }
                handle = null;
                switch (commandEvent.getObjectIdentifier()) {
                    case 101: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditConnectionHandler(this.runningStack);
                        break;
                    }
                    case 102: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditEndpointHandler(this.runningStack);
                        break;
                    }
                    case 103: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending CreateConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new CreateConnectionHandler(this.runningStack);
                        break;
                    }
                    case 104: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending DeleteConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new DeleteConnectionHandler(this.runningStack);
                        break;
                    }
                    case 105: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new EndpointConfigurationHandler(this.runningStack);
                        break;
                    }
                    case 106: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new ModifyConnectionHandler(this.runningStack);
                        break;
                    }
                    case 107: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending NotificationRequest object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new NotificationRequestHandler(this.runningStack);
                        break;
                    }
                    case 108: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending Notify object to NotifiedEntity" + ((Notify)commandEvent).getNotifiedEntity()));
                        }
                        handle = new NotifyHandler(this.runningStack);
                        break;
                    }
                    case 300: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ResponseUnknown object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RespUnknownHandler(this.runningStack);
                        break;
                    }
                    case 109: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending RestartInProgress object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RestartInProgressHandler(this.runningStack);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not send type of the message yet");
                    }
                }
                handle.setCommand(true);
                handle.setCommandEvent(commandEvent);
                handle.send();
                continue;
            }
            int tid = event.getTransactionHandle();
            handle = (TransactionHandler)this.runningStack.getLocalTransactions().get((Object)tid);
            if (handle != null) {
                handle.setCommand(false);
                handle.setResponseEvent((JainMgcpResponseEvent)event);
                handle.send();
                continue;
            }
            logger.error((Object)("The TransactionHandler not found for TransactionHandle " + tid + " May be the Tx timed out. Event = " + (JainMgcpResponseEvent)event));
        }
    }

    public int getUniqueTransactionHandler() {
        return (int)(((long)transactionHandleCounter.incrementAndGet() - Integer.MIN_VALUE) % MAX_TRANSACTION_HANDLE_ID + 1L);
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response, JainMgcpEvent command) {
        this.waitingQueue.offer((Object)new EventWrapper(response, 2));
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        this.waitingQueue.offer((Object)new EventWrapper(command, 1));
    }

    public void processTxTimeout(JainMgcpCommandEvent command) {
        this.waitingQueue.offer((Object)new EventWrapper(command, 3));
    }

    public void processRxTimeout(JainMgcpCommandEvent command) {
        this.waitingQueue.offer((Object)new EventWrapper(command, 4));
    }

    public CallIdentifier getUniqueCallIdentifier() {
        return new CallIdentifier(Long.toHexString((long)callIdentifierCounter.incrementAndGet() - Integer.MIN_VALUE));
    }

    public RequestIdentifier getUniqueRequestIdentifier() {
        return new RequestIdentifier(Long.toHexString((long)requestIdentifierCounter.incrementAndGet() - Integer.MIN_VALUE));
    }

    public void sendAsyncMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        this.asyncBuffer.addLast(events);
    }

    public void flush() {
        while (!this.asyncBuffer.isEmpty()) {
            JainMgcpEvent[] events = this.asyncBuffer.removeFirst();
            this.sendMgcpEvents(events);
        }
    }

    private class DispatcherThread
    extends Thread {
        private volatile boolean active;
        JainMgcpCommandEvent command;
        JainMgcpResponseEvent response;
        EventWrapper currEvent;

        private DispatcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.active) {
                this.currEvent = null;
                while (this.currEvent == null) {
                    try {
                        this.currEvent = (EventWrapper)JainMgcpStackProviderImpl.this.waitingQueue.take();
                    }
                    catch (Exception e) {}
                }
                try {
                    switch (this.currEvent.eventType) {
                        case 1: {
                            this.command = (JainMgcpCommandEvent)this.currEvent.event;
                            Set<JainMgcpListener> e = JainMgcpStackProviderImpl.this.jainListeners;
                            synchronized (e) {
                                for (JainMgcpListener jainMgcpListener : JainMgcpStackProviderImpl.this.jainListeners) {
                                    jainMgcpListener.processMgcpCommandEvent(this.command);
                                }
                            }
                            e = JainMgcpStackProviderImpl.this.jainMobicentsListeners;
                            synchronized (e) {
                                for (JainMgcpExtendedListener jainMgcpExtendedListener : JainMgcpStackProviderImpl.this.jainMobicentsListeners) {
                                    jainMgcpExtendedListener.processMgcpCommandEvent(this.command);
                                }
                                break;
                            }
                        }
                        case 2: {
                            this.response = (JainMgcpResponseEvent)this.currEvent.event;
                            Set<JainMgcpListener> e = JainMgcpStackProviderImpl.this.jainListeners;
                            synchronized (e) {
                                for (JainMgcpListener jainMgcpListener : JainMgcpStackProviderImpl.this.jainListeners) {
                                    jainMgcpListener.processMgcpResponseEvent(this.response);
                                }
                            }
                            e = JainMgcpStackProviderImpl.this.jainMobicentsListeners;
                            synchronized (e) {
                                for (JainMgcpExtendedListener jainMgcpExtendedListener : JainMgcpStackProviderImpl.this.jainMobicentsListeners) {
                                    jainMgcpExtendedListener.processMgcpResponseEvent(this.response);
                                }
                                break;
                            }
                        }
                        case 4: {
                            this.command = (JainMgcpCommandEvent)this.currEvent.event;
                            Set<JainMgcpListener> e = JainMgcpStackProviderImpl.this.jainMobicentsListeners;
                            synchronized (e) {
                                for (JainMgcpExtendedListener jainMgcpExtendedListener : JainMgcpStackProviderImpl.this.jainMobicentsListeners) {
                                    jainMgcpExtendedListener.transactionRxTimedOut(this.command);
                                }
                            }
                            this.response = null;
                            switch (this.command.getObjectIdentifier()) {
                                case 101: {
                                    this.response = new AuditConnectionResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 102: {
                                    this.response = new AuditEndpointResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 103: {
                                    this.response = new CreateConnectionResponse((Object)this, ReturnCode.Transient_Error, new ConnectionIdentifier(Long.toHexString(new Random(System.currentTimeMillis()).nextLong())));
                                    break;
                                }
                                case 104: {
                                    this.response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 105: {
                                    this.response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 106: {
                                    this.response = new ModifyConnectionResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 107: {
                                    this.response = new NotificationRequestResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 108: {
                                    this.response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 300: {
                                    this.response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                case 109: {
                                    this.response = new RestartInProgressResponse((Object)this, ReturnCode.Transient_Error);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Could not send type of the message yet");
                                }
                            }
                            this.response.setTransactionHandle(this.command.getTransactionHandle());
                            JainMgcpEvent[] events = new JainMgcpEvent[]{this.response};
                            JainMgcpStackProviderImpl.this.sendMgcpEvents(events);
                            break;
                        }
                        case 3: {
                            this.command = (JainMgcpCommandEvent)this.currEvent.event;
                            Set<JainMgcpExtendedListener> set = JainMgcpStackProviderImpl.this.jainMobicentsListeners;
                            synchronized (set) {
                                for (JainMgcpExtendedListener listener : JainMgcpStackProviderImpl.this.jainMobicentsListeners) {
                                    listener.transactionTxTimedOut(this.command);
                                }
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    logger.error((Object)"Unexpected exception occured:", (Throwable)e);
                }
            }
        }

        public void activate() {
            this.active = true;
            this.start();
        }

        private void shutdown() {
            this.active = false;
        }
    }

    private class EventWrapper {
        private static final int request = 1;
        private static final int response = 2;
        private static final int txTimeout = 3;
        private static final int rxTimeout = 4;
        protected Object event;
        protected int eventType;

        public EventWrapper(Object event, int eventType) {
            this.event = event;
            this.eventType = eventType;
        }
    }
}

