/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.text.ParseException;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;

public class EndpointIdentifierHandler {
    public static EndpointIdentifier decode(byte[] value, int offset, int length) throws ParseException {
        for (int i = 0; i < length; ++i) {
            if (value[offset + i] != 64) continue;
            return new EndpointIdentifier(new String(value, offset, i), new String(value, offset + i + 1, length - i - 1));
        }
        return new EndpointIdentifier(new String(value, offset, length), null);
    }

    public static int encode(byte[] destination, int offset, EndpointIdentifier endpointIdentifier) {
        int usedLength = 0;
        byte[] name = endpointIdentifier.getLocalEndpointName().getBytes();
        System.arraycopy(name, 0, destination, offset, name.length);
        usedLength = name.length;
        if (endpointIdentifier.getDomainName() != null) {
            destination[offset + usedLength] = 64;
            name = endpointIdentifier.getDomainName().getBytes();
            System.arraycopy(name, 0, destination, offset + ++usedLength, name.length);
            usedLength += name.length;
        }
        return usedLength;
    }

    public static int encodeList(byte[] destination, int offset, EndpointIdentifier[] endpointIds) {
        int i;
        if (endpointIds.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < endpointIds.length - 1; ++i) {
            totalLength += EndpointIdentifierHandler.encode(destination, offset + totalLength, endpointIds[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += EndpointIdentifierHandler.encode(destination, offset + totalLength, endpointIds[i]);
        return totalLength;
    }

    public static EndpointIdentifier[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        EndpointIdentifier[] endpointIds = new EndpointIdentifier[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            endpointIds[i] = EndpointIdentifierHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return endpointIds;
    }
}

