/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.handlers;

import java.io.IOException;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.parser.SplitDetails;

public abstract class MgcpContentHandler {
    private static final Logger logger = Logger.getLogger(MgcpContentHandler.class);

    public abstract void param(byte[] var1, SplitDetails var2, SplitDetails var3) throws ParseException;

    public abstract void sessionDescription(String var1) throws ParseException;

    public void parse(byte[] data, SplitDetails[] message) throws IOException, ParseException {
        int i;
        boolean sdpPresent = false;
        for (i = 1; i < message.length; ++i) {
            boolean bl = sdpPresent = message[i].getLength() == 0;
            if (sdpPresent) break;
            SplitDetails[] paramDetails = this.readParamLineWithTrim(data, message[i]);
            if (paramDetails.length == 1) {
                logger.warn((Object)("Unrecognized parameter: " + new String(data, message[i].getOffset(), message[i].getLength())));
                continue;
            }
            this.param(data, paramDetails[0], paramDetails[1]);
        }
        if (sdpPresent && i < message.length) {
            StringBuilder sdp = new StringBuilder();
            while (i < message.length - 1) {
                sdp.append(new String(data, message[i].getOffset(), message[i].getLength())).append("\r\n");
                ++i;
            }
            sdp.append(new String(data, message[i].getOffset(), message[i].getLength()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read session description: " + sdp.toString()));
            }
            this.sessionDescription(sdp.toString());
        }
    }

    private SplitDetails[] readParamLineWithTrim(byte[] source, SplitDetails lineDetails) {
        byte currByte;
        int i;
        int startIndex = lineDetails.getOffset();
        for (i = 0; i < lineDetails.getLength() && ((currByte = source[lineDetails.getOffset() + i]) == 32 || currByte == 9); ++i) {
            ++startIndex;
        }
        int endIndex = startIndex;
        Boolean colonFound = false;
        while (i < lineDetails.getLength()) {
            currByte = source[lineDetails.getOffset() + i];
            if (currByte == 58) {
                colonFound = true;
                ++i;
                break;
            }
            if (currByte != 32 && currByte != 9) {
                endIndex = lineDetails.getOffset() + i;
            }
            ++i;
        }
        if (i == lineDetails.getLength()) {
            if (colonFound.booleanValue()) {
                SplitDetails[] result = new SplitDetails[]{new SplitDetails(startIndex, endIndex - startIndex + 1), new SplitDetails(endIndex + 1, 0)};
                return result;
            }
            SplitDetails[] result = new SplitDetails[]{new SplitDetails(startIndex, endIndex - startIndex + 1)};
            return result;
        }
        SplitDetails[] result = new SplitDetails[2];
        result[0] = new SplitDetails(startIndex, endIndex - startIndex + 1);
        startIndex = lineDetails.getOffset() + i;
        while (i < lineDetails.getLength() && ((currByte = source[lineDetails.getOffset() + i]) == 32 || currByte == 9)) {
            ++startIndex;
            ++i;
        }
        endIndex = lineDetails.getOffset() + lineDetails.getLength() - 1;
        while (i < lineDetails.getLength() && ((currByte = source[endIndex]) == 32 || currByte == 9)) {
            --endIndex;
            ++i;
        }
        result[1] = new SplitDetails(startIndex, endIndex - startIndex + 1);
        return result;
    }
}

