/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.BearerInformationHandler;
import org.mobicents.protocols.mgcp.parser.params.ConnectionParmHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.EventNameHandler;
import org.mobicents.protocols.mgcp.parser.params.NotificationRequestParamHandler;
import org.mobicents.protocols.mgcp.parser.params.ReasonCodeHandler;
import org.mobicents.protocols.mgcp.parser.params.RequestedEventHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class DeleteConnectionHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{68, 76, 67, 88};
    private DeleteConnection command;
    private DeleteConnectionResponse response;
    private static final Logger logger = Logger.getLogger(DeleteConnectionHandler.class);

    public DeleteConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public DeleteConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new DeleteConnection(this.source != null ? this.source : this.stack, this.endpoint);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (IOException e) {
            logger.error((Object)"Decode of DLCX command failed", (Throwable)e);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new DeleteConnectionResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (Exception e) {
            logger.error((Object)"Decode of DLCX Response failed", (Throwable)e);
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        DeleteConnection evt = (DeleteConnection)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        if (evt.getBearerInformation() != null) {
            array[totalLength++] = 66;
            array[totalLength++] = 58;
            totalLength += BearerInformationHandler.encode(array, totalLength, evt.getBearerInformation());
            array[totalLength++] = 10;
        }
        if (evt.getCallIdentifier() != null) {
            array[totalLength++] = 67;
            array[totalLength++] = 58;
            byte[] callBytes = evt.getCallIdentifier().toString().getBytes();
            System.arraycopy(callBytes, 0, array, totalLength, callBytes.length);
            totalLength += callBytes.length;
            array[totalLength++] = 10;
        }
        if (evt.getConnectionIdentifier() != null) {
            array[totalLength++] = 73;
            array[totalLength++] = 58;
            byte[] connectionIdentifierBytes = evt.getConnectionIdentifier().toString().getBytes();
            System.arraycopy(connectionIdentifierBytes, 0, array, totalLength, connectionIdentifierBytes.length);
            totalLength += connectionIdentifierBytes.length;
            array[totalLength++] = 10;
        }
        if (evt.getConnectionParms() != null) {
            array[totalLength++] = 80;
            array[totalLength++] = 58;
            totalLength += ConnectionParmHandler.encodeList(array, totalLength, evt.getConnectionParms());
            array[totalLength++] = 10;
        }
        if (evt.getNotificationRequestParms() != null) {
            totalLength += NotificationRequestParamHandler.encode(array, totalLength, evt.getNotificationRequestParms());
            array[totalLength++] = 10;
        }
        if (evt.getReasonCode() != null) {
            array[totalLength++] = 69;
            array[totalLength++] = 58;
            totalLength += ReasonCodeHandler.encode(array, totalLength, evt.getReasonCode());
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        DeleteConnectionResponse response = (DeleteConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getConnectionParms() != null) {
            array[totalLength++] = 80;
            array[totalLength++] = 58;
            totalLength += ConnectionParmHandler.encodeList(array, totalLength, response.getConnectionParms());
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        DeleteConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new DeleteConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.commandEvent.getTransactionHandle());
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                switch (data[name.getOffset()]) {
                    case 73: 
                    case 105: {
                        break;
                    }
                    case 80: 
                    case 112: {
                        DeleteConnectionHandler.this.response.setConnectionParms(ConnectionParmHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified DLCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                }
            } else {
                logger.warn((Object)("Unidentified DLCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
        }
    }

    public class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() != 1) {
                logger.warn((Object)("Unidentified DLCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            } else {
                switch (data[name.getOffset()]) {
                    case 66: 
                    case 98: {
                        DeleteConnectionHandler.this.command.setBearerInformation(BearerInformationHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 67: 
                    case 99: {
                        DeleteConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 73: 
                    case 105: {
                        DeleteConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 88: 
                    case 120: {
                        DeleteConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(new String(data, value.getOffset(), value.getLength()))));
                        break;
                    }
                    case 82: 
                    case 114: {
                        DeleteConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(RequestedEventHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 83: 
                    case 115: {
                        DeleteConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 84: 
                    case 116: {
                        DeleteConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(EventNameHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 80: 
                    case 112: {
                        DeleteConnectionHandler.this.command.setConnectionParms(ConnectionParmHandler.decodeList(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 69: 
                    case 101: {
                        DeleteConnectionHandler.this.command.setReasonCode(ReasonCodeHandler.decode(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified DLCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                    }
                }
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

