/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.EndpointConfiguration;
import jain.protocol.ip.mgcp.message.EndpointConfigurationResponse;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.BearerInformationHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class EndpointConfigurationHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{69, 80, 67, 70};
    private EndpointConfiguration command;
    private EndpointConfigurationResponse response;
    private static final Logger logger = Logger.getLogger(EndpointConfigurationHandler.class);

    public EndpointConfigurationHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public EndpointConfigurationHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        this.command = new EndpointConfiguration(this.source != null ? this.source : this.stack, this.endpoint, BearerInformation.EncMethod_A_Law);
        this.command.setTransactionHandle(this.remoteTID);
        try {
            new CommandContentHandle().parse(data, message);
        }
        catch (Exception e) {
            logger.error((Object)"Parsing of EndpointConfiguration command failed", (Throwable)e);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new EndpointConfigurationResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (Exception e) {
            logger.error((Object)"Parsing of EndpointConfiguration Response failed", (Throwable)e);
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        EndpointConfiguration evt = (EndpointConfiguration)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        array[totalLength++] = 66;
        array[totalLength++] = 58;
        totalLength += BearerInformationHandler.encode(array, totalLength, evt.getBearerInformation());
        array[totalLength++] = 10;
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        EndpointConfigurationResponse response = (EndpointConfigurationResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        EndpointConfigurationResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new EndpointConfigurationResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        public void header(String header) throws ParseException {
        }

        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() == 1) {
                if (data[name.getOffset()] == 98 || data[name.getOffset()] == 66) {
                    EndpointConfigurationHandler.this.command.setBearerInformation(BearerInformationHandler.decode(data, value.getOffset(), value.getLength()));
                } else {
                    logger.warn((Object)("Unidentified EPCF Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                }
            } else {
                logger.warn((Object)("Unidentified EPCF Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

