/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import java.text.ParseException;
import java.util.ArrayList;
import org.mobicents.protocols.mgcp.parser.params.EmbeddedRequestHandler;

public class RequestedActionHandler {
    public static RequestedAction decode(byte[] value, int offset, int length) throws ParseException {
        if (length == 1) {
            switch (value[offset]) {
                case 78: 
                case 110: {
                    return RequestedAction.NotifyImmediately;
                }
                case 65: 
                case 97: {
                    return RequestedAction.Accumulate;
                }
                case 83: 
                case 115: {
                    return RequestedAction.Swap;
                }
                case 73: 
                case 105: {
                    return RequestedAction.Ignore;
                }
                case 75: 
                case 107: {
                    return RequestedAction.KeepSignalsActive;
                }
                case 68: 
                case 100: {
                    return RequestedAction.TreatAccordingToDigitMap;
                }
                case 88: 
                case 120: {
                    return RequestedAction.Ignore;
                }
            }
        } else if (value[offset] == 101 || value[offset] == 69) {
            if (value[offset + 1] != 40) {
                throw new ParseException("Invalid requested action " + new String(value, offset, length), 0);
            }
            if (value[offset + length - 1] != 41) {
                throw new ParseException("Invalid requested action " + new String(value, offset, length), 0);
            }
            int startIndex = offset + 2;
            while (value[startIndex] == 32) {
                ++startIndex;
            }
            int endIndex = offset + length - 2;
            while (value[endIndex] == 32) {
                --endIndex;
            }
            return new RequestedAction(EmbeddedRequestHandler.decode(value, startIndex, endIndex - startIndex + 1));
        }
        throw new ParseException("Invalid requested action " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, RequestedAction requestedAction) {
        switch (requestedAction.getRequestedAction()) {
            case 1: {
                destination[offset] = 78;
                return 1;
            }
            case 2: {
                destination[offset] = 65;
                return 1;
            }
            case 3: {
                destination[offset] = 68;
                return 1;
            }
            case 4: {
                destination[offset] = 83;
                return 1;
            }
            case 5: {
                destination[offset] = 73;
                return 1;
            }
            case 6: {
                destination[offset] = 75;
                return 1;
            }
            case 7: {
                destination[offset] = 69;
                destination[offset + 1] = 40;
                int returnLength = EmbeddedRequestHandler.encode(destination, offset + 2, requestedAction.getEmbeddedRequest());
                destination[offset + 2 + returnLength] = 41;
                return returnLength + 3;
            }
        }
        return 0;
    }

    public static int encodeList(byte[] destination, int offset, RequestedAction[] actions) {
        int i;
        if (actions.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < actions.length - 1; ++i) {
            totalLength += RequestedActionHandler.encode(destination, offset + totalLength, actions[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += RequestedActionHandler.encode(destination, offset + totalLength, actions[i]);
        return totalLength;
    }

    public static RequestedAction[] decodeList(byte[] value, int offset, int length) throws ParseException {
        ArrayList<RequestedAction> result = new ArrayList<RequestedAction>();
        int currIndex = offset;
        int startIndex = offset;
        int i = 0;
        while (value[startIndex] == 32 && i < length) {
            ++startIndex;
            ++i;
            ++currIndex;
        }
        int depth = 0;
        while (i < length) {
            switch (value[currIndex]) {
                case 40: {
                    ++depth;
                    break;
                }
                case 44: {
                    if (depth != 0 || i >= length) break;
                    result.add(RequestedActionHandler.decode(value, startIndex, currIndex - startIndex));
                    startIndex = currIndex + 1;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
                case 41: {
                    if (--depth != 0 || i >= length) break;
                    while (i < length && value[currIndex] == 32) {
                        ++i;
                        ++currIndex;
                    }
                    if (i >= length - 1 || value[currIndex + 1] != 44) break;
                    result.add(RequestedActionHandler.decode(value, startIndex, currIndex - startIndex + 1));
                    startIndex = currIndex + 2;
                    ++i;
                    ++currIndex;
                    while (i < length - 1 && value[startIndex] == 32) {
                        ++startIndex;
                        ++i;
                        ++currIndex;
                    }
                    break;
                }
            }
            ++i;
            ++currIndex;
        }
        if (startIndex < offset + length) {
            result.add(RequestedActionHandler.decode(value, startIndex, offset + length - startIndex));
        }
        RequestedAction[] actions = new RequestedAction[result.size()];
        actions = result.toArray(actions);
        result.clear();
        return actions;
    }
}

