/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.EncryptionMethod;
import java.text.ParseException;

public class EncryptionMethodHandler {
    private static final byte[] CLEAR_VALUE = new byte[]{99, 108, 101, 97, 114, 58};
    private static final byte[] BASE64_VALUE = new byte[]{98, 97, 115, 101, 54, 52, 58};
    private static final byte[] URI_VALUE = new byte[]{117, 114, 105, 58};

    public static EncryptionMethod decode(byte[] value, int offset, int length) throws ParseException {
        if (length >= URI_VALUE.length && value[offset + URI_VALUE.length - 1] == 58) {
            for (int i = 0; i < URI_VALUE.length - 1; ++i) {
                if (value[offset + i] == URI_VALUE[i] || value[offset + i] == (byte)(URI_VALUE[i] + -32)) continue;
                throw new ParseException("Invalid value for EncryptionData: " + new String(value, offset, length), 0);
            }
            return new EncryptionMethod(3, new String(value, offset + URI_VALUE.length, length - URI_VALUE.length));
        }
        if (length >= CLEAR_VALUE.length && value[offset + CLEAR_VALUE.length - 1] == 58) {
            for (int i = 0; i < CLEAR_VALUE.length - 1; ++i) {
                if (value[offset + i] == CLEAR_VALUE[i] || value[offset + i] == (byte)(CLEAR_VALUE[i] + -32)) continue;
                throw new ParseException("Invalid value for EncryptionData: " + new String(value, offset, length), 0);
            }
            return new EncryptionMethod(1, new String(value, offset + CLEAR_VALUE.length, length - CLEAR_VALUE.length));
        }
        if (length >= BASE64_VALUE.length && value[offset + BASE64_VALUE.length - 1] == 58) {
            for (int i = 0; i < BASE64_VALUE.length - 1; ++i) {
                if (value[offset + i] == BASE64_VALUE[i] || value[offset + i] == (byte)(BASE64_VALUE[i] + -32)) continue;
                throw new ParseException("Invalid value for EncryptionData: " + new String(value, offset, length), 0);
            }
            return new EncryptionMethod(2, new String(value, offset + BASE64_VALUE.length, length - BASE64_VALUE.length));
        }
        throw new ParseException("Invalid value for EncryptionData: " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, EncryptionMethod encryptionMethod) {
        int usedLength = 0;
        byte[] key = encryptionMethod.getEncryptionKey().getBytes();
        switch (encryptionMethod.getEncryptionMethod()) {
            case 2: {
                System.arraycopy(BASE64_VALUE, 0, destination, offset, BASE64_VALUE.length);
                usedLength = BASE64_VALUE.length;
                System.arraycopy(key, 0, destination, offset + usedLength, key.length);
                usedLength += key.length;
                break;
            }
            case 1: {
                System.arraycopy(CLEAR_VALUE, 0, destination, offset, CLEAR_VALUE.length);
                usedLength = CLEAR_VALUE.length;
                System.arraycopy(key, 0, destination, offset + usedLength, key.length);
                usedLength += key.length;
                break;
            }
            case 3: {
                System.arraycopy(URI_VALUE, 0, destination, offset, URI_VALUE.length);
                usedLength = URI_VALUE.length;
                System.arraycopy(key, 0, destination, offset + usedLength, key.length);
                usedLength += key.length;
            }
        }
        return usedLength;
    }
}

