/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.mobicents.protocols.mgcp.utils.PacketRepresentationFactory;

public class PacketRepresentation {
    private byte[] rawData = null;
    private InetSocketAddress remoteAddress = null;
    private int length = 0;
    private ByteBuffer buffer;
    private PacketRepresentationFactory prFactory = null;

    protected PacketRepresentation(int byteArrSize, PacketRepresentationFactory prFactory) {
        this.rawData = new byte[byteArrSize];
        this.buffer = ByteBuffer.wrap(this.rawData);
        this.prFactory = prFactory;
    }

    public ByteBuffer getBuffer() {
        this.buffer.position(0);
        this.buffer.limit(this.length);
        return this.buffer;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public int getLength() {
        return this.length;
    }

    public int getRemotePort() {
        return this.remoteAddress.getPort();
    }

    public void setLength(int length) {
        this.length = length;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress.getAddress();
    }

    public InetSocketAddress getInetAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void release() {
        this.prFactory.deallocate(this);
        this.remoteAddress = null;
        this.length = 0;
    }
}

