/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.text.ParseException;
import org.mobicents.protocols.mgcp.parser.StringFunctions;

public class NotifiedEntityHandler {
    public static final String emptyString = "";

    public static NotifiedEntity decode(byte[] value, int offset, int length, boolean toGateway) throws ParseException {
        String domainName;
        String localName;
        int currIndex = offset;
        int atIndex = -1;
        int colonIndex = -1;
        int i = 0;
        while (i < length) {
            if (value[currIndex] == 64) {
                if (atIndex >= 0 || colonIndex >= 0) {
                    throw new ParseException("Unknown value for Notified Entity: " + new String(value, offset, length), 0);
                }
                atIndex = currIndex;
            } else if (value[currIndex] == 58) {
                if (colonIndex >= 0) {
                    throw new ParseException("Unknown value for Notified Entity: " + new String(value, offset, length), 0);
                }
                colonIndex = currIndex;
                break;
            }
            ++i;
            ++currIndex;
        }
        if (atIndex >= 0) {
            localName = new String(value, offset, atIndex - offset);
            domainName = colonIndex >= 0 ? new String(value, atIndex + 1, colonIndex - atIndex - 1) : new String(value, atIndex + 1, length + offset - atIndex - 1);
        } else {
            localName = emptyString;
            domainName = colonIndex >= 0 ? new String(value, offset, colonIndex - offset) : new String(value, offset, length);
        }
        int port = 2727;
        if (colonIndex >= 0) {
            port = 0;
            int numberLength = length + offset - colonIndex - 1;
            currIndex = colonIndex + 1;
            int i2 = 0;
            while (i2 < numberLength) {
                if (value[currIndex] < 48 || value[currIndex] > 57) {
                    throw new ParseException("Unknown value for Notified Entity: " + new String(value, offset, length), 0);
                }
                port = port * 10 + (value[currIndex] - 48);
                ++i2;
                ++currIndex;
            }
        } else if (toGateway) {
            port = 2427;
        }
        return new NotifiedEntity(localName, domainName, port);
    }

    public static int encode(byte[] destination, int offset, NotifiedEntity notifiedEntity) {
        byte[] currNode;
        int totalLength = 0;
        if (notifiedEntity.getLocalName() != null && notifiedEntity.getLocalName().length() > 0) {
            currNode = notifiedEntity.getLocalName().getBytes();
            System.arraycopy(currNode, 0, destination, offset, currNode.length);
            destination[offset + (totalLength += currNode.length)] = 64;
            ++totalLength;
        }
        if (notifiedEntity.getDomainName() != null && notifiedEntity.getDomainName().length() > 0) {
            currNode = notifiedEntity.getDomainName().getBytes();
            System.arraycopy(currNode, 0, destination, offset + totalLength, currNode.length);
            totalLength += currNode.length;
        }
        if (notifiedEntity.getPortNumber() > 0) {
            destination[offset + totalLength] = 58;
            ++totalLength;
            totalLength += StringFunctions.encodeInt(destination, offset + totalLength, notifiedEntity.getPortNumber());
        }
        return totalLength;
    }
}

