/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.handlers;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.commands.AuditConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.AuditEndpointHandler;
import org.mobicents.protocols.mgcp.parser.commands.CreateConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.DeleteConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.EndpointConfigurationHandler;
import org.mobicents.protocols.mgcp.parser.commands.ModifyConnectionHandler;
import org.mobicents.protocols.mgcp.parser.commands.NotificationRequestHandler;
import org.mobicents.protocols.mgcp.parser.commands.NotifyHandler;
import org.mobicents.protocols.mgcp.parser.commands.RestartInProgressHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;

public class MessageHandler {
    private JainMgcpStackImpl stack;
    private static Logger logger = Logger.getLogger(MessageHandler.class);

    public MessageHandler(JainMgcpStackImpl jainMgcpStackImpl) {
        this.stack = jainMgcpStackImpl;
    }

    public boolean isRequest(byte headerByte) {
        return headerByte < 48 || headerByte > 57;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scheduleMessages(PacketRepresentation pr) throws ParseException {
        Integer remoteTxIdIntegere = new Integer(0);
        try {
            InetAddress address = pr.getRemoteAddress();
            int port = pr.getRemotePort();
            byte[] data = pr.getRawData();
            ArrayList<SplitDetails[]> result = StringFunctions.splitLinesWithTrim(data, 0, pr.getLength());
            int i = 0;
            while (i < result.size()) {
                SplitDetails[] message = result.get(i);
                SplitDetails[] tokens = StringFunctions.split(data, message[0].getOffset(), message[0].getLength(), (byte)32);
                int currIndex = tokens[1].getOffset();
                for (int j = 0; j < tokens[1].getLength(); ++j, ++currIndex) {
                    if (data[currIndex] < 48) throw new ParseException("Invalid tx:" + new String(data, tokens[1].getOffset(), tokens[1].getLength()), 0);
                    if (data[currIndex] > 57) throw new ParseException("Invalid tx:" + new String(data, tokens[1].getOffset(), tokens[1].getLength()), 0);
                    remoteTxIdIntegere = remoteTxIdIntegere * 10 + (data[currIndex] - 48);
                }
                if (this.isRequest(data[message[0].getOffset()])) {
                    TransactionHandler completedTxHandler;
                    EndpointIdentifier endpoint = EndpointIdentifierHandler.decode(data, tokens[2].getOffset(), tokens[2].getLength());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Processing command message = " + new String(data, tokens[0].getOffset(), tokens[0].getLength()) + " remote Tx = " + remoteTxIdIntegere));
                    }
                    if ((completedTxHandler = (TransactionHandler)this.stack.getCompletedTransactions().get((Object)remoteTxIdIntegere)) != null) {
                        completedTxHandler.markRetransmision();
                        completedTxHandler.send();
                        if (!logger.isDebugEnabled()) return;
                        logger.debug((Object)("Received Command for which stack has already sent response Tx = " + new String(data, tokens[0].getOffset(), tokens[0].getLength()) + " " + remoteTxIdIntegere));
                        return;
                    }
                    Integer tmpLoaclTID = (Integer)this.stack.getRemoteTxToLocalTxMap().get((Object)remoteTxIdIntegere);
                    if (tmpLoaclTID != null) {
                        TransactionHandler ongoingTxHandler = (TransactionHandler)this.stack.getLocalTransactions().get((Object)tmpLoaclTID);
                        ongoingTxHandler.sendProvisionalResponse();
                        if (!logger.isDebugEnabled()) return;
                        logger.debug((Object)("Received Command for ongoing Tx = " + remoteTxIdIntegere));
                        return;
                    }
                    TransactionHandler handler = null;
                    boolean found = true;
                    if (tokens[0].getLength() == 4) {
                        switch (data[tokens[0].getOffset()]) {
                            case 67: 
                            case 99: {
                                int k;
                                for (k = 1; k < 4; ++k) {
                                    if (data[tokens[0].getOffset() + k] == CreateConnectionHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(CreateConnectionHandler.COMMAND_NAME[k] - -32)) continue;
                                    found = false;
                                    break;
                                }
                                if (!found) break;
                                handler = new CreateConnectionHandler(this.stack, address, port);
                                break;
                            }
                            case 77: 
                            case 109: {
                                int k;
                                for (k = 1; k < 4; ++k) {
                                    if (data[tokens[0].getOffset() + k] == ModifyConnectionHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(ModifyConnectionHandler.COMMAND_NAME[k] - -32)) continue;
                                    found = false;
                                    break;
                                }
                                if (!found) break;
                                handler = new ModifyConnectionHandler(this.stack, address, port);
                                break;
                            }
                            case 68: 
                            case 100: {
                                int k;
                                for (k = 1; k < 4; ++k) {
                                    if (data[tokens[0].getOffset() + k] == DeleteConnectionHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(DeleteConnectionHandler.COMMAND_NAME[k] - -32)) continue;
                                    found = false;
                                    break;
                                }
                                if (!found) break;
                                handler = new DeleteConnectionHandler(this.stack, address, port);
                                break;
                            }
                            case 69: 
                            case 101: {
                                int k;
                                for (k = 1; k < 4; ++k) {
                                    if (data[tokens[0].getOffset() + k] == EndpointConfigurationHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(EndpointConfigurationHandler.COMMAND_NAME[k] - -32)) continue;
                                    found = false;
                                    break;
                                }
                                if (!found) break;
                                handler = new EndpointConfigurationHandler(this.stack, address, port);
                                break;
                            }
                            case 78: 
                            case 110: {
                                int k;
                                for (k = 1; k < 4; ++k) {
                                    if (data[tokens[0].getOffset() + k] == NotifyHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(NotifyHandler.COMMAND_NAME[k] - -32)) continue;
                                    found = false;
                                    break;
                                }
                                if (!found) break;
                                handler = new NotifyHandler(this.stack, address, port);
                                break;
                            }
                            case 82: 
                            case 114: {
                                int k;
                                switch (data[tokens[0].getOffset() + 1]) {
                                    case 81: 
                                    case 113: {
                                        for (k = 2; k < 4; ++k) {
                                            if (data[tokens[0].getOffset() + k] == NotificationRequestHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(NotificationRequestHandler.COMMAND_NAME[k] - -32)) continue;
                                            found = false;
                                            break;
                                        }
                                        if (!found) break;
                                        handler = new NotificationRequestHandler(this.stack, address, port);
                                        break;
                                    }
                                    case 83: 
                                    case 115: {
                                        for (k = 2; k < 4; ++k) {
                                            if (data[tokens[0].getOffset() + k] == RestartInProgressHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(RestartInProgressHandler.COMMAND_NAME[k] - -32)) continue;
                                            found = false;
                                            break;
                                        }
                                        if (!found) break;
                                        handler = new RestartInProgressHandler(this.stack, address, port);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 65: 
                            case 97: {
                                int k;
                                switch (data[tokens[0].getOffset() + 3]) {
                                    case 80: 
                                    case 112: {
                                        for (k = 1; k < 3; ++k) {
                                            if (data[tokens[0].getOffset() + k] == AuditEndpointHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(AuditEndpointHandler.COMMAND_NAME[k] - -32)) continue;
                                            found = false;
                                            break;
                                        }
                                        if (!found) break;
                                        handler = new AuditEndpointHandler(this.stack, address, port);
                                        break;
                                    }
                                    case 88: 
                                    case 120: {
                                        for (k = 1; k < 3; ++k) {
                                            if (data[tokens[0].getOffset() + k] == AuditConnectionHandler.COMMAND_NAME[k] || data[tokens[0].getOffset() + k] == (byte)(AuditConnectionHandler.COMMAND_NAME[k] - -32)) continue;
                                            found = false;
                                            break;
                                        }
                                        if (!found) break;
                                        handler = new AuditConnectionHandler(this.stack, address, port);
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (handler == null) {
                        logger.warn((Object)("Unsupported message verbose " + new String(data, tokens[0].getOffset(), tokens[0].getLength())));
                        return;
                    }
                    handler.receiveRequest(endpoint, data, message, remoteTxIdIntegere);
                } else {
                    TransactionHandler handler;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Processing response message " + new String(data, message[0].getOffset(), message[0].getLength())));
                    }
                    if ((handler = (TransactionHandler)this.stack.getLocalTransactions().get((Object)remoteTxIdIntegere)) == null) {
                        logger.warn((Object)("---  Address:" + address + "\nPort:" + port + "\nID:" + this.hashCode() + "\n Unknown transaction: " + remoteTxIdIntegere));
                        return;
                    }
                    ReturnCode returnCode = ReturnCodeHandler.decode(data, tokens[0].getOffset(), tokens[0].getLength());
                    handler.receiveResponse(data, message, remoteTxIdIntegere, returnCode);
                }
                ++i;
            }
            return;
        }
        finally {
            pr.release();
        }
    }
}

