/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import java.text.ParseException;

public class BearerInformationHandler {
    public static BearerInformation decode(byte[] value, int offset, int length) throws ParseException {
        if (value[offset] != 101 && value[offset] != 69) {
            throw new ParseException("Bearer extensions not supported", 0);
        }
        if (value[offset + 1] != 58) {
            throw new ParseException("Unknown value for BearerInformation: " + new String(value, offset, length), 0);
        }
        switch (length) {
            case 3: {
                if (value[offset + 2] != 97 && value[offset + 2] != 65) break;
                return BearerInformation.EncMethod_A_Law;
            }
            case 4: {
                if (value[offset + 2] != 109 && value[offset + 2] != 77 || value[offset + 3] != 117 && value[offset + 3] != 85) break;
                return BearerInformation.EncMethod_mu_Law;
            }
        }
        throw new ParseException("Unknown value for BearerInformation: " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, BearerInformation bearerInformation) {
        destination[offset] = 101;
        destination[offset + 1] = 58;
        if (1 == bearerInformation.getEncodingMethod()) {
            destination[offset + 2] = 65;
            return 3;
        }
        if (2 == bearerInformation.getEncodingMethod()) {
            destination[offset + 2] = 109;
            destination[offset + 3] = 117;
            return 4;
        }
        return 2;
    }
}

