/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.Bandwidth;
import java.text.ParseException;
import org.mobicents.protocols.mgcp.parser.StringFunctions;

public class BandwidthHandler {
    public static Bandwidth decode(byte[] value, int offset, int length) throws ParseException {
        int lowValue = 0;
        int highValue = 0;
        int i = 0;
        int currIndex = offset;
        while (i < length && value[currIndex] != 45) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid bandwith:" + new String(value, offset, length), 0);
            }
            lowValue = lowValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        if (i == length) {
            return new Bandwidth(lowValue);
        }
        ++i;
        ++currIndex;
        while (i < length) {
            if (value[currIndex] < 48 || value[currIndex] > 57) {
                throw new ParseException("Invalid bandwith:" + new String(value, offset, length), 0);
            }
            highValue = highValue * 10 + (value[currIndex] - 48);
            ++i;
            ++currIndex;
        }
        return new Bandwidth(lowValue, highValue);
    }

    public static int encode(byte[] destination, int offset, Bandwidth bandwidth) {
        int usedLength = StringFunctions.encodeInt(destination, offset, bandwidth.getBandwidthLowerBound());
        if (bandwidth.getBandwidthLowerBound() != bandwidth.getBandwidthUpperBound()) {
            destination[offset + usedLength] = 45;
            ++usedLength;
            usedLength += StringFunctions.encodeInt(destination, offset + usedLength, bandwidth.getBandwidthUpperBound());
        }
        return usedLength;
    }
}

