/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.commands;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditConnection;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.mgcp.handlers.MgcpContentHandler;
import org.mobicents.protocols.mgcp.handlers.TransactionHandler;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.ConnectionModeHandler;
import org.mobicents.protocols.mgcp.parser.params.ConnectionParmHandler;
import org.mobicents.protocols.mgcp.parser.params.EndpointIdentifierHandler;
import org.mobicents.protocols.mgcp.parser.params.InfoCodeHandler;
import org.mobicents.protocols.mgcp.parser.params.LocalOptionValueHandler;
import org.mobicents.protocols.mgcp.parser.params.NotifiedEntityHandler;
import org.mobicents.protocols.mgcp.parser.params.ReturnCodeHandler;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;

public class AuditConnectionHandler
extends TransactionHandler {
    public static final byte[] COMMAND_NAME = new byte[]{65, 85, 67, 88};
    private static final Logger logger = Logger.getLogger(AuditConnectionHandler.class);
    private AuditConnection command;
    private AuditConnectionResponse response;
    private ConnectionIdentifier connectionIdentifier = null;
    private InfoCode[] requestedInfo = null;
    boolean RCfirst = false;

    public AuditConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public AuditConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    @Override
    public JainMgcpCommandEvent decodeCommand(byte[] data, SplitDetails[] message) throws ParseException {
        try {
            new CommandContentHandle().parse(data, message);
            this.command = new AuditConnection(this.source != null ? this.source : this.stack, this.endpoint, this.connectionIdentifier, this.requestedInfo);
            this.command.setTransactionHandle(this.remoteTID);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    @Override
    public JainMgcpResponseEvent decodeResponse(byte[] data, SplitDetails[] msg, Integer txID, ReturnCode returnCode) throws ParseException {
        this.response = new AuditConnectionResponse(this.source != null ? this.source : this.stack, returnCode);
        this.response.setTransactionHandle(txID.intValue());
        try {
            new ResponseContentHandle().parse(data, msg);
        }
        catch (IOException e) {
            logger.error((Object)"Parsing of AUCX Response failed ", (Throwable)e);
        }
        return this.response;
    }

    @Override
    public int encode(JainMgcpCommandEvent event, byte[] array) {
        InfoCode[] requestedInfos;
        AuditConnection evt = (AuditConnection)event;
        int totalLength = 5;
        System.arraycopy(COMMAND_NAME, 0, array, 0, 4);
        array[4] = 32;
        totalLength += StringFunctions.encodeInt(array, 5, event.getTransactionHandle());
        array[totalLength++] = 32;
        totalLength += EndpointIdentifierHandler.encode(array, totalLength, evt.getEndpointIdentifier());
        array[totalLength++] = 32;
        System.arraycopy(MGCP_VERSION, 0, array, totalLength, MGCP_VERSION.length);
        totalLength += MGCP_VERSION.length;
        array[totalLength++] = 10;
        if (evt.getConnectionIdentifier() != null) {
            array[totalLength++] = 73;
            array[totalLength++] = 58;
            byte[] connectionIdentifierBytes = evt.getConnectionIdentifier().toString().getBytes();
            System.arraycopy(connectionIdentifierBytes, 0, array, totalLength, connectionIdentifierBytes.length);
            totalLength += connectionIdentifierBytes.length;
            array[totalLength++] = 10;
        }
        if ((requestedInfos = evt.getRequestedInfo()) != null) {
            array[totalLength++] = 70;
            array[totalLength++] = 58;
            totalLength += InfoCodeHandler.encodeList(array, totalLength, requestedInfos);
            array[totalLength++] = 10;
            int foundRC = 0;
            int foundLC = 0;
            block4: for (int count = 0; count < requestedInfos.length; ++count) {
                InfoCode info = requestedInfos[count];
                switch (info.getInfoCode()) {
                    case 17: {
                        foundRC = count;
                        if (foundLC != 0 && foundLC < count) {
                            this.RCfirst = false;
                            continue block4;
                        }
                        this.RCfirst = true;
                        continue block4;
                    }
                    case 18: {
                        foundLC = count;
                        this.RCfirst = foundRC != 0 && foundRC < count;
                    }
                }
            }
        }
        return totalLength;
    }

    @Override
    public int encode(JainMgcpResponseEvent event, byte[] array) {
        byte[] rcdBytes;
        AuditConnectionResponse response = (AuditConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        int totalLength = ReturnCodeHandler.encode(array, 0, returnCode);
        array[totalLength++] = 32;
        totalLength += StringFunctions.encodeInt(array, totalLength, response.getTransactionHandle());
        array[totalLength++] = 32;
        byte[] commentBytes = returnCode.getComment().getBytes();
        System.arraycopy(commentBytes, 0, array, totalLength, commentBytes.length);
        totalLength += commentBytes.length;
        array[totalLength++] = 10;
        if (response.getCallIdentifier() != null) {
            array[totalLength++] = 67;
            array[totalLength++] = 58;
            byte[] callBytes = response.getCallIdentifier().toString().getBytes();
            System.arraycopy(callBytes, 0, array, totalLength, callBytes.length);
            totalLength += callBytes.length;
            array[totalLength++] = 10;
        }
        if (response.getNotifiedEntity() != null) {
            array[totalLength++] = 78;
            array[totalLength++] = 58;
            totalLength += NotifiedEntityHandler.encode(array, totalLength, response.getNotifiedEntity());
            array[totalLength++] = 10;
        }
        if (response.getLocalConnectionOptions() != null) {
            array[totalLength++] = 76;
            array[totalLength++] = 58;
            totalLength += LocalOptionValueHandler.encodeList(array, totalLength, response.getLocalConnectionOptions());
            array[totalLength++] = 10;
        }
        if (response.getMode() != null) {
            array[totalLength++] = 77;
            array[totalLength++] = 58;
            totalLength += ConnectionModeHandler.encode(array, totalLength, response.getMode());
            array[totalLength++] = 10;
        }
        if (response.getConnectionParms() != null) {
            array[totalLength++] = 80;
            array[totalLength++] = 58;
            totalLength += ConnectionParmHandler.encodeList(array, totalLength, response.getConnectionParms());
            array[totalLength++] = 10;
        }
        if (this.RCfirst && response.getRemoteConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            rcdBytes = response.getRemoteConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        if (response.getLocalConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            byte[] lcdBytes = response.getLocalConnectionDescriptor().toString().getBytes();
            System.arraycopy(lcdBytes, 0, array, totalLength, lcdBytes.length);
            totalLength += lcdBytes.length;
            array[totalLength++] = 10;
        }
        if (!this.RCfirst && response.getRemoteConnectionDescriptor() != null) {
            array[totalLength++] = 10;
            rcdBytes = response.getRemoteConnectionDescriptor().toString().getBytes();
            System.arraycopy(rcdBytes, 0, array, totalLength, rcdBytes.length);
            totalLength += rcdBytes.length;
            array[totalLength++] = 10;
        }
        return totalLength;
    }

    @Override
    public JainMgcpResponseEvent getProvisionalResponse() {
        AuditConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new AuditConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    static /* synthetic */ InfoCode[] access$202(AuditConnectionHandler x0, InfoCode[] x1) {
        x0.requestedInfo = x1;
        return x1;
    }

    private class ResponseContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() != 1) {
                logger.warn((Object)("Unidentified AUCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            } else {
                switch (data[name.getOffset()]) {
                    case 67: 
                    case 99: {
                        AuditConnectionHandler.this.response.setCallIdentifier(new CallIdentifier(new String(data, value.getOffset(), value.getLength())));
                        break;
                    }
                    case 78: 
                    case 110: {
                        NotifiedEntity n = NotifiedEntityHandler.decode(data, value.getOffset(), value.getLength(), true);
                        AuditConnectionHandler.this.response.setNotifiedEntity(n);
                        break;
                    }
                    case 76: 
                    case 108: {
                        LocalOptionValue[] LocalOptionValueList = LocalOptionValueHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditConnectionHandler.this.response.setLocalConnectionOptions(LocalOptionValueList);
                        break;
                    }
                    case 77: 
                    case 109: {
                        ConnectionMode connectionMode = ConnectionModeHandler.decode(data, value.getOffset(), value.getLength());
                        AuditConnectionHandler.this.response.setMode(connectionMode);
                        break;
                    }
                    case 80: 
                    case 112: {
                        ConnectionParm[] connectionParms = ConnectionParmHandler.decodeList(data, value.getOffset(), value.getLength());
                        AuditConnectionHandler.this.response.setConnectionParms(connectionParms);
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified AUCX Response parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                    }
                }
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            StringReader stringReader = new StringReader(sd);
            BufferedReader reader = new BufferedReader(stringReader);
            String line = null;
            boolean sdpPresent = false;
            StringBuffer sdp1 = new StringBuffer();
            StringBuffer sdp2 = new StringBuffer();
            try {
                while ((line = reader.readLine()) != null) {
                    boolean bl = sdpPresent = (line = line.trim()).length() == 0;
                    if (sdpPresent) break;
                    sdp1.append(line.trim()).append("\r\n");
                }
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    sdp2.append(line.trim()).append("\r\n");
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while reading the SDP for AUCX Response and decoding to AUCX command ", (Throwable)e);
            }
            if (AuditConnectionHandler.this.RCfirst) {
                AuditConnectionHandler.this.response.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp1.toString()));
                if (sdp2.length() != 0) {
                    AuditConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sdp2.toString()));
                }
            } else {
                AuditConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sdp1.toString()));
                if (sdp2.length() != 0) {
                    AuditConnectionHandler.this.response.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp2.toString()));
                }
            }
        }
    }

    private class CommandContentHandle
    extends MgcpContentHandler {
        @Override
        public void param(byte[] data, SplitDetails name, SplitDetails value) throws ParseException {
            if (name.getLength() != 1) {
                logger.warn((Object)("Unidentified AUCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
            } else {
                block0 : switch (data[name.getOffset()]) {
                    case 73: 
                    case 105: {
                        AuditConnectionHandler.this.connectionIdentifier = new ConnectionIdentifier(new String(data, value.getOffset(), value.getLength()));
                        break;
                    }
                    case 70: 
                    case 102: {
                        boolean hasLC = false;
                        AuditConnectionHandler.access$202(AuditConnectionHandler.this, InfoCodeHandler.decodeList(data, value.getOffset(), value.getLength()));
                        for (int i = 0; i < AuditConnectionHandler.this.requestedInfo.length; ++i) {
                            if (AuditConnectionHandler.this.requestedInfo[i].getInfoCode() == 17) {
                                if (hasLC) break block0;
                                AuditConnectionHandler.this.RCfirst = true;
                                break block0;
                            }
                            if (AuditConnectionHandler.this.requestedInfo[i].getInfoCode() != 18) continue;
                            hasLC = true;
                        }
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unidentified AUCX Request parameter " + new String(data, name.getOffset(), name.getLength()) + " with value = " + new String(data, value.getOffset(), value.getLength())));
                    }
                }
            }
        }

        @Override
        public void sessionDescription(String sd) throws ParseException {
            throw new ParseException("SessionDescription shouldn't have been included in AUCX command", 0);
        }
    }
}

