/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.CapabilityValue;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.LocalOptVal;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.SupportedModes;
import jain.protocol.ip.mgcp.message.parms.SupportedPackages;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;
import org.mobicents.protocols.mgcp.parser.SplitDetails;
import org.mobicents.protocols.mgcp.parser.StringFunctions;
import org.mobicents.protocols.mgcp.parser.params.BandwidthHandler;
import org.mobicents.protocols.mgcp.parser.params.CompressionAlgorithmHandler;
import org.mobicents.protocols.mgcp.parser.params.ConnectionModeHandler;
import org.mobicents.protocols.mgcp.parser.params.EchoCancellationHandler;
import org.mobicents.protocols.mgcp.parser.params.EncryptionMethodHandler;
import org.mobicents.protocols.mgcp.parser.params.GainControlHandler;
import org.mobicents.protocols.mgcp.parser.params.LocalOptionValueHandler;
import org.mobicents.protocols.mgcp.parser.params.PacketizationPeriodHandler;
import org.mobicents.protocols.mgcp.parser.params.ResourceReservationHandler;
import org.mobicents.protocols.mgcp.parser.params.SilenceSuppressionHandler;
import org.mobicents.protocols.mgcp.parser.params.TypeOfNetworkHandler;
import org.mobicents.protocols.mgcp.parser.params.TypeOfServiceHandler;
import org.mobicents.protocols.mgcp.parser.pkg.PackageNameHandler;

public class CapabilityHandler {
    public static CapabilityValue decode(byte[] value, int offset, int length) throws ParseException {
        if (length > 1 && value[offset + 1] == 58) {
            switch (value[offset]) {
                case 65: 
                case 97: {
                    return new LocalOptVal((LocalOptionValue)CompressionAlgorithmHandler.decode(value, offset + 2, length - 2));
                }
                case 66: 
                case 98: {
                    return new LocalOptVal((LocalOptionValue)BandwidthHandler.decode(value, offset + 2, length - 2));
                }
                case 69: 
                case 101: {
                    return new LocalOptVal((LocalOptionValue)EchoCancellationHandler.decode(value, offset + 2, length - 2));
                }
                case 75: 
                case 107: {
                    return new LocalOptVal((LocalOptionValue)EncryptionMethodHandler.decode(value, offset + 2, length - 2));
                }
                case 80: 
                case 112: {
                    return new LocalOptVal((LocalOptionValue)PacketizationPeriodHandler.decode(value, offset + 2, length - 2));
                }
                case 82: 
                case 114: {
                    return new LocalOptVal((LocalOptionValue)ResourceReservationHandler.decode(value, offset + 2, length - 2));
                }
                case 83: 
                case 115: {
                    return new LocalOptVal((LocalOptionValue)SilenceSuppressionHandler.decode(value, offset + 2, length - 2));
                }
                case 84: 
                case 116: {
                    return new LocalOptVal((LocalOptionValue)TypeOfServiceHandler.decode(value, offset + 2, length - 2));
                }
                case 86: 
                case 118: {
                    PackageName[] supportedPackageNames = PackageNameHandler.decodeList(value, offset + 2, length - 2);
                    return new SupportedPackages(supportedPackageNames);
                }
                case 77: 
                case 109: {
                    ConnectionMode[] supportedConnectionModes = ConnectionModeHandler.decodeList(value, offset + 2, length - 2);
                    return new SupportedModes(supportedConnectionModes);
                }
            }
        } else if (length > 2 && value[offset + 2] == 58) {
            switch (value[offset]) {
                case 78: 
                case 110: {
                    if (value[offset + 1] == 116 || value[offset + 1] == 84) {
                        return new LocalOptVal((LocalOptionValue)TypeOfNetworkHandler.decode(value, offset + 3, length - 3));
                    }
                }
                case 71: 
                case 103: {
                    if (value[offset + 1] != 99 && value[offset + 1] != 67) break;
                    return new LocalOptVal((LocalOptionValue)GainControlHandler.decode(value, offset + 3, length - 3));
                }
            }
        }
        throw new ParseException("Could not parse capability: " + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, CapabilityValue capabilityValue) {
        switch (capabilityValue.getCapabilityValueType()) {
            case 1: {
                LocalOptVal localOptVal = (LocalOptVal)capabilityValue;
                LocalOptionValue localOptionValue = localOptVal.getLocalOptionValue();
                return LocalOptionValueHandler.encode(destination, offset, localOptionValue);
            }
            case 2: {
                destination[offset] = 118;
                destination[offset + 1] = 58;
                SupportedPackages supportedPackages = (SupportedPackages)capabilityValue;
                PackageName[] packageNameList = supportedPackages.getSupportedPackageNames();
                return PackageNameHandler.encodeList(destination, offset + 2, packageNameList) + 2;
            }
            case 3: {
                destination[offset] = 109;
                destination[offset + 1] = 58;
                SupportedModes supportedModes = (SupportedModes)capabilityValue;
                ConnectionMode[] connectionModeList = supportedModes.getSupportedModes();
                return ConnectionModeHandler.encodeList(destination, offset + 2, connectionModeList) + 2;
            }
        }
        return 0;
    }

    public static int encodeList(byte[] destination, int offset, CapabilityValue[] capabilitiesList) {
        int i;
        if (capabilitiesList.length == 0) {
            return 0;
        }
        int totalLength = 0;
        for (i = 0; i < capabilitiesList.length - 1; ++i) {
            totalLength += CapabilityHandler.encode(destination, offset + totalLength, capabilitiesList[i]);
            destination[offset + totalLength] = 44;
            ++totalLength;
        }
        totalLength += CapabilityHandler.encode(destination, offset + totalLength, capabilitiesList[i]);
        return totalLength;
    }

    public static CapabilityValue[] decodeList(byte[] value, int offset, int length) throws ParseException {
        SplitDetails[] splitDetails = StringFunctions.split(value, offset, length, (byte)44);
        CapabilityValue[] capabilities = new CapabilityValue[splitDetails.length];
        for (int i = 0; i < splitDetails.length; ++i) {
            capabilities[i] = CapabilityHandler.decode(value, splitDetails[i].getOffset(), splitDetails[i].getLength());
        }
        return capabilities;
    }
}

