/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g711.alaw;

import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format alaw = FormatFactory.createAudioFormat((String)"pcma", (int)8000, (int)8, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final int cClip = 32635;
    private static byte[] aLawCompressTable = new byte[]{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return alaw;
    }

    public Frame process(Frame frame) {
        Frame res = Memory.allocate((int)(frame.getLength() / 2));
        int len = this.process(frame.getData(), 0, frame.getLength(), res.getData());
        res.setOffset(0);
        res.setLength(len);
        res.setFormat(alaw);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setEOM(frame.isEOM());
        res.setSequenceNumber(frame.getSequenceNumber());
        return res;
    }

    private int process(byte[] src, int offset, int len, byte[] res) {
        int j = offset;
        int count = len / 2;
        short sample = 0;
        for (int i = 0; i < count; ++i) {
            sample = (short)(src[j++] & 0xFF | src[j++] << 8);
            res[i] = this.linearToALawSample(sample);
        }
        return count;
    }

    private byte linearToALawSample(short sample) {
        int s;
        int sign = ~sample >> 8 & 0x80;
        if (sign != 128) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        if (sample >= 256) {
            byte exponent = aLawCompressTable[sample >> 8 & 0x7F];
            int mantissa = sample >> exponent + 3 & 0xF;
            s = exponent << 4 | mantissa;
        } else {
            s = sample >> 4;
        }
        return (byte)(s ^= sign ^ 0x55);
    }
}

