/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g711.ulaw;

import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format ulaw = FormatFactory.createAudioFormat((String)"pcmu", (int)8000, (int)8, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private static final byte[] muLawCompressTable = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final int cBias = 132;
    private static final int cClip = 32635;
    private static short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private byte[] temp = new byte[8192];

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return ulaw;
    }

    public Frame process(Frame frame) {
        byte[] data = frame.getData();
        Frame res = Memory.allocate((int)(data.length / 2));
        int len = this.process(data, 0, data.length, res.getData());
        res.setOffset(0);
        res.setLength(len);
        res.setFormat(ulaw);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setEOM(frame.isEOM());
        res.setSequenceNumber(frame.getSequenceNumber());
        return res;
    }

    private int process(byte[] src, int offset, int len, byte[] res) {
        int j = offset;
        int count = len / 2;
        short sample = 0;
        for (int i = 0; i < count; ++i) {
            sample = (short)(src[j++] & 0xFF | src[j++] << 8);
            res[i] = this.linear2ulaw(sample);
        }
        return count;
    }

    private byte linearToULawSample(short sample) {
        int s;
        int sign = ~sample >> 8 & 0x80;
        if (sign != 128) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        if (sample >= 256) {
            byte exponent = muLawCompressTable[sample >> 8 & 0x7F];
            int mantissa = sample >> exponent + 3 & 0xF;
            s = exponent << 4 | mantissa;
        } else {
            s = sample >> 4;
        }
        return (byte)(s ^= sign ^ 0x55);
    }

    private byte linear2ulaw(short pcm_val) {
        int mask;
        if (pcm_val < 0) {
            pcm_val = (short)(132 - pcm_val);
            mask = 127;
        } else {
            pcm_val = (short)(pcm_val + 132);
            mask = 255;
        }
        int seg = Encoder.search(pcm_val, seg_end, 8);
        if (seg >= 8) {
            return (byte)(0x7F ^ mask);
        }
        byte uval = (byte)(seg << 4 | pcm_val >> seg + 3 & 0xF);
        return (byte)(uval ^ mask);
    }

    private static int search(int val, short[] table, int size) {
        for (int i = 0; i < size; ++i) {
            if (val > table[i]) continue;
            return i;
        }
        return size;
    }
}

