/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.media.server.impl.dsp.audio.g711.alaw;

/**
 *
 * @author oifa yulian
 */
public class EncoderData {

	//encoded data , first dimension is high byte , second dimension is low byte
	public final static byte[][] aLawCompressTable = new byte[256][];

	static
	{
		init0_31();
		init32_63();
		init64_95();
		init96_127();
		init128_159();
		init160_191();
		init192_223();
		init224_255();
	}
	
	private static void init0_31()
	{
		aLawCompressTable[0] = new byte[] {
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda
		};

		aLawCompressTable[1] = new byte[] {
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca
		};

		aLawCompressTable[2] = new byte[] {
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2
		};

		aLawCompressTable[3] = new byte[] {
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa
		};

		aLawCompressTable[4] = new byte[] {
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6
		};

		aLawCompressTable[5] = new byte[] {
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2
		};

		aLawCompressTable[6] = new byte[] {
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee
		};

		aLawCompressTable[7] = new byte[] {
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea
		};

		aLawCompressTable[8] = new byte[] {
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94
		};

		aLawCompressTable[9] = new byte[] {
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96
		};

		aLawCompressTable[10] = new byte[] {
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90
		};

		aLawCompressTable[11] = new byte[] {
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92
		};

		aLawCompressTable[12] = new byte[] {
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c
		};

		aLawCompressTable[13] = new byte[] {
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e
		};

		aLawCompressTable[14] = new byte[] {
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98
		};

		aLawCompressTable[15] = new byte[] {
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a
		};

		aLawCompressTable[16] = new byte[] {
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85
		};

		aLawCompressTable[17] = new byte[] {
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84
		};

		aLawCompressTable[18] = new byte[] {
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87
		};

		aLawCompressTable[19] = new byte[] {
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86
		};

		aLawCompressTable[20] = new byte[] {
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81
		};

		aLawCompressTable[21] = new byte[] {
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80
		};

		aLawCompressTable[22] = new byte[] {
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83
		};

		aLawCompressTable[23] = new byte[] {
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82
		};

		aLawCompressTable[24] = new byte[] {
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d
		};

		aLawCompressTable[25] = new byte[] {
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c
		};

		aLawCompressTable[26] = new byte[] {
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f
		};

		aLawCompressTable[27] = new byte[] {
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e
		};

		aLawCompressTable[28] = new byte[] {
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89
		};

		aLawCompressTable[29] = new byte[] {
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88
		};

		aLawCompressTable[30] = new byte[] {
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b
		};

		aLawCompressTable[31] = new byte[] {
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a
		};
	}
	
	private static void init32_63()
	{
		aLawCompressTable[32] = new byte[] {
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5
		};

		aLawCompressTable[33] = new byte[] {
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5
		};

		aLawCompressTable[34] = new byte[] {
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4
		};

		aLawCompressTable[35] = new byte[] {
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4
		};

		aLawCompressTable[36] = new byte[] {
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7
		};

		aLawCompressTable[37] = new byte[] {
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7
		};

		aLawCompressTable[38] = new byte[] {
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6
		};

		aLawCompressTable[39] = new byte[] {
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6
		};

		aLawCompressTable[40] = new byte[] {
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1
		};

		aLawCompressTable[41] = new byte[] {
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1
		};

		aLawCompressTable[42] = new byte[] {
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0
		};

		aLawCompressTable[43] = new byte[] {
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0
		};

		aLawCompressTable[44] = new byte[] {
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3
		};

		aLawCompressTable[45] = new byte[] {
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3
		};

		aLawCompressTable[46] = new byte[] {
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2
		};

		aLawCompressTable[47] = new byte[] {
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2
		};

		aLawCompressTable[48] = new byte[] {
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd
		};

		aLawCompressTable[49] = new byte[] {
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd
		};

		aLawCompressTable[50] = new byte[] {
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc
		};

		aLawCompressTable[51] = new byte[] {
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc
		};

		aLawCompressTable[52] = new byte[] {
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf
		};

		aLawCompressTable[53] = new byte[] {
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf
		};

		aLawCompressTable[54] = new byte[] {
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe
		};

		aLawCompressTable[55] = new byte[] {
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe
		};

		aLawCompressTable[56] = new byte[] {
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9
		};

		aLawCompressTable[57] = new byte[] {
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9
		};

		aLawCompressTable[58] = new byte[] {
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8
		};

		aLawCompressTable[59] = new byte[] {
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8
		};

		aLawCompressTable[60] = new byte[] {
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb
		};

		aLawCompressTable[61] = new byte[] {
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb
		};

		aLawCompressTable[62] = new byte[] {
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba
		};

		aLawCompressTable[63] = new byte[] {
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba
		};
	}
	
	private static void init64_95()
	{
		aLawCompressTable[64] = new byte[] {
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5
		};

		aLawCompressTable[65] = new byte[] {
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5
		};

		aLawCompressTable[66] = new byte[] {
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5
		};

		aLawCompressTable[67] = new byte[] {
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5
		};

		aLawCompressTable[68] = new byte[] {
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4
		};

		aLawCompressTable[69] = new byte[] {
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4
		};

		aLawCompressTable[70] = new byte[] {
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4
		};

		aLawCompressTable[71] = new byte[] {
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4
		};

		aLawCompressTable[72] = new byte[] {
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7
		};

		aLawCompressTable[73] = new byte[] {
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7
		};

		aLawCompressTable[74] = new byte[] {
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7
		};

		aLawCompressTable[75] = new byte[] {
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7
		};

		aLawCompressTable[76] = new byte[] {
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6
		};

		aLawCompressTable[77] = new byte[] {
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6
		};

		aLawCompressTable[78] = new byte[] {
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6
		};

		aLawCompressTable[79] = new byte[] {
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6
		};

		aLawCompressTable[80] = new byte[] {
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1
		};

		aLawCompressTable[81] = new byte[] {
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1
		};

		aLawCompressTable[82] = new byte[] {
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1
		};

		aLawCompressTable[83] = new byte[] {
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1
		};

		aLawCompressTable[84] = new byte[] {
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0
		};

		aLawCompressTable[85] = new byte[] {
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0
		};

		aLawCompressTable[86] = new byte[] {
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0
		};

		aLawCompressTable[87] = new byte[] {
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0
		};

		aLawCompressTable[88] = new byte[] {
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3
		};

		aLawCompressTable[89] = new byte[] {
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3
		};

		aLawCompressTable[90] = new byte[] {
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3
		};

		aLawCompressTable[91] = new byte[] {
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3
		};

		aLawCompressTable[92] = new byte[] {
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2
		};

		aLawCompressTable[93] = new byte[] {
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2
		};

		aLawCompressTable[94] = new byte[] {
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2
		};

		aLawCompressTable[95] = new byte[] {
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2
		};
	}
	
	private static void init96_127()
	{
		aLawCompressTable[96] = new byte[] {
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad
		};

		aLawCompressTable[97] = new byte[] {
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad
		};

		aLawCompressTable[98] = new byte[] {
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad
		};

		aLawCompressTable[99] = new byte[] {
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad
		};

		aLawCompressTable[100] = new byte[] {
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac
		};

		aLawCompressTable[101] = new byte[] {
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac
		};

		aLawCompressTable[102] = new byte[] {
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac
		};

		aLawCompressTable[103] = new byte[] {
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac
		};

		aLawCompressTable[104] = new byte[] {
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf
		};

		aLawCompressTable[105] = new byte[] {
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf
		};

		aLawCompressTable[106] = new byte[] {
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf
		};

		aLawCompressTable[107] = new byte[] {
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf
		};

		aLawCompressTable[108] = new byte[] {
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae
		};

		aLawCompressTable[109] = new byte[] {
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae
		};

		aLawCompressTable[110] = new byte[] {
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae
		};

		aLawCompressTable[111] = new byte[] {
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae
		};

		aLawCompressTable[112] = new byte[] {
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9
		};

		aLawCompressTable[113] = new byte[] {
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9
		};

		aLawCompressTable[114] = new byte[] {
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9
		};

		aLawCompressTable[115] = new byte[] {
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9
		};

		aLawCompressTable[116] = new byte[] {
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8
		};

		aLawCompressTable[117] = new byte[] {
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8
		};

		aLawCompressTable[118] = new byte[] {
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8
		};

		aLawCompressTable[119] = new byte[] {
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8
		};

		aLawCompressTable[120] = new byte[] {
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab
		};

		aLawCompressTable[121] = new byte[] {
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab
		};

		aLawCompressTable[122] = new byte[] {
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab
		};

		aLawCompressTable[123] = new byte[] {
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab
		};

		aLawCompressTable[124] = new byte[] {
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa
		};

		aLawCompressTable[125] = new byte[] {
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa
		};

		aLawCompressTable[126] = new byte[] {
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa
		};

		aLawCompressTable[127] = new byte[] {
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa
		};
	}
	
	private static void init128_159()
	{
		aLawCompressTable[128] = new byte[] {
			(byte)0x55,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a
		};

		aLawCompressTable[129] = new byte[] {
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a
		};

		aLawCompressTable[130] = new byte[] {
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a
		};

		aLawCompressTable[131] = new byte[] {
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a
		};

		aLawCompressTable[132] = new byte[] {
			(byte)0x2a,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b
		};

		aLawCompressTable[133] = new byte[] {
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b
		};

		aLawCompressTable[134] = new byte[] {
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b
		};

		aLawCompressTable[135] = new byte[] {
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b
		};

		aLawCompressTable[136] = new byte[] {
			(byte)0x2b,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28
		};

		aLawCompressTable[137] = new byte[] {
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28
		};

		aLawCompressTable[138] = new byte[] {
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28
		};

		aLawCompressTable[139] = new byte[] {
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28
		};

		aLawCompressTable[140] = new byte[] {
			(byte)0x28,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29
		};

		aLawCompressTable[141] = new byte[] {
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29
		};

		aLawCompressTable[142] = new byte[] {
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29
		};

		aLawCompressTable[143] = new byte[] {
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29
		};

		aLawCompressTable[144] = new byte[] {
			(byte)0x29,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e
		};

		aLawCompressTable[145] = new byte[] {
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e
		};

		aLawCompressTable[146] = new byte[] {
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e
		};

		aLawCompressTable[147] = new byte[] {
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e
		};

		aLawCompressTable[148] = new byte[] {
			(byte)0x2e,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f
		};

		aLawCompressTable[149] = new byte[] {
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f
		};

		aLawCompressTable[150] = new byte[] {
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f
		};

		aLawCompressTable[151] = new byte[] {
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f
		};

		aLawCompressTable[152] = new byte[] {
			(byte)0x2f,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c
		};

		aLawCompressTable[153] = new byte[] {
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c
		};

		aLawCompressTable[154] = new byte[] {
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c
		};

		aLawCompressTable[155] = new byte[] {
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c
		};

		aLawCompressTable[156] = new byte[] {
			(byte)0x2c,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d
		};

		aLawCompressTable[157] = new byte[] {
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d
		};

		aLawCompressTable[158] = new byte[] {
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d
		};

		aLawCompressTable[159] = new byte[] {
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d
		};
	}
	
	private static void init160_191()
	{
		aLawCompressTable[160] = new byte[] {
			(byte)0x2d,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22
		};

		aLawCompressTable[161] = new byte[] {
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22
		};

		aLawCompressTable[162] = new byte[] {
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22
		};

		aLawCompressTable[163] = new byte[] {
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22
		};

		aLawCompressTable[164] = new byte[] {
			(byte)0x22,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23
		};

		aLawCompressTable[165] = new byte[] {
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23
		};

		aLawCompressTable[166] = new byte[] {
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23
		};

		aLawCompressTable[167] = new byte[] {
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23
		};

		aLawCompressTable[168] = new byte[] {
			(byte)0x23,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20
		};

		aLawCompressTable[169] = new byte[] {
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20
		};

		aLawCompressTable[170] = new byte[] {
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20
		};

		aLawCompressTable[171] = new byte[] {
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20
		};

		aLawCompressTable[172] = new byte[] {
			(byte)0x20,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21
		};

		aLawCompressTable[173] = new byte[] {
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21
		};

		aLawCompressTable[174] = new byte[] {
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21
		};

		aLawCompressTable[175] = new byte[] {
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21
		};

		aLawCompressTable[176] = new byte[] {
			(byte)0x21,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26
		};

		aLawCompressTable[177] = new byte[] {
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26
		};

		aLawCompressTable[178] = new byte[] {
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26
		};

		aLawCompressTable[179] = new byte[] {
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26
		};

		aLawCompressTable[180] = new byte[] {
			(byte)0x26,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27
		};

		aLawCompressTable[181] = new byte[] {
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27
		};

		aLawCompressTable[182] = new byte[] {
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27
		};

		aLawCompressTable[183] = new byte[] {
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27
		};

		aLawCompressTable[184] = new byte[] {
			(byte)0x27,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24
		};

		aLawCompressTable[185] = new byte[] {
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24
		};

		aLawCompressTable[186] = new byte[] {
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24
		};

		aLawCompressTable[187] = new byte[] {
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24
		};

		aLawCompressTable[188] = new byte[] {
			(byte)0x24,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25
		};

		aLawCompressTable[189] = new byte[] {
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25
		};

		aLawCompressTable[190] = new byte[] {
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25
		};

		aLawCompressTable[191] = new byte[] {
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25
		};
	}
	
	private static void init192_223()
	{
		aLawCompressTable[192] = new byte[] {
			(byte)0x25,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a
		};

		aLawCompressTable[193] = new byte[] {
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a
		};

		aLawCompressTable[194] = new byte[] {
			(byte)0x3a,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b
		};

		aLawCompressTable[195] = new byte[] {
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b
		};

		aLawCompressTable[196] = new byte[] {
			(byte)0x3b,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38
		};

		aLawCompressTable[197] = new byte[] {
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38
		};

		aLawCompressTable[198] = new byte[] {
			(byte)0x38,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39
		};

		aLawCompressTable[199] = new byte[] {
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39
		};

		aLawCompressTable[200] = new byte[] {
			(byte)0x39,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e
		};

		aLawCompressTable[201] = new byte[] {
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e
		};

		aLawCompressTable[202] = new byte[] {
			(byte)0x3e,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f
		};

		aLawCompressTable[203] = new byte[] {
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f
		};

		aLawCompressTable[204] = new byte[] {
			(byte)0x3f,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c
		};

		aLawCompressTable[205] = new byte[] {
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c
		};

		aLawCompressTable[206] = new byte[] {
			(byte)0x3c,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d
		};

		aLawCompressTable[207] = new byte[] {
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d
		};

		aLawCompressTable[208] = new byte[] {
			(byte)0x3d,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32
		};

		aLawCompressTable[209] = new byte[] {
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32
		};

		aLawCompressTable[210] = new byte[] {
			(byte)0x32,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33
		};

		aLawCompressTable[211] = new byte[] {
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33
		};

		aLawCompressTable[212] = new byte[] {
			(byte)0x33,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30
		};

		aLawCompressTable[213] = new byte[] {
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30
		};

		aLawCompressTable[214] = new byte[] {
			(byte)0x30,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31
		};

		aLawCompressTable[215] = new byte[] {
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31
		};

		aLawCompressTable[216] = new byte[] {
			(byte)0x31,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36
		};

		aLawCompressTable[217] = new byte[] {
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36
		};

		aLawCompressTable[218] = new byte[] {
			(byte)0x36,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37
		};

		aLawCompressTable[219] = new byte[] {
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37
		};

		aLawCompressTable[220] = new byte[] {
			(byte)0x37,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34
		};

		aLawCompressTable[221] = new byte[] {
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34
		};

		aLawCompressTable[222] = new byte[] {
			(byte)0x34,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35
		};

		aLawCompressTable[223] = new byte[] {
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35
		};
	}
	
	private static void init224_255()
	{
		aLawCompressTable[224] = new byte[] {
			(byte)0x35,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa
		};

		aLawCompressTable[225] = new byte[] {
			(byte)0xa,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb
		};

		aLawCompressTable[226] = new byte[] {
			(byte)0xb,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8
		};

		aLawCompressTable[227] = new byte[] {
			(byte)0x8,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9
		};

		aLawCompressTable[228] = new byte[] {
			(byte)0x9,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe
		};

		aLawCompressTable[229] = new byte[] {
			(byte)0xe,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf
		};

		aLawCompressTable[230] = new byte[] {
			(byte)0xf,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc
		};

		aLawCompressTable[231] = new byte[] {
			(byte)0xc,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd
		};

		aLawCompressTable[232] = new byte[] {
			(byte)0xd,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2
		};

		aLawCompressTable[233] = new byte[] {
			(byte)0x2,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3
		};

		aLawCompressTable[234] = new byte[] {
			(byte)0x3,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0
		};

		aLawCompressTable[235] = new byte[] {
			(byte)0x0,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1
		};

		aLawCompressTable[236] = new byte[] {
			(byte)0x1,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6
		};

		aLawCompressTable[237] = new byte[] {
			(byte)0x6,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7
		};

		aLawCompressTable[238] = new byte[] {
			(byte)0x7,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4
		};

		aLawCompressTable[239] = new byte[] {
			(byte)0x4,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5
		};

		aLawCompressTable[240] = new byte[] {
			(byte)0x5,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b
		};

		aLawCompressTable[241] = new byte[] {
			(byte)0x1b,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19
		};

		aLawCompressTable[242] = new byte[] {
			(byte)0x19,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f
		};

		aLawCompressTable[243] = new byte[] {
			(byte)0x1f,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d
		};

		aLawCompressTable[244] = new byte[] {
			(byte)0x1d,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13
		};

		aLawCompressTable[245] = new byte[] {
			(byte)0x13,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11
		};

		aLawCompressTable[246] = new byte[] {
			(byte)0x11,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17
		};

		aLawCompressTable[247] = new byte[] {
			(byte)0x17,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15
		};

		aLawCompressTable[248] = new byte[] {
			(byte)0x15,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69
		};

		aLawCompressTable[249] = new byte[] {
			(byte)0x69,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d
		};

		aLawCompressTable[250] = new byte[] {
			(byte)0x6d,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61
		};

		aLawCompressTable[251] = new byte[] {
			(byte)0x61,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65
		};

		aLawCompressTable[252] = new byte[] {
			(byte)0x65,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,
			(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,
			(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,
			(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,
			(byte)0x7f,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,
			(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,
			(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,
			(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d
		};

		aLawCompressTable[253] = new byte[] {
			(byte)0x7d,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,
			(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,
			(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,
			(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75
		};

		aLawCompressTable[254] = new byte[] {
			(byte)0x75,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45
		};

		aLawCompressTable[255] = new byte[] {
			(byte)0x45,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,
			(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,
			(byte)0x5b,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,
			(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,
			(byte)0x53,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,
			(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55
		};
	}
}

