/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.media.server.impl.dsp.audio.g711.ulaw;

/**
 *
 * @author oifa yulian
 */
public class EncoderData {

	//encoded data , first dimension is high byte , second dimension is low byte
	public final static byte[][] muLawCompressTable = new byte[256][];

	static
	{
		init0_31();
		init32_63();
		init64_95();
		init96_127();
		init128_159();
		init160_191();
		init192_223();
		init224_255();
	}
	
	private static void init0_31()
	{
		muLawCompressTable[0] = new byte[] {
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,
			(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xef,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,
			(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xee,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,
			(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xed,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,
			(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xec,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,
			(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xeb,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,
			(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xea,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,
			(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe9,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,
			(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe8,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7
		};

		muLawCompressTable[1] = new byte[] {
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,
			(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe7,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,
			(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe6,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,
			(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe5,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,
			(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe4,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,
			(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe3,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,
			(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe2,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,
			(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe1,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,
			(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xe0,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,
			(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xdf,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,
			(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xde,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,
			(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdd,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,
			(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdc,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb
		};

		muLawCompressTable[2] = new byte[] {
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,
			(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xdb,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,
			(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xda,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,
			(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd9,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,
			(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd8,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,
			(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd7,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,
			(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd6,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,
			(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd5,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,
			(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd4,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3
		};

		muLawCompressTable[3] = new byte[] {
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,
			(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd3,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,
			(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd2,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,
			(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd1,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,
			(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xd0,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,
			(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xcf,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,
			(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xce,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd
		};

		muLawCompressTable[4] = new byte[] {
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,
			(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcd,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,
			(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcc,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,
			(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xcb,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,
			(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xca,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9
		};

		muLawCompressTable[5] = new byte[] {
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,
			(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc9,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,
			(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc8,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,
			(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc7,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,
			(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc6,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5
		};

		muLawCompressTable[6] = new byte[] {
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,
			(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc5,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,
			(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc4,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,
			(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc3,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,
			(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc2,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1
		};

		muLawCompressTable[7] = new byte[] {
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,
			(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc1,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,
			(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xc0,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,
			(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbf,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe
		};

		muLawCompressTable[8] = new byte[] {
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,
			(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbe,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,
			(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbd,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc
		};

		muLawCompressTable[9] = new byte[] {
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,
			(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbc,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,
			(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xbb,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba
		};

		muLawCompressTable[10] = new byte[] {
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,
			(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xba,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,
			(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb9,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8
		};

		muLawCompressTable[11] = new byte[] {
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,
			(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb8,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,
			(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb7,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6
		};

		muLawCompressTable[12] = new byte[] {
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,
			(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb6,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,
			(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb5,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4
		};

		muLawCompressTable[13] = new byte[] {
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,
			(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb4,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,
			(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb3,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2
		};

		muLawCompressTable[14] = new byte[] {
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,
			(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb2,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,
			(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb1,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0
		};

		muLawCompressTable[15] = new byte[] {
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,
			(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xb0,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf
		};

		muLawCompressTable[16] = new byte[] {
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,
			(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xaf,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae
		};

		muLawCompressTable[17] = new byte[] {
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,
			(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xae,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad
		};

		muLawCompressTable[18] = new byte[] {
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,
			(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xad,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac
		};

		muLawCompressTable[19] = new byte[] {
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,
			(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xac,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab
		};

		muLawCompressTable[20] = new byte[] {
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,
			(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xab,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa
		};

		muLawCompressTable[21] = new byte[] {
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,
			(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xaa,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9
		};

		muLawCompressTable[22] = new byte[] {
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,
			(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa9,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8
		};

		muLawCompressTable[23] = new byte[] {
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,
			(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa8,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7
		};

		muLawCompressTable[24] = new byte[] {
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,
			(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa7,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6
		};

		muLawCompressTable[25] = new byte[] {
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,
			(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa6,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5
		};

		muLawCompressTable[26] = new byte[] {
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,
			(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa5,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4
		};

		muLawCompressTable[27] = new byte[] {
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,
			(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa4,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3
		};

		muLawCompressTable[28] = new byte[] {
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,
			(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa3,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2
		};

		muLawCompressTable[29] = new byte[] {
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,
			(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa2,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1
		};

		muLawCompressTable[30] = new byte[] {
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,
			(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa1,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0
		};

		muLawCompressTable[31] = new byte[] {
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,
			(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0xa0,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f
		};
	}
	
	private static void init32_63()
	{
		muLawCompressTable[32] = new byte[] {
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f
		};

		muLawCompressTable[33] = new byte[] {
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,
			(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9f,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e
		};

		muLawCompressTable[34] = new byte[] {
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e
		};

		muLawCompressTable[35] = new byte[] {
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,
			(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9e,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d
		};

		muLawCompressTable[36] = new byte[] {
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d
		};

		muLawCompressTable[37] = new byte[] {
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,
			(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9d,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c
		};

		muLawCompressTable[38] = new byte[] {
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c
		};

		muLawCompressTable[39] = new byte[] {
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,
			(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9c,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b
		};

		muLawCompressTable[40] = new byte[] {
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b
		};

		muLawCompressTable[41] = new byte[] {
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,
			(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9b,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a
		};

		muLawCompressTable[42] = new byte[] {
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a
		};

		muLawCompressTable[43] = new byte[] {
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,
			(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x9a,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99
		};

		muLawCompressTable[44] = new byte[] {
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99
		};

		muLawCompressTable[45] = new byte[] {
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,
			(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x99,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98
		};

		muLawCompressTable[46] = new byte[] {
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98
		};

		muLawCompressTable[47] = new byte[] {
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,
			(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x98,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97
		};

		muLawCompressTable[48] = new byte[] {
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97
		};

		muLawCompressTable[49] = new byte[] {
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,
			(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x97,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96
		};

		muLawCompressTable[50] = new byte[] {
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96
		};

		muLawCompressTable[51] = new byte[] {
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,
			(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x96,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95
		};

		muLawCompressTable[52] = new byte[] {
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95
		};

		muLawCompressTable[53] = new byte[] {
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,
			(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x95,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94
		};

		muLawCompressTable[54] = new byte[] {
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94
		};

		muLawCompressTable[55] = new byte[] {
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,
			(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x94,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93
		};

		muLawCompressTable[56] = new byte[] {
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93
		};

		muLawCompressTable[57] = new byte[] {
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,
			(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x93,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92
		};

		muLawCompressTable[58] = new byte[] {
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92
		};

		muLawCompressTable[59] = new byte[] {
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,
			(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x92,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91
		};

		muLawCompressTable[60] = new byte[] {
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91
		};

		muLawCompressTable[61] = new byte[] {
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,
			(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x91,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90
		};

		muLawCompressTable[62] = new byte[] {
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90
		};

		muLawCompressTable[63] = new byte[] {
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,
			(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x90,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f
		};
	}
	
	private static void init64_95()
	{
		muLawCompressTable[64] = new byte[] {
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f
		};

		muLawCompressTable[65] = new byte[] {
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f
		};

		muLawCompressTable[66] = new byte[] {
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f
		};

		muLawCompressTable[67] = new byte[] {
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,
			(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8f,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e
		};

		muLawCompressTable[68] = new byte[] {
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e
		};

		muLawCompressTable[69] = new byte[] {
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e
		};

		muLawCompressTable[70] = new byte[] {
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e
		};

		muLawCompressTable[71] = new byte[] {
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,
			(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8e,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d
		};

		muLawCompressTable[72] = new byte[] {
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d
		};

		muLawCompressTable[73] = new byte[] {
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d
		};

		muLawCompressTable[74] = new byte[] {
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d
		};

		muLawCompressTable[75] = new byte[] {
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,
			(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8d,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c
		};

		muLawCompressTable[76] = new byte[] {
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c
		};

		muLawCompressTable[77] = new byte[] {
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c
		};

		muLawCompressTable[78] = new byte[] {
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c
		};

		muLawCompressTable[79] = new byte[] {
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,
			(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8c,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b
		};

		muLawCompressTable[80] = new byte[] {
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b
		};

		muLawCompressTable[81] = new byte[] {
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b
		};

		muLawCompressTable[82] = new byte[] {
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b
		};

		muLawCompressTable[83] = new byte[] {
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,
			(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8b,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a
		};

		muLawCompressTable[84] = new byte[] {
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a
		};

		muLawCompressTable[85] = new byte[] {
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a
		};

		muLawCompressTable[86] = new byte[] {
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a
		};

		muLawCompressTable[87] = new byte[] {
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,
			(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x8a,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89
		};

		muLawCompressTable[88] = new byte[] {
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89
		};

		muLawCompressTable[89] = new byte[] {
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89
		};

		muLawCompressTable[90] = new byte[] {
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89
		};

		muLawCompressTable[91] = new byte[] {
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,
			(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x89,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88
		};

		muLawCompressTable[92] = new byte[] {
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88
		};

		muLawCompressTable[93] = new byte[] {
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88
		};

		muLawCompressTable[94] = new byte[] {
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88
		};

		muLawCompressTable[95] = new byte[] {
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,
			(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x88,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87
		};
	}
	
	private static void init96_127()
	{
		muLawCompressTable[96] = new byte[] {
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87
		};

		muLawCompressTable[97] = new byte[] {
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87
		};

		muLawCompressTable[98] = new byte[] {
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87
		};

		muLawCompressTable[99] = new byte[] {
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,
			(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x87,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86
		};

		muLawCompressTable[100] = new byte[] {
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86
		};

		muLawCompressTable[101] = new byte[] {
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86
		};

		muLawCompressTable[102] = new byte[] {
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86
		};

		muLawCompressTable[103] = new byte[] {
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,
			(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x86,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85
		};

		muLawCompressTable[104] = new byte[] {
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85
		};

		muLawCompressTable[105] = new byte[] {
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85
		};

		muLawCompressTable[106] = new byte[] {
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85
		};

		muLawCompressTable[107] = new byte[] {
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,
			(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x85,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84
		};

		muLawCompressTable[108] = new byte[] {
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84
		};

		muLawCompressTable[109] = new byte[] {
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84
		};

		muLawCompressTable[110] = new byte[] {
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84
		};

		muLawCompressTable[111] = new byte[] {
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,
			(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x84,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83
		};

		muLawCompressTable[112] = new byte[] {
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83
		};

		muLawCompressTable[113] = new byte[] {
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83
		};

		muLawCompressTable[114] = new byte[] {
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83
		};

		muLawCompressTable[115] = new byte[] {
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,
			(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x83,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82
		};

		muLawCompressTable[116] = new byte[] {
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82
		};

		muLawCompressTable[117] = new byte[] {
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82
		};

		muLawCompressTable[118] = new byte[] {
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82
		};

		muLawCompressTable[119] = new byte[] {
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,
			(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x82,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81
		};

		muLawCompressTable[120] = new byte[] {
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81
		};

		muLawCompressTable[121] = new byte[] {
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81
		};

		muLawCompressTable[122] = new byte[] {
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81
		};

		muLawCompressTable[123] = new byte[] {
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,
			(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x81,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80
		};

		muLawCompressTable[124] = new byte[] {
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80
		};

		muLawCompressTable[125] = new byte[] {
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80
		};

		muLawCompressTable[126] = new byte[] {
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80
		};

		muLawCompressTable[127] = new byte[] {
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,
			(byte)0x80,(byte)0x80,(byte)0x80,(byte)0x80,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,
			(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,
			(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfe,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,
			(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfd,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,
			(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfc,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,
			(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfb,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,
			(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xfa,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,
			(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf9,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,
			(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf8,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,
			(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf7,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,
			(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf6,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,
			(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf5,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,
			(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf4,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,
			(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf3,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,
			(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf2,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,
			(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf1,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,
			(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xf0,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff
		};
	}
	
	private static void init128_159()
	{
		muLawCompressTable[128] = new byte[] {
			(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x75,(byte)0x75,(byte)0x75,
			(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7d,(byte)0x7d,(byte)0x7d,
			(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7f,(byte)0x7f,(byte)0x7f,
			(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x7f,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0
		};

		muLawCompressTable[129] = new byte[] {
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0
		};

		muLawCompressTable[130] = new byte[] {
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0
		};

		muLawCompressTable[131] = new byte[] {
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0
		};

		muLawCompressTable[132] = new byte[] {
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,
			(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x0,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1
		};

		muLawCompressTable[133] = new byte[] {
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1
		};

		muLawCompressTable[134] = new byte[] {
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1
		};

		muLawCompressTable[135] = new byte[] {
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1
		};

		muLawCompressTable[136] = new byte[] {
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,
			(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x1,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2
		};

		muLawCompressTable[137] = new byte[] {
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2
		};

		muLawCompressTable[138] = new byte[] {
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2
		};

		muLawCompressTable[139] = new byte[] {
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2
		};

		muLawCompressTable[140] = new byte[] {
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,
			(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x2,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3
		};

		muLawCompressTable[141] = new byte[] {
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3
		};

		muLawCompressTable[142] = new byte[] {
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3
		};

		muLawCompressTable[143] = new byte[] {
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3
		};

		muLawCompressTable[144] = new byte[] {
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,
			(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x3,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4
		};

		muLawCompressTable[145] = new byte[] {
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4
		};

		muLawCompressTable[146] = new byte[] {
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4
		};

		muLawCompressTable[147] = new byte[] {
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4
		};

		muLawCompressTable[148] = new byte[] {
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,
			(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x4,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5
		};

		muLawCompressTable[149] = new byte[] {
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5
		};

		muLawCompressTable[150] = new byte[] {
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5
		};

		muLawCompressTable[151] = new byte[] {
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5
		};

		muLawCompressTable[152] = new byte[] {
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,
			(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x5,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6
		};

		muLawCompressTable[153] = new byte[] {
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6
		};

		muLawCompressTable[154] = new byte[] {
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6
		};

		muLawCompressTable[155] = new byte[] {
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6
		};

		muLawCompressTable[156] = new byte[] {
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,
			(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x6,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7
		};

		muLawCompressTable[157] = new byte[] {
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7
		};

		muLawCompressTable[158] = new byte[] {
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7
		};

		muLawCompressTable[159] = new byte[] {
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7
		};
	}
	
	private static void init160_191()
	{
		muLawCompressTable[160] = new byte[] {
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,
			(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x7,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8
		};

		muLawCompressTable[161] = new byte[] {
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8
		};

		muLawCompressTable[162] = new byte[] {
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8
		};

		muLawCompressTable[163] = new byte[] {
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8
		};

		muLawCompressTable[164] = new byte[] {
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,
			(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x8,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9
		};

		muLawCompressTable[165] = new byte[] {
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9
		};

		muLawCompressTable[166] = new byte[] {
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9
		};

		muLawCompressTable[167] = new byte[] {
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9
		};

		muLawCompressTable[168] = new byte[] {
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,
			(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0x9,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa
		};

		muLawCompressTable[169] = new byte[] {
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa
		};

		muLawCompressTable[170] = new byte[] {
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa
		};

		muLawCompressTable[171] = new byte[] {
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa
		};

		muLawCompressTable[172] = new byte[] {
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,
			(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xa,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb
		};

		muLawCompressTable[173] = new byte[] {
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb
		};

		muLawCompressTable[174] = new byte[] {
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb
		};

		muLawCompressTable[175] = new byte[] {
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb
		};

		muLawCompressTable[176] = new byte[] {
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,
			(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xb,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc
		};

		muLawCompressTable[177] = new byte[] {
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc
		};

		muLawCompressTable[178] = new byte[] {
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc
		};

		muLawCompressTable[179] = new byte[] {
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc
		};

		muLawCompressTable[180] = new byte[] {
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,
			(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xc,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd
		};

		muLawCompressTable[181] = new byte[] {
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd
		};

		muLawCompressTable[182] = new byte[] {
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd
		};

		muLawCompressTable[183] = new byte[] {
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd
		};

		muLawCompressTable[184] = new byte[] {
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,
			(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xd,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe
		};

		muLawCompressTable[185] = new byte[] {
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe
		};

		muLawCompressTable[186] = new byte[] {
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe
		};

		muLawCompressTable[187] = new byte[] {
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe
		};

		muLawCompressTable[188] = new byte[] {
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,
			(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xe,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf
		};

		muLawCompressTable[189] = new byte[] {
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf
		};

		muLawCompressTable[190] = new byte[] {
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf
		};

		muLawCompressTable[191] = new byte[] {
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf
		};
	}
	
	private static void init192_223()
	{
		muLawCompressTable[192] = new byte[] {
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,
			(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0xf,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10
		};

		muLawCompressTable[193] = new byte[] {
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10
		};

		muLawCompressTable[194] = new byte[] {
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,
			(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x10,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11
		};

		muLawCompressTable[195] = new byte[] {
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11
		};

		muLawCompressTable[196] = new byte[] {
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
			(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12
		};

		muLawCompressTable[197] = new byte[] {
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12
		};

		muLawCompressTable[198] = new byte[] {
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,
			(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x12,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13
		};

		muLawCompressTable[199] = new byte[] {
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13
		};

		muLawCompressTable[200] = new byte[] {
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,
			(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x13,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14
		};

		muLawCompressTable[201] = new byte[] {
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14
		};

		muLawCompressTable[202] = new byte[] {
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,
			(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x14,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15
		};

		muLawCompressTable[203] = new byte[] {
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15
		};

		muLawCompressTable[204] = new byte[] {
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,
			(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x15,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16
		};

		muLawCompressTable[205] = new byte[] {
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16
		};

		muLawCompressTable[206] = new byte[] {
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,
			(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x16,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17
		};

		muLawCompressTable[207] = new byte[] {
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17
		};

		muLawCompressTable[208] = new byte[] {
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,
			(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x17,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18
		};

		muLawCompressTable[209] = new byte[] {
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18
		};

		muLawCompressTable[210] = new byte[] {
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,
			(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x18,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19
		};

		muLawCompressTable[211] = new byte[] {
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19
		};

		muLawCompressTable[212] = new byte[] {
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,
			(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x19,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a
		};

		muLawCompressTable[213] = new byte[] {
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a
		};

		muLawCompressTable[214] = new byte[] {
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,
			(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1a,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b
		};

		muLawCompressTable[215] = new byte[] {
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b
		};

		muLawCompressTable[216] = new byte[] {
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,
			(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1b,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c
		};

		muLawCompressTable[217] = new byte[] {
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c
		};

		muLawCompressTable[218] = new byte[] {
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,
			(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1c,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d
		};

		muLawCompressTable[219] = new byte[] {
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d
		};

		muLawCompressTable[220] = new byte[] {
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,
			(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1d,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e
		};

		muLawCompressTable[221] = new byte[] {
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e
		};

		muLawCompressTable[222] = new byte[] {
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,
			(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1e,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f
		};

		muLawCompressTable[223] = new byte[] {
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f
		};
	}
	
	private static void init224_255()
	{
		muLawCompressTable[224] = new byte[] {
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,
			(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x1f,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20
		};

		muLawCompressTable[225] = new byte[] {
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,
			(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x20,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21
		};

		muLawCompressTable[226] = new byte[] {
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,
			(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x21,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22
		};

		muLawCompressTable[227] = new byte[] {
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,
			(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x22,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23
		};

		muLawCompressTable[228] = new byte[] {
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,
			(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x23,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24
		};

		muLawCompressTable[229] = new byte[] {
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,
			(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x24,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25
		};

		muLawCompressTable[230] = new byte[] {
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,
			(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x25,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26
		};

		muLawCompressTable[231] = new byte[] {
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,
			(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x26,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27
		};

		muLawCompressTable[232] = new byte[] {
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,
			(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x27,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28
		};

		muLawCompressTable[233] = new byte[] {
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,
			(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x28,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29
		};

		muLawCompressTable[234] = new byte[] {
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,
			(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x29,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a
		};

		muLawCompressTable[235] = new byte[] {
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,
			(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2a,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b
		};

		muLawCompressTable[236] = new byte[] {
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,
			(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2b,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c
		};

		muLawCompressTable[237] = new byte[] {
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,
			(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2c,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d
		};

		muLawCompressTable[238] = new byte[] {
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,
			(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2d,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e
		};

		muLawCompressTable[239] = new byte[] {
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,
			(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2e,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f
		};

		muLawCompressTable[240] = new byte[] {
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,
			(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x2f,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30
		};

		muLawCompressTable[241] = new byte[] {
			(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x30,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,
			(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x31,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32
		};

		muLawCompressTable[242] = new byte[] {
			(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x32,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,
			(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x33,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34
		};

		muLawCompressTable[243] = new byte[] {
			(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x34,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,
			(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x35,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36
		};

		muLawCompressTable[244] = new byte[] {
			(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x36,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,
			(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x37,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38
		};

		muLawCompressTable[245] = new byte[] {
			(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x38,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,
			(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x39,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a
		};

		muLawCompressTable[246] = new byte[] {
			(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3a,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,
			(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3b,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c
		};

		muLawCompressTable[247] = new byte[] {
			(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3c,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,
			(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3d,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e
		};

		muLawCompressTable[248] = new byte[] {
			(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3e,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,
			(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x3f,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,
			(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x40,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41
		};

		muLawCompressTable[249] = new byte[] {
			(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x41,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,
			(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x42,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,
			(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x43,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,
			(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x44,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45
		};

		muLawCompressTable[250] = new byte[] {
			(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x45,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,
			(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x46,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,
			(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x47,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,
			(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x48,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49
		};

		muLawCompressTable[251] = new byte[] {
			(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x49,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,
			(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4a,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,
			(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4b,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,
			(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4c,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d
		};

		muLawCompressTable[252] = new byte[] {
			(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4d,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,
			(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4e,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,
			(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x4f,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,
			(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x50,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,
			(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x51,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,
			(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x52,(byte)0x53,(byte)0x53,(byte)0x53,
			(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,
			(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,
			(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53
		};

		muLawCompressTable[253] = new byte[] {
			(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x53,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,
			(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x54,(byte)0x55,(byte)0x55,(byte)0x55,
			(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,
			(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,
			(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,
			(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x55,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,
			(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x56,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,
			(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x57,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,
			(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x58,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,
			(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x59,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,
			(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5a,(byte)0x5b,(byte)0x5b,(byte)0x5b,
			(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,
			(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,
			(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b
		};

		muLawCompressTable[254] = new byte[] {
			(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5b,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,
			(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5c,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,
			(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5d,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,
			(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5e,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,
			(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x5f,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,
			(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x60,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,
			(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x61,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,
			(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x62,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,
			(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x63,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,
			(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x64,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,
			(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x65,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,
			(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x66,(byte)0x67,(byte)0x67,(byte)0x67,
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67
		};

		muLawCompressTable[255] = new byte[] {
			(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x67,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,
			(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x68,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,
			(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x69,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,
			(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6a,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,
			(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6b,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,
			(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6c,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,
			(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6d,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,
			(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6e,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,
			(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x6f,(byte)0x70,(byte)0x70,(byte)0x70,
			(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x70,(byte)0x71,(byte)0x71,(byte)0x71,
			(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x71,(byte)0x72,(byte)0x72,(byte)0x72,
			(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x72,(byte)0x73,(byte)0x73,(byte)0x73,
			(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x73,(byte)0x74,(byte)0x74,(byte)0x74,
			(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x74,(byte)0x75,(byte)0x75,(byte)0x75,
			(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x75,(byte)0x76,(byte)0x76,(byte)0x76,
			(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x76,(byte)0x77,(byte)0x77,(byte)0x77,
			(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x77,(byte)0x78,(byte)0x78,(byte)0x78,
			(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x78,(byte)0x79,(byte)0x79,(byte)0x79,
			(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x79,(byte)0x7a,(byte)0x7a,(byte)0x7a,
			(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7a,(byte)0x7b,(byte)0x7b,(byte)0x7b,
			(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7b,(byte)0x7c,(byte)0x7c,(byte)0x7c,
			(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7c,(byte)0x7d,(byte)0x7d,(byte)0x7d,
			(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7d,(byte)0x7e,(byte)0x7e,(byte)0x7e,
			(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7e,(byte)0x7f,(byte)0x7f,(byte)0x7f
		};
	}
}