/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.mobicents.media.server.impl.dsp.audio.g729.Bits;
import org.mobicents.media.server.impl.dsp.audio.g729.CircularBuffer;
import org.mobicents.media.server.impl.dsp.audio.g729.CodLD8K;
import org.mobicents.media.server.impl.dsp.audio.g729.PreProc;
import org.mobicents.media.server.impl.dsp.audio.g729.Util;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format g729 = FormatFactory.createAudioFormat((String)"g729", (int)8000);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    int frame = 0;
    CodLD8K encoder = new CodLD8K();
    PreProc preProc = new PreProc();
    CircularBuffer circularBuffer = new CircularBuffer(32000);
    int[] prm = new int[11];
    short[] serial = new short[82];
    FileInputStream testData = null;
    FileOutputStream outdbg = null;

    public Encoder() {
        this.preProc.init_pre_process();
        this.encoder.init_coder_ld8k();
    }

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return g729;
    }

    public Frame process(Frame frame) {
        Frame res = null;
        byte[] data = frame.getData();
        this.circularBuffer.addData(data);
        int frameSize = 160;
        byte[] speechWindow = this.circularBuffer.getData(2 * frameSize);
        byte[] resultingBytes = null;
        if (speechWindow == null) {
            resultingBytes = new byte[]{};
        } else {
            byte[] one = new byte[frameSize];
            byte[] two = new byte[frameSize];
            for (int q = 0; q < frameSize; ++q) {
                one[q] = speechWindow[q];
                two[q] = speechWindow[q + frameSize];
            }
            if ((one = this.process(one)).length != (two = this.process(two)).length) {
                throw new RuntimeException("The two frames are not equal in size!");
            }
            res = Memory.allocate((int)(one.length + two.length));
            res.setLength(one.length + two.length);
            byte[] resultBytes = res.getData();
            for (int q = 0; q < one.length; ++q) {
                resultBytes[q] = one[q];
                resultBytes[q + one.length] = two[q];
            }
        }
        res.setOffset(0);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(g729);
        return res;
    }

    public byte[] process(byte[] media) {
        ++this.frame;
        float[] new_speech = new float[media.length];
        short[] shortMedia = Util.byteArrayToShortArray(media);
        for (int i = 0; i < 80; ++i) {
            new_speech[i] = shortMedia[i];
        }
        this.preProc.pre_process(new_speech, 80);
        this.encoder.loadSpeech(new_speech);
        this.encoder.coder_ld8k(this.prm, 0);
        Bits.prm2bits_ld8k(this.prm, this.serial);
        return Bits.toRealBits(this.serial);
    }

    public void processTestDecoderWithFileITUEncoded(Frame buffer) {
    }

    public void processTestFileWithoutDecoding(Frame buffer) {
        byte[] res = null;
        try {
            byte[] data = new byte[20];
            byte[] tmp = new byte[164];
            this.testData.read(tmp);
            short[] sdata = Util.byteArrayToShortArray(tmp);
            byte[] bits = Bits.toRealBits(sdata);
            System.arraycopy(bits, 0, data, 0, 10);
            this.testData.read(tmp);
            sdata = Util.byteArrayToShortArray(tmp);
            bits = Bits.toRealBits(sdata);
            System.arraycopy(bits, 0, data, 10, 10);
            res = data;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

