/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import org.mobicents.media.server.impl.dsp.audio.g729.TabLD8k;

public class Lpc {
    void autocorr(float[] x, int m, float[] r) {
        int i;
        float[] y = new float[240];
        for (i = 0; i < 240; ++i) {
            y[i] = x[i] * TabLD8k.hamwindow[i];
        }
        for (i = 0; i <= m; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < 240 - i; ++j) {
                sum += y[j] * y[j + i];
            }
            r[i] = sum;
        }
        if (r[0] < 1.0f) {
            r[0] = 1.0f;
        }
    }

    void lag_window(int m, float[] r) {
        for (int i = 1; i <= m; ++i) {
            int n = i;
            r[n] = r[n] * TabLD8k.lwindow[i - 1];
        }
    }

    float levinson(float[] r, float[] a, float[] rc) {
        rc[0] = -r[1] / r[0];
        a[0] = 1.0f;
        a[1] = rc[0];
        float err = r[0] + r[1] * rc[0];
        for (int i = 2; i <= 10; ++i) {
            int j;
            float s = 0.0f;
            for (j = 0; j < i; ++j) {
                s += r[i - j] * a[j];
            }
            rc[i - 1] = -s / err;
            for (j = 1; j <= i / 2; ++j) {
                int l = i - j;
                float at = a[j] + rc[i - 1] * a[l];
                int n = l;
                a[n] = a[n] + rc[i - 1] * a[j];
                a[j] = at;
            }
            a[i] = rc[i - 1];
            if (!((err += rc[i - 1] * s) <= 0.0f)) continue;
            err = 0.001f;
        }
        return err;
    }

    void az_lsp(float[] a, float[] lsp, float[] old_lsp) {
        float[] f1 = new float[6];
        float[] f2 = new float[6];
        f1[0] = 1.0f;
        f2[0] = 1.0f;
        int i = 1;
        int j = 10;
        while (i <= 5) {
            f1[i] = a[i] + a[j] - f1[i - 1];
            f2[i] = a[i] - a[j] + f2[i - 1];
            ++i;
            --j;
        }
        int nf = 0;
        int ip = 0;
        float[] coef = f1;
        float xlow = TabLD8k.grid[0];
        float ylow = Lpc.chebyshev(xlow, f1, 5);
        j = 0;
        while (nf < 10 && j < 60) {
            float xint;
            ++j;
            float xhigh = xlow;
            float yhigh = ylow;
            xlow = TabLD8k.grid[j];
            ylow = Lpc.chebyshev(xlow, coef, 5);
            if (!(ylow * yhigh <= 0.0f)) continue;
            --j;
            for (i = 0; i < 4; ++i) {
                float xmid = 0.5f * (xlow + xhigh);
                float ymid = Lpc.chebyshev(xmid, coef, 5);
                if (ylow * ymid <= 0.0f) {
                    yhigh = ymid;
                    xhigh = xmid;
                    continue;
                }
                ylow = ymid;
                xlow = xmid;
            }
            lsp[nf] = xint = xlow - ylow * (xhigh - xlow) / (yhigh - ylow);
            ++nf;
            coef = (ip = 1 - ip) != 0 ? f2 : f1;
            xlow = xint;
            ylow = Lpc.chebyshev(xlow, coef, 5);
        }
        if (nf < 10) {
            for (i = 0; i < 10; ++i) {
                lsp[i] = old_lsp[i];
            }
        }
    }

    static float chebyshev(float x, float[] f, int n) {
        float x2 = 2.0f * x;
        float b2 = 1.0f;
        float b1 = x2 + f[1];
        for (int i = 2; i < n; ++i) {
            float b0 = x2 * b1 - b2 + f[i];
            b2 = b1;
            b1 = b0;
        }
        return x * b1 - b2 + 0.5f * f[n];
    }
}

