/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.gsm;

import org.mobicents.media.server.impl.dsp.audio.gsm.BasicFunctions;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format gsm = FormatFactory.createAudioFormat((String)"gsm", (int)8000);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private short z1 = 0;
    private short mp = 0;
    private short k_temp;
    private short temp;
    private short temp1;
    private short temp2;
    private short temp3;
    private short s1;
    private short msp;
    private short lsp;
    private short smax;
    private short dmax;
    private short scalauto;
    private short di;
    private short sav;
    private short scal;
    private short nc;
    private short bc;
    private short R;
    private short S;
    private short bp;
    private short mc;
    private short xmax;
    private short exp;
    private short itest;
    private short xmaxc;
    private short mant;
    private short[] r = new short[9];
    private short[] rp = new short[9];
    private short[] LAR = new short[9];
    private short[] LARc = new short[9];
    private short[] LARp = new short[9];
    private short[] LARpprev = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private short[] LARpp = new short[9];
    private short[] ACF = new short[9];
    private short[] K = new short[9];
    private short[] P = new short[9];
    private short[] u = new short[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int L_z2 = 0;
    private int L_s2;
    private int L_temp;
    private int L_max;
    private int L_result;
    private int L_power;
    private int i = 0;
    private int j;
    private int k;
    private int em;
    private int[] L_ACF = new int[9];
    private short[] signal = new short[160];
    private short[] dp = new short[120];
    private short[] dpp = new short[40];
    private short[] e = new short[40];
    private short[] ep = new short[40];
    private short[] x = new short[40];
    private short[] xm = new short[13];
    private short[] xmc = new short[13];
    private short[] xmp = new short[13];
    private short[] wt = new short[50];

    public Encoder() {
        while (this.i < 120) {
            this.dp[this.i] = 0;
            ++this.i;
        }
    }

    public Frame process(Frame frame) {
        byte[] data = frame.getData();
        this.i = 0;
        while (this.i < 160) {
            this.signal[this.i] = (short)(data[this.i * 2 + 1] << 8 | data[this.i * 2] & 0xFF);
            ++this.i;
        }
        Frame res = Memory.allocate((int)33);
        data = res.getData();
        this.downscale(this.signal);
        this.offsetCompensation(this.signal);
        this.preemphasis(this.signal);
        this.autocorrelation(this.signal);
        this.computeReflection();
        this.transformToLAR();
        this.quantizationAndCoding();
        this.LARDecoding();
        this.shortTermFiltering(this.signal);
        this.i = 1;
        while (this.i < 9) {
            this.LARpprev[this.i] = this.LARpp[this.i];
            this.LARpp[this.i] = 0;
            ++this.i;
        }
        data[0] = (byte)(0xD0 | this.LARc[1] >> 2 & 0xF);
        data[1] = (byte)(this.LARc[1] << 6 | this.LARc[2] & 0x3F);
        data[2] = (byte)(this.LARc[3] << 3 | this.LARc[4] >> 2 & 7);
        data[3] = (byte)(this.LARc[4] << 6 | (this.LARc[5] & 0xF) << 2 | this.LARc[6] >> 2 & 3);
        data[4] = (byte)(this.LARc[6] << 6 | (this.LARc[7] & 7) << 3 | this.LARc[8] & 7);
        this.k_temp = (short)5;
        this.k = 0;
        while (this.k < 4) {
            this.calculateLTPParams(this.signal, this.k);
            this.longTermAnalysis(this.signal, this.k);
            this.weightingFilter();
            this.gridSelection();
            this.ACPMQuantization();
            this.ACPMInverseQuantization();
            this.RPEPositioning();
            this.updatedp();
            short s = this.k_temp;
            this.k_temp = (short)(s + 1);
            data[s] = (byte)(this.nc << 1 | this.bc >> 1 & 1);
            short s2 = this.k_temp;
            this.k_temp = (short)(s2 + 1);
            data[s2] = (byte)(this.bc << 7 | (this.mc & 3) << 5 | this.xmaxc >> 1 & 0x1F);
            short s3 = this.k_temp;
            this.k_temp = (short)(s3 + 1);
            data[s3] = (byte)(this.xmaxc << 7 | (this.xmc[0] & 7) << 4 | (this.xmc[1] & 7) << 1 | this.xmc[2] >> 2 & 1);
            short s4 = this.k_temp;
            this.k_temp = (short)(s4 + 1);
            data[s4] = (byte)(this.xmc[2] << 6 | (this.xmc[3] & 7) << 3 | this.xmc[4] & 7);
            short s5 = this.k_temp;
            this.k_temp = (short)(s5 + 1);
            data[s5] = (byte)(this.xmc[5] << 5 | (this.xmc[6] & 7) << 2 | this.xmc[7] >> 1 & 3);
            short s6 = this.k_temp;
            this.k_temp = (short)(s6 + 1);
            data[s6] = (byte)(this.xmc[7] << 7 | (this.xmc[8] & 7) << 4 | (this.xmc[9] & 7) << 1 | this.xmc[10] >> 2 & 1);
            short s7 = this.k_temp;
            this.k_temp = (short)(s7 + 1);
            data[s7] = (byte)(this.xmc[10] << 6 | (this.xmc[11] & 7) << 3 | this.xmc[12] & 7);
            ++this.k;
        }
        res.setOffset(0);
        res.setLength(33);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(gsm);
        return res;
    }

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return gsm;
    }

    private void downscale(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            data[this.i] = (short)(data[this.i] >> 3 << 2);
            ++this.i;
        }
    }

    private void offsetCompensation(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            this.s1 = BasicFunctions.sub(data[this.i], this.z1);
            this.z1 = data[this.i];
            this.L_s2 = this.s1;
            this.L_s2 <<= 15;
            this.msp = (short)(this.L_z2 >> 15);
            this.lsp = (short)BasicFunctions.L_sub(this.L_z2, this.msp << 15);
            this.L_s2 = BasicFunctions.L_add(this.L_s2, BasicFunctions.mult_r(this.lsp, (short)32735));
            this.L_z2 = BasicFunctions.L_add(BasicFunctions.L_mult(this.msp, (short)32735) >> 1, this.L_s2);
            data[this.i] = (short)(BasicFunctions.L_add(this.L_z2, 16384) >> 15);
            ++this.i;
        }
    }

    private void preemphasis(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            this.temp = data[this.i];
            data[this.i] = BasicFunctions.add(data[this.i], BasicFunctions.mult_r(this.mp, (short)-28180));
            this.mp = this.temp;
            ++this.i;
        }
    }

    private void autocorrelation(short[] data) {
        this.smax = 0;
        this.i = 0;
        while (this.i < 160) {
            this.temp = BasicFunctions.abs(data[this.i]);
            if (this.temp > this.smax) {
                this.smax = this.temp;
            }
            ++this.i;
        }
        this.scalauto = this.smax == 0 ? (short)0 : BasicFunctions.sub((short)4, BasicFunctions.norm(this.smax << 16));
        if (this.scalauto > 0) {
            this.temp = (short)(16384 >> this.scalauto - 1);
            for (int i = 0; i < 160; ++i) {
                data[i] = BasicFunctions.mult_r(data[i], this.temp);
            }
        }
        this.i = 0;
        while (this.i < 9) {
            this.L_ACF[this.i] = 0;
            this.j = this.i;
            while (this.j < 160) {
                this.L_ACF[this.i] = BasicFunctions.L_add(this.L_ACF[this.i], BasicFunctions.L_mult(data[this.j], data[this.j - this.i]));
                ++this.j;
            }
            ++this.i;
        }
        if (this.scalauto > 0) {
            this.i = 0;
            while (this.i < 160) {
                data[this.i] = (short)(data[this.i] << this.scalauto);
                ++this.i;
            }
        }
    }

    private void computeReflection() {
        if (this.L_ACF[0] == 0) {
            this.i = 1;
            while (this.i < 9) {
                this.r[this.i] = 0;
                ++this.i;
            }
            return;
        }
        this.temp = BasicFunctions.norm(this.L_ACF[0]);
        this.i = 0;
        while (this.i < 9) {
            this.ACF[this.i] = (short)(this.L_ACF[this.i] << this.temp >> 16);
            ++this.i;
        }
        this.i = 1;
        while (this.i < 8) {
            this.K[9 - this.i] = this.ACF[this.i];
            ++this.i;
        }
        this.i = 0;
        while (this.i < 9) {
            this.P[this.i] = this.ACF[this.i];
            ++this.i;
        }
        this.i = 1;
        while (this.i < 9) {
            if (this.P[0] < BasicFunctions.abs(this.P[1])) {
                this.j = this.i;
                while (this.j < 9) {
                    this.r[this.j] = 0;
                    ++this.j;
                }
                return;
            }
            this.r[this.i] = BasicFunctions.div(BasicFunctions.abs(this.P[1]), this.P[0]);
            if (this.P[1] > 0) {
                this.r[this.i] = BasicFunctions.sub((short)0, this.r[this.i]);
            }
            if (this.i == 8) {
                return;
            }
            this.P[0] = BasicFunctions.add(this.P[0], BasicFunctions.mult_r(this.P[1], this.r[this.i]));
            this.j = 1;
            while (this.j <= 8 - this.i) {
                this.P[this.j] = BasicFunctions.add(this.P[this.j + 1], BasicFunctions.mult_r(this.K[9 - this.j], this.r[this.i]));
                this.K[9 - this.j] = BasicFunctions.add(this.K[9 - this.j], BasicFunctions.mult_r(this.K[this.j + 1], this.r[this.i]));
                ++this.j;
            }
            ++this.i;
        }
    }

    private void transformToLAR() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = BasicFunctions.abs(this.r[this.i]);
            this.temp = this.temp < 22118 ? (short)(this.temp >> 1) : (this.temp < 31130 ? BasicFunctions.sub(this.temp, (short)11059) : (short)(BasicFunctions.sub(this.temp, (short)26112) << 2));
            this.LAR[this.i] = this.temp;
            if (this.r[this.i] < 0) {
                this.LAR[this.i] = BasicFunctions.sub((short)0, this.LAR[this.i]);
            }
            ++this.i;
        }
    }

    private void quantizationAndCoding() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = BasicFunctions.mult(BasicFunctions.A[this.i - 1], this.LAR[this.i]);
            this.temp = BasicFunctions.add(this.temp, BasicFunctions.B[this.i - 1]);
            this.temp = BasicFunctions.add(this.temp, (short)256);
            this.LARc[this.i] = (short)(this.temp >> 9);
            if (this.LARc[this.i] > BasicFunctions.MAC[this.i - 1]) {
                this.LARc[this.i] = BasicFunctions.MAC[this.i - 1];
            } else if (this.LARc[this.i] < BasicFunctions.MIC[this.i - 1]) {
                this.LARc[this.i] = BasicFunctions.MIC[this.i - 1];
            }
            this.LARc[this.i] = BasicFunctions.sub(this.LARc[this.i], BasicFunctions.MIC[this.i - 1]);
            ++this.i;
        }
    }

    private void LARDecoding() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = (short)(BasicFunctions.add(this.LARc[this.i], BasicFunctions.MIC[this.i - 1]) << 10);
            this.temp2 = (short)(BasicFunctions.B[this.i - 1] << 1);
            this.temp = BasicFunctions.sub(this.temp, this.temp2);
            this.temp = BasicFunctions.mult_r(BasicFunctions.INVA[this.i - 1], this.temp);
            this.LARpp[this.i] = BasicFunctions.add(this.temp, this.temp);
            ++this.i;
        }
    }

    private void shortTermFiltering(short[] data) {
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 2), (short)(this.LARpp[this.i] >> 2));
            this.LARp[this.i] = BasicFunctions.add(this.LARp[this.i], (short)(this.LARpprev[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermAnalysis(data, 0, 12);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 1), (short)(this.LARpp[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermAnalysis(data, 13, 26);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 2), (short)(this.LARpp[this.i] >> 2));
            this.LARp[this.i] = BasicFunctions.add(this.LARp[this.i], (short)(this.LARpp[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermAnalysis(data, 27, 39);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = this.LARpp[this.i];
            ++this.i;
        }
        this.computeRP();
        this.shortTermAnalysis(data, 40, 159);
    }

    private void computeRP() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = BasicFunctions.abs(this.LARp[this.i]);
            this.temp = this.temp < 11059 ? (short)(this.temp << 1) : (this.temp < 20070 ? BasicFunctions.add(this.temp, (short)11059) : BasicFunctions.add((short)(this.temp >> 2), (short)26112));
            this.rp[this.i] = this.temp;
            if (this.LARp[this.i] < 0) {
                this.rp[this.i] = BasicFunctions.sub((short)0, this.rp[this.i]);
            }
            ++this.i;
        }
    }

    private void shortTermAnalysis(short[] data, int startIndex, int endIndex) {
        this.j = startIndex;
        while (this.j <= endIndex) {
            this.sav = this.di = data[this.j];
            this.i = 1;
            while (this.i < 9) {
                this.temp = BasicFunctions.add(this.u[this.i - 1], BasicFunctions.mult_r(this.rp[this.i], this.di));
                this.di = BasicFunctions.add(this.di, BasicFunctions.mult_r(this.rp[this.i], this.u[this.i - 1]));
                this.u[this.i - 1] = this.sav;
                this.sav = this.temp;
                ++this.i;
            }
            data[this.j] = this.di;
            ++this.j;
        }
    }

    private void calculateLTPParams(short[] data, int step) {
        this.temp2 = (short)(40 * (step + 1));
        this.dmax = 0;
        this.i = 40 * step;
        while (this.i < this.temp2) {
            this.temp = BasicFunctions.abs(data[this.i]);
            if (this.temp > this.dmax) {
                this.dmax = this.temp;
            }
            ++this.i;
        }
        this.temp = 0;
        if (this.dmax == 0) {
            this.scal = 0;
        } else {
            this.temp = BasicFunctions.norm(this.dmax << 16);
        }
        this.scal = this.temp > 6 ? (short)0 : BasicFunctions.sub((short)6, this.temp);
        this.temp2 = (short)(40 * step);
        this.i = 0;
        while (this.i < 40) {
            this.wt[this.i] = (short)(data[this.temp2] >> this.scal);
            this.temp2 = (short)(this.temp2 + 1);
            ++this.i;
        }
        this.L_max = 0;
        this.nc = (short)40;
        this.j = 40;
        while (this.j <= 120) {
            this.L_result = 0;
            this.i = 0;
            while (this.i < 40) {
                this.L_temp = BasicFunctions.L_mult(this.wt[this.i], this.dp[this.i - this.j + 120]);
                this.L_result = BasicFunctions.L_add(this.L_temp, this.L_result);
                ++this.i;
            }
            if (this.L_result > this.L_max) {
                this.nc = (short)this.j;
                this.L_max = this.L_result;
            }
            ++this.j;
        }
        this.L_max >>= BasicFunctions.sub((short)6, this.scal);
        this.i = 0;
        while (this.i < 40) {
            this.wt[this.i] = (short)(this.dp[this.i - this.nc + 120] >> 3);
            ++this.i;
        }
        this.L_power = 0;
        this.i = 0;
        while (this.i < 40) {
            this.L_temp = BasicFunctions.L_mult(this.wt[this.i], this.wt[this.i]);
            this.L_power = BasicFunctions.L_add(this.L_temp, this.L_power);
            ++this.i;
        }
        if (this.L_max <= 0) {
            this.bc = 0;
            return;
        }
        if (this.L_max >= this.L_power) {
            this.bc = (short)3;
            return;
        }
        this.temp = BasicFunctions.norm(this.L_power);
        this.R = (short)(this.L_max << this.temp >> 16);
        this.S = (short)(this.L_power << this.temp >> 16);
        this.bc = 0;
        while (this.bc < 3) {
            if (this.R <= BasicFunctions.mult(this.S, BasicFunctions.DLB[this.bc])) {
                return;
            }
            this.bc = (short)(this.bc + 1);
        }
    }

    private void longTermAnalysis(short[] data, int step) {
        this.bp = BasicFunctions.QLB[this.bc];
        this.temp2 = (short)(40 * step);
        this.i = 0;
        while (this.i < 40) {
            this.dpp[this.i] = BasicFunctions.mult_r(this.bp, this.dp[this.i - this.nc + 120]);
            this.e[this.i] = BasicFunctions.sub(data[this.temp2], this.dpp[this.i]);
            this.temp2 = (short)(this.temp2 + 1);
            ++this.i;
        }
    }

    private void weightingFilter() {
        this.i = 0;
        while (this.i < 5) {
            this.wt[this.i] = 0;
            ++this.i;
        }
        while (this.i < 45) {
            this.wt[this.i] = this.e[this.i - 5];
            ++this.i;
        }
        while (this.i < 50) {
            this.wt[this.i] = 0;
            ++this.i;
        }
        this.i = 0;
        while (this.i < 40) {
            this.L_result = 8192;
            this.j = 0;
            while (this.j < 11) {
                this.L_temp = BasicFunctions.L_mult(this.wt[this.i + this.j], BasicFunctions.H[this.j]);
                this.L_result = BasicFunctions.L_add(this.L_result, this.L_temp);
                ++this.j;
            }
            this.L_result = BasicFunctions.L_add(this.L_result, this.L_result);
            this.L_result = BasicFunctions.L_add(this.L_result, this.L_result);
            this.x[this.i] = (short)(this.L_result >> 16);
            ++this.i;
        }
    }

    private void gridSelection() {
        this.em = 0;
        this.mc = 0;
        this.j = 0;
        while (this.j < 4) {
            this.L_result = 0;
            this.i = 0;
            while (this.i < 13) {
                this.temp = (short)(this.x[this.j + 3 * this.i] >> 2);
                this.L_temp = BasicFunctions.L_mult(this.temp, this.temp);
                this.L_result = BasicFunctions.L_add(this.L_temp, this.L_result);
                ++this.i;
            }
            if (this.L_result > this.em) {
                this.mc = (short)this.j;
                this.em = this.L_result;
            }
            ++this.j;
        }
        this.i = 0;
        while (this.i < 13) {
            this.xm[this.i] = this.x[this.mc + 3 * this.i];
            ++this.i;
        }
    }

    private void ACPMQuantization() {
        this.xmax = 0;
        this.i = 0;
        while (this.i < 13) {
            this.temp = BasicFunctions.abs(this.xm[this.i]);
            if (this.temp > this.xmax) {
                this.xmax = this.temp;
            }
            ++this.i;
        }
        this.exp = 0;
        this.temp = (short)(this.xmax >> 9);
        this.itest = 0;
        this.i = 0;
        while (this.i < 6) {
            if (this.temp <= 0) {
                this.itest = 1;
            }
            this.temp = (short)(this.temp >> 1);
            if (this.itest == 0) {
                this.exp = BasicFunctions.add(this.exp, (short)1);
            }
            ++this.i;
        }
        this.temp = BasicFunctions.add(this.exp, (short)5);
        this.xmaxc = BasicFunctions.add((short)(this.xmax >> this.temp), (short)(this.exp << 3));
        this.exp = 0;
        if (this.xmaxc > 15) {
            this.exp = BasicFunctions.sub((short)(this.xmaxc >> 3), (short)1);
        }
        this.mant = BasicFunctions.sub(this.xmaxc, (short)(this.exp << 3));
        if (this.mant == 0) {
            this.exp = (short)-4;
            this.mant = (short)15;
        } else {
            this.itest = 0;
            this.i = 0;
            while (this.i < 3) {
                if (this.mant > 7) {
                    this.itest = 1;
                }
                if (this.itest == 0) {
                    this.mant = BasicFunctions.add((short)(this.mant << 1), (short)1);
                    this.exp = BasicFunctions.sub(this.exp, (short)1);
                }
                ++this.i;
            }
        }
        this.mant = BasicFunctions.sub(this.mant, (short)8);
        this.temp1 = BasicFunctions.sub((short)6, this.exp);
        this.temp2 = BasicFunctions.NRFAC[this.mant];
        this.i = 0;
        while (this.i < 13) {
            this.temp = (short)(this.xm[this.i] << this.temp1);
            this.temp = BasicFunctions.mult(this.temp, this.temp2);
            this.xmc[this.i] = BasicFunctions.add((short)(this.temp >> 12), (short)4);
            ++this.i;
        }
    }

    private void ACPMInverseQuantization() {
        this.temp1 = BasicFunctions.FAC[this.mant];
        this.temp2 = BasicFunctions.sub((short)6, this.exp);
        this.temp3 = (short)(1 << BasicFunctions.sub(this.temp2, (short)1));
        this.i = 0;
        while (this.i < 13) {
            this.temp = BasicFunctions.sub((short)(this.xmc[this.i] << 1), (short)7);
            this.temp = (short)(this.temp << 12);
            this.temp = BasicFunctions.mult_r(this.temp1, this.temp);
            this.temp = BasicFunctions.add(this.temp, this.temp3);
            this.xmp[this.i] = (short)(this.temp >> this.temp2);
            ++this.i;
        }
    }

    private void RPEPositioning() {
        this.i = 0;
        while (this.i < 40) {
            this.ep[this.i] = 0;
            ++this.i;
        }
        this.i = 0;
        while (this.i < 13) {
            this.ep[this.mc + 3 * this.i] = this.xmp[this.i];
            ++this.i;
        }
    }

    private void updatedp() {
        this.i = 0;
        while (this.i < 80) {
            this.dp[this.i] = this.dp[this.i + 40];
            ++this.i;
        }
        this.temp = 0;
        while (this.i < 120) {
            this.dp[this.i] = BasicFunctions.add(this.ep[this.temp], this.dpp[this.temp]);
            ++this.i;
            this.temp = (short)(this.temp + 1);
        }
    }
}

