/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.gsm;

import org.mobicents.media.server.impl.dsp.audio.gsm.BasicFunctions;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Decoder
implements Codec {
    private static final Format gsm = FormatFactory.createAudioFormat((String)"gsm", (int)8000);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private short k_temp;
    private short temp;
    private short temp1;
    private short temp2;
    private short temp3;
    private short mant;
    private short msr = 0;
    private short nc;
    private short bc;
    private short mc;
    private short xmaxc;
    private short exp;
    private short nr;
    private short nrp = (short)40;
    private short brp;
    private short drpp;
    private short sri;
    private short itest;
    private int i = 0;
    private int j;
    private int k;
    private int l;
    private int framesCount;
    private short[] xmc = new short[13];
    private short[] xmp = new short[13];
    private short[] erp = new short[40];
    private short[] drp = new short[160];
    private short[] result = new short[160];
    private short[] LARc = new short[9];
    private short[] LARp = new short[9];
    private short[] LARpp = new short[9];
    private short[] rp = new short[9];
    private short[] v = new short[9];
    private short[] LARpprev = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int BUFFER_SIZE = 320;
    byte[] resdata;

    public Decoder() {
        while (this.i < 120) {
            this.drp[this.i] = 0;
            ++this.i;
        }
    }

    public Frame process(Frame frame) {
        byte[] data = frame.getData();
        if (data.length == 0) {
            Frame res = Memory.allocate((int)320);
            data = res.getData();
            this.i = 0;
            while (this.i < 320) {
                data[this.i] = 0;
                ++this.i;
            }
            res.setOffset(0);
            res.setLength(320);
            res.setTimestamp(frame.getTimestamp());
            res.setDuration(frame.getDuration());
            res.setSequenceNumber(frame.getSequenceNumber());
            res.setEOM(frame.isEOM());
            res.setFormat(linear);
            return res;
        }
        if (data.length % 33 != 0) {
            throw new IllegalArgumentException("invalid frame size expected 33,received " + data.length);
        }
        this.framesCount = data.length / 33;
        Frame res = Memory.allocate((int)(320 * this.framesCount));
        this.resdata = res.getData();
        this.l = 0;
        while (this.l < data.length / 33) {
            this.k_temp = (short)(this.l * 33);
            if ((data[this.k_temp] >> 4 & 0xF) != 13) {
                throw new IllegalArgumentException("not gsm fr frame,expected 0xD received " + Integer.toHexString(data[this.k_temp] >> 4) + " FRAME SIZE:" + data.length);
            }
            this.LARc[1] = (short)(data[this.k_temp] << 2 & 0x3C | data[this.k_temp + 1] >> 6 & 3);
            this.LARc[2] = (short)(data[this.k_temp + 1] & 0x3F);
            this.LARc[3] = (short)(data[this.k_temp + 2] >> 3 & 0x1F);
            this.LARc[4] = (short)(data[this.k_temp + 2] << 2 & 0x1C | data[this.k_temp + 3] >> 6 & 3);
            this.LARc[5] = (short)(data[this.k_temp + 3] >> 2 & 0xF);
            this.LARc[6] = (short)(data[this.k_temp + 3] << 2 & 0xC | data[this.k_temp + 4] >> 6 & 3);
            this.LARc[7] = (short)(data[this.k_temp + 4] >> 3 & 7);
            this.LARc[8] = (short)(data[this.k_temp + 4] & 7);
            this.LARDecoding();
            this.k_temp = (short)(this.k_temp + 5);
            this.k = 0;
            while (this.k < 4) {
                this.nc = (short)(data[this.k_temp] >> 1 & 0x7F);
                short s = this.k_temp;
                this.k_temp = (short)(s + 1);
                this.bc = (short)(data[s] << 1 & 2 | data[this.k_temp] >> 7 & 1);
                this.mc = (short)(data[this.k_temp] >> 5 & 3);
                short s2 = this.k_temp;
                this.k_temp = (short)(s2 + 1);
                this.xmaxc = (short)(data[s2] << 1 & 0x3E | data[this.k_temp] >> 7 & 1);
                this.xmc[0] = (short)(data[this.k_temp] >> 4 & 7);
                this.xmc[1] = (short)(data[this.k_temp] >> 1 & 7);
                short s3 = this.k_temp;
                this.k_temp = (short)(s3 + 1);
                this.xmc[2] = (short)(data[s3] << 2 & 4 | data[this.k_temp] >> 6 & 3);
                this.xmc[3] = (short)(data[this.k_temp] >> 3 & 7);
                short s4 = this.k_temp;
                this.k_temp = (short)(s4 + 1);
                this.xmc[4] = (short)(data[s4] & 7);
                this.xmc[5] = (short)(data[this.k_temp] >> 5 & 7);
                this.xmc[6] = (short)(data[this.k_temp] >> 2 & 7);
                short s5 = this.k_temp;
                this.k_temp = (short)(s5 + 1);
                this.xmc[7] = (short)(data[s5] << 1 & 6 | data[this.k_temp] >> 7 & 1);
                this.xmc[8] = (short)(data[this.k_temp] >> 4 & 7);
                this.xmc[9] = (short)(data[this.k_temp] >> 1 & 7);
                short s6 = this.k_temp;
                this.k_temp = (short)(s6 + 1);
                this.xmc[10] = (short)(data[s6] << 2 & 4 | data[this.k_temp] >> 6 & 3);
                this.xmc[11] = (short)(data[this.k_temp] >> 3 & 7);
                short s7 = this.k_temp;
                this.k_temp = (short)(s7 + 1);
                this.xmc[12] = (short)(data[s7] & 7);
                this.computeExpAndMant();
                this.ACPMInverseQuantization();
                this.RPEPositioning();
                this.longTermSynthesisFiltering(this.k);
                ++this.k;
            }
            this.shortTermFiltering(this.result);
            this.deemphasisFilter(this.result);
            this.upscale(this.result);
            this.downscale(this.result);
            this.i = 1;
            while (this.i < 9) {
                this.LARpprev[this.i] = this.LARpp[this.i];
                this.LARpp[this.i] = 0;
                ++this.i;
            }
            this.k_temp = (short)(this.l * 320);
            this.i = 0;
            while (this.i < 160) {
                this.resdata[this.k_temp + this.i * 2] = (byte)(this.result[this.i] & 0xFF);
                this.resdata[this.k_temp + this.i * 2 + 1] = (byte)(this.result[this.i] >> 8 & 0xFF);
                ++this.i;
            }
            ++this.l;
        }
        res.setOffset(0);
        res.setLength(320 * this.framesCount);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(linear);
        return res;
    }

    public Format getSupportedInputFormat() {
        return gsm;
    }

    public Format getSupportedOutputFormat() {
        return linear;
    }

    private void LARDecoding() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = (short)(BasicFunctions.add(this.LARc[this.i], BasicFunctions.MIC[this.i - 1]) << 10);
            this.temp2 = (short)(BasicFunctions.B[this.i - 1] << 1);
            this.temp = BasicFunctions.sub(this.temp, this.temp2);
            this.temp = BasicFunctions.mult_r(BasicFunctions.INVA[this.i - 1], this.temp);
            this.LARpp[this.i] = BasicFunctions.add(this.temp, this.temp);
            ++this.i;
        }
    }

    private void computeExpAndMant() {
        this.exp = 0;
        if (this.xmaxc > 15) {
            this.exp = BasicFunctions.sub((short)(this.xmaxc >> 3), (short)1);
        }
        this.mant = BasicFunctions.sub(this.xmaxc, (short)(this.exp << 3));
        if (this.mant == 0) {
            this.exp = (short)-4;
            this.mant = (short)15;
        } else {
            this.itest = 0;
            this.i = 0;
            while (this.i < 3) {
                if (this.mant > 7) {
                    this.itest = 1;
                }
                if (this.itest == 0) {
                    this.mant = BasicFunctions.add((short)(this.mant << 1), (short)1);
                    this.exp = BasicFunctions.sub(this.exp, (short)1);
                }
                ++this.i;
            }
        }
        this.mant = BasicFunctions.sub(this.mant, (short)8);
    }

    private void ACPMInverseQuantization() {
        this.temp1 = BasicFunctions.FAC[this.mant];
        this.temp2 = BasicFunctions.sub((short)6, this.exp);
        this.temp3 = (short)(1 << BasicFunctions.sub(this.temp2, (short)1));
        this.i = 0;
        while (this.i < 13) {
            this.temp = BasicFunctions.sub((short)(this.xmc[this.i] << 1), (short)7);
            this.temp = (short)(this.temp << 12);
            this.temp = BasicFunctions.mult_r(this.temp1, this.temp);
            this.temp = BasicFunctions.add(this.temp, this.temp3);
            this.xmp[this.i] = (short)(this.temp >> this.temp2);
            ++this.i;
        }
    }

    private void RPEPositioning() {
        this.i = 0;
        while (this.i < 40) {
            this.erp[this.i] = 0;
            ++this.i;
        }
        this.i = 0;
        while (this.i < 13) {
            this.erp[this.mc + 3 * this.i] = this.xmp[this.i];
            ++this.i;
        }
    }

    private void longTermSynthesisFiltering(int subframe) {
        this.nr = this.nc;
        if (this.nc < 40) {
            this.nr = this.nrp;
        } else if (this.nc > 120) {
            this.nr = this.nrp;
        }
        this.nrp = this.nr;
        this.brp = BasicFunctions.QLB[this.bc];
        this.i = 0;
        while (this.i < 40) {
            this.drpp = BasicFunctions.mult_r(this.brp, this.drp[this.i - this.nr + 120]);
            this.drp[this.i + 120] = BasicFunctions.add(this.erp[this.i], this.drpp);
            ++this.i;
        }
        this.i = 0;
        while (this.i < 119) {
            this.drp[this.i] = this.drp[this.i + 40];
            ++this.i;
        }
        this.temp = (short)(subframe * 40);
        this.i = 0;
        while (this.i < 40) {
            this.result[this.temp] = this.drp[this.i];
            this.temp = (short)(this.temp + 1);
            ++this.i;
        }
    }

    private void shortTermFiltering(short[] data) {
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 2), (short)(this.LARpp[this.i] >> 2));
            this.LARp[this.i] = BasicFunctions.add(this.LARp[this.i], (short)(this.LARpprev[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermSynthesisFiltering(data, 0, 12);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 1), (short)(this.LARpp[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermSynthesisFiltering(data, 13, 26);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = BasicFunctions.add((short)(this.LARpprev[this.i] >> 2), (short)(this.LARpp[this.i] >> 2));
            this.LARp[this.i] = BasicFunctions.add(this.LARp[this.i], (short)(this.LARpp[this.i] >> 1));
            ++this.i;
        }
        this.computeRP();
        this.shortTermSynthesisFiltering(data, 27, 39);
        this.i = 1;
        while (this.i < 9) {
            this.LARp[this.i] = this.LARpp[this.i];
            ++this.i;
        }
        this.computeRP();
        this.shortTermSynthesisFiltering(data, 40, 159);
    }

    private void computeRP() {
        this.i = 1;
        while (this.i < 9) {
            this.temp = BasicFunctions.abs(this.LARp[this.i]);
            this.temp = this.temp < 11059 ? (short)(this.temp << 1) : (this.temp < 20070 ? BasicFunctions.add(this.temp, (short)11059) : BasicFunctions.add((short)(this.temp >> 2), (short)26112));
            this.rp[this.i] = this.temp;
            if (this.LARp[this.i] < 0) {
                this.rp[this.i] = BasicFunctions.sub((short)0, this.rp[this.i]);
            }
            ++this.i;
        }
    }

    private void shortTermSynthesisFiltering(short[] data, int startIndex, int endIndex) {
        this.j = startIndex;
        while (this.j <= endIndex) {
            this.sri = data[this.j];
            this.i = 1;
            while (this.i < 9) {
                this.sri = BasicFunctions.sub(this.sri, BasicFunctions.mult_r(this.rp[9 - this.i], this.v[8 - this.i]));
                this.v[9 - this.i] = BasicFunctions.add(this.v[8 - this.i], BasicFunctions.mult_r(this.rp[9 - this.i], this.sri));
                ++this.i;
            }
            data[this.j] = this.sri;
            this.v[0] = this.sri;
            ++this.j;
        }
    }

    private void deemphasisFilter(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            data[this.i] = this.msr = (this.temp = BasicFunctions.add(data[this.i], BasicFunctions.mult_r(this.msr, (short)28180)));
            ++this.i;
        }
    }

    private void upscale(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            data[this.i] = BasicFunctions.add(data[this.i], data[this.i]);
            ++this.i;
        }
    }

    private void downscale(short[] data) {
        this.i = 0;
        while (this.i < 160) {
            data[this.i] = (short)(data[this.i] >> 3);
            data[this.i] = (short)(data[this.i] << 3);
            ++this.i;
        }
    }
}

